/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.xpathchooser;

import de.rcenvironment.core.gui.xpathchooser.XPathChooserHelper;
import de.rcenvironment.core.gui.xpathchooser.model.XSDElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class XSDEditingSupport
extends EditingSupport {
    private final int column;
    private final XPathChooserHelper helper;
    private final Tree tree;
    private final TreeViewer treeViewer;
    private ComboBoxCellEditor editor;

    public XSDEditingSupport(XPathChooserHelper aHelper, ColumnViewer viewer, int aColumn) {
        super(viewer);
        assert (aHelper != null);
        assert (viewer != null);
        assert (aColumn > 0);
        this.column = aColumn;
        this.helper = aHelper;
        this.treeViewer = (TreeViewer)viewer;
        this.tree = ((TreeViewer)viewer).getTree();
    }

    protected boolean canEdit(Object element) {
        assert (element != null);
        assert (element instanceof XSDElement);
        assert (this.column >= 1);
        return this.helper.getAttributeValuesForCurrentTreeItem((XSDElement)element, this.column).length > 1;
    }

    protected CellEditor getCellEditor(final Object element) {
        assert (element instanceof XSDElement);
        assert (this.column >= 1);
        final XSDElement elem = (XSDElement)element;
        Object[] values = this.helper.getAttributeValuesForCurrentTreeItem(elem, this.column);
        assert (values != null);
        String value = XPathChooserHelper.getCurrentElementValue(elem, this.column);
        Arrays.sort(values);
        this.editor = new ComboBoxCellEditor((Composite)this.tree, (String[])values);
        final CCombo control = (CCombo)this.editor.getControl();
        control.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                control.setEnabled(false);
                XSDEditingSupport.this.setValue(element, XPathChooserHelper.getCurrentElementValue(elem, XSDEditingSupport.this.column));
                XSDEditingSupport.this.tree.forceFocus();
                XSDEditingSupport.this.helper.selectItem();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        control.setEditable(false);
        int index = control.indexOf(value);
        if (index >= 0) {
            control.select(index);
        }
        this.editor.setFocus();
        return this.editor;
    }

    protected Object getValue(Object element) {
        assert (element instanceof XSDElement);
        XSDElement elem = (XSDElement)element;
        String value = XPathChooserHelper.getCurrentElementValue(elem, this.column);
        return ((CCombo)this.editor.getControl()).indexOf(value);
    }

    protected void setValue(Object element, Object value) {
        assert (element instanceof XSDElement);
        XSDElement elem = (XSDElement)element;
        try {
            CCombo control = (CCombo)this.editor.getControl();
            Field textField = control.getClass().getDeclaredField("text");
            textField.setAccessible(true);
            Text text = (Text)textField.get(control);
            String newValue = text.getText();
            XPathChooserHelper.setCurrentElementValue(elem, this.column, newValue);
            if (this.column == 1) {
                XPathChooserHelper.setCurrentElementValue(elem, 2, elem.getAttributeValues()[0]);
            }
            this.getViewer().update(element, null);
        }
        catch (SecurityException securityException) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)"Catched SecurityException");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)"Catched NoSuchFieldException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)"Catched IllegalArgumentException");
        }
        catch (IllegalAccessException illegalAccessException) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)"Catched IllegalAccessException");
        }
    }
}

