/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.list;

import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.gui.workflow.view.list.WorkflowStateModel;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class WorkflowInformationColumnSorter
extends ViewerSorter {
    private static final int FIRST_IS_EQUAL = 0;
    private static final int FIRST_IS_GREATER = 1;
    private static final int FIRST_IS_LESS = -1;
    private static final int SORT_ASCENDING = 1;
    private static final int SORT_DESCENDING = 2;
    private int direction = 2;
    private int columnToSort = 3;

    public void setColumn(int column) {
        if (column == this.columnToSort) {
            this.direction = 1 == this.direction ? 2 : 1;
        } else {
            this.columnToSort = column;
            this.direction = 1;
        }
    }

    public int compare(Viewer viewer, Object object1, Object object2) {
        int returnValue = 0;
        if (object1 instanceof WorkflowExecutionInformation && object2 instanceof WorkflowExecutionInformation) {
            WorkflowExecutionInformation p1 = (WorkflowExecutionInformation)object1;
            WorkflowExecutionInformation p2 = (WorkflowExecutionInformation)object2;
            switch (this.columnToSort) {
                case 0: {
                    returnValue = p1.getInstanceName().compareToIgnoreCase(p2.getInstanceName());
                    break;
                }
                case 1: {
                    WorkflowState state1 = WorkflowStateModel.getInstance().getState(p1.getExecutionIdentifier());
                    WorkflowState state2 = WorkflowStateModel.getInstance().getState(p2.getExecutionIdentifier());
                    returnValue = state1.getDisplayName().compareTo(state2.getDisplayName());
                    break;
                }
                case 2: {
                    if (p1.getNodeId() == null) {
                        returnValue = 1;
                        break;
                    }
                    if (p2.getNodeId() == null) {
                        returnValue = -1;
                        break;
                    }
                    returnValue = p1.getNodeId().getAssociatedDisplayName().compareTo(p2.getNodeId().getAssociatedDisplayName());
                    break;
                }
                case 3: {
                    if (p1.getStartTime() == p2.getStartTime()) {
                        returnValue = 0;
                        break;
                    }
                    if (p1.getStartTime() > p2.getStartTime()) {
                        returnValue = 1;
                        break;
                    }
                    returnValue = -1;
                    break;
                }
                case 4: {
                    if (p1.getNodeIdStartedExecution() == null) {
                        returnValue = 1;
                        break;
                    }
                    if (p2.getNodeIdStartedExecution() == null) {
                        returnValue = -1;
                        break;
                    }
                    returnValue = p1.getNodeIdStartedExecution().getAssociatedDisplayName().compareTo(p2.getNodeIdStartedExecution().getAssociatedDisplayName());
                    break;
                }
                case 5: {
                    if (p1.getAdditionalInformationProvidedAtStart() == null) {
                        returnValue = 1;
                        break;
                    }
                    if (p2.getAdditionalInformationProvidedAtStart() == null) {
                        returnValue = -1;
                        break;
                    }
                    returnValue = p1.getAdditionalInformationProvidedAtStart().compareTo(p2.getAdditionalInformationProvidedAtStart());
                    break;
                }
            }
            if (2 == this.direction) {
                returnValue = -returnValue;
            }
        }
        return returnValue;
    }
}

