/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands.endpoint;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.EditDynamicInputWithOutputCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import java.util.HashMap;
import java.util.Map;

public class EditDynamicInputWithOutputsCommand
extends EditDynamicInputWithOutputCommand {
    private final String nameSuffix;
    private Map<String, String> metaDataOutputWithSuffix;

    public EditDynamicInputWithOutputsCommand(EndpointDescription oldDescription, EndpointDescription newDescription, String nameSuffix, Refreshable ... panes) {
        super(oldDescription, newDescription, panes);
        this.nameSuffix = nameSuffix;
    }

    @Override
    public void execute() {
        EndpointDescriptionsManager outputManager = this.getProperties().getOutputDescriptionsManager();
        EndpointDescription addOutputDesc = outputManager.getEndpointDescription(String.valueOf(this.oldDesc.getName()) + this.nameSuffix);
        addOutputDesc.setName(String.valueOf(this.newDesc.getName()) + this.nameSuffix);
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.putAll(this.newDesc.getMetaData());
        metaData.putAll(this.metaDataOutputWithSuffix);
        outputManager.editDynamicEndpointDescription(String.valueOf(this.oldDesc.getName()) + this.nameSuffix, String.valueOf(this.newDesc.getName()) + this.nameSuffix, this.newDesc.getDataType(), metaData);
        super.execute();
    }

    @Override
    public void undo() {
        EndpointDescriptionsManager outputManager = this.getProperties().getOutputDescriptionsManager();
        EndpointDescription outputConvergedDesc = this.getProperties().getOutputDescriptionsManager().getEndpointDescription(String.valueOf(this.newDesc.getName()) + this.nameSuffix);
        outputConvergedDesc.setName(String.valueOf(this.oldDesc.getName()) + this.nameSuffix);
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.putAll(this.oldDesc.getMetaData());
        metaData.putAll(this.metaDataOutputWithSuffix);
        outputManager.editDynamicEndpointDescription(String.valueOf(this.newDesc.getName()) + this.nameSuffix, String.valueOf(this.oldDesc.getName()) + this.nameSuffix, this.oldDesc.getDataType(), metaData);
        super.undo();
    }

    public void setMetaDataOutputWithSuffix(Map<String, String> metaDataOutput) {
        this.metaDataOutputWithSuffix = metaDataOutput;
    }
}

