/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow;

import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.Location;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.parts.ConnectionWrapper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConnectionUtils {
    private static final Log LOGGER = LogFactory.getLog(ConnectionUtils.class);

    private ConnectionUtils() {
    }

    public static List<Connection> getConnectionsBetweenNodes(WorkflowNode sourceNode, WorkflowNode targetNode, WorkflowDescription workflowDescription) {
        ArrayList<Connection> connectionsBetweenNodes = new ArrayList<Connection>();
        if (sourceNode != null && targetNode != null && workflowDescription != null) {
            for (Connection connection : workflowDescription.getConnections()) {
                if ((!connection.getSourceNode().getIdentifierAsObject().equals((Object)sourceNode.getIdentifierAsObject()) || !connection.getTargetNode().getIdentifierAsObject().equals((Object)targetNode.getIdentifierAsObject())) && (!connection.getSourceNode().getIdentifierAsObject().equals((Object)targetNode.getIdentifierAsObject()) || !connection.getTargetNode().getIdentifierAsObject().equals((Object)sourceNode.getIdentifierAsObject()))) continue;
                connectionsBetweenNodes.add(connection);
            }
        }
        return connectionsBetweenNodes;
    }

    public static List<Connection> getConnectionsFromSourceToTarget(WorkflowNode sourceNode, WorkflowNode targetNode, WorkflowDescription workflowDescription) {
        ArrayList<Connection> connectionsBetweenNodes = new ArrayList<Connection>();
        if (sourceNode != null && targetNode != null && workflowDescription != null) {
            for (Connection connection : workflowDescription.getConnections()) {
                if (!connection.getSourceNode().getIdentifierAsObject().equals((Object)sourceNode.getIdentifierAsObject()) || !connection.getTargetNode().getIdentifierAsObject().equals((Object)targetNode.getIdentifierAsObject())) continue;
                connectionsBetweenNodes.add(connection);
            }
        }
        return connectionsBetweenNodes;
    }

    public static List<Location> findAlreadyExistentBendpointsBySourceAndTargetIgnoringDirection(WorkflowNode source, WorkflowNode target, WorkflowDescription workflowDescription) {
        List<Object> alreadyExistentBendpoints = new ArrayList<Location>();
        for (Connection connection : workflowDescription.getConnections()) {
            if (connection.getSourceNode().getIdentifierAsObject().equals((Object)source.getIdentifierAsObject()) && connection.getTargetNode().getIdentifierAsObject().equals((Object)target.getIdentifierAsObject())) {
                alreadyExistentBendpoints = connection.getBendpoints();
                break;
            }
            if (!connection.getSourceNode().getIdentifierAsObject().equals((Object)target.getIdentifierAsObject()) || !connection.getTargetNode().getIdentifierAsObject().equals((Object)source.getIdentifierAsObject())) continue;
            for (Location l : connection.getBendpoints()) {
                alreadyExistentBendpoints.add(0, l);
            }
        }
        return alreadyExistentBendpoints;
    }

    public static List<Location> findAlreadyExistentBendpointsFromSourceToTarget(WorkflowNode source, WorkflowNode target, WorkflowDescription workflowDescription) {
        List<Object> alreadyExistentBendpoints = new ArrayList<Location>();
        for (Connection connection : workflowDescription.getConnections()) {
            if (!connection.getSourceNode().getIdentifierAsObject().equals((Object)source.getIdentifierAsObject()) || !connection.getTargetNode().getIdentifierAsObject().equals((Object)target.getIdentifierAsObject())) continue;
            alreadyExistentBendpoints = connection.getBendpoints();
            break;
        }
        return alreadyExistentBendpoints;
    }

    public static List<Location> translateBendpointListByOffset(List<Location> originalBendpoints, int bendpointOffsetX, int bendpointOffsetY) {
        ArrayList<Location> bendpointsWithOffset = new ArrayList<Location>();
        for (Location originalLocation : originalBendpoints) {
            bendpointsWithOffset.add(new Location(originalLocation.x + bendpointOffsetX, originalLocation.y + bendpointOffsetY));
        }
        return bendpointsWithOffset;
    }

    public static void validateConnectionWrapperForEqualBendpointLocations(WorkflowDescription workflowDescription, ConnectionWrapper connectionWrapper, String classAndMethod) {
        List<Connection> connections = ConnectionUtils.getConnectionsByWrapperSameDirection(workflowDescription, connectionWrapper);
        ConnectionUtils.validateConnections(connections, classAndMethod);
    }

    public static void validateConnections(List<Connection> connections, String classAndMethod) {
        int numberOfBendpoints = connections.get(0).getBendpoints().size();
        for (Connection connection : connections) {
            if (ConnectionUtils.checkIfBendpointListsAreEqual(connections.get(0).getBendpoints(), connection.getBendpoints())) continue;
            LOGGER.error((Object)("Connections' bendpoints are inconsistent! Connection between '" + connection.getSourceNode().getName() + "' and '" + connection.getTargetNode().getName() + "' is affected. It has " + connection.getBendpoints().size() + " bendpoints (" + connection.getBendpoints() + "), but should have " + numberOfBendpoints + " bendpoints (" + connections.get(0).getBendpoints() + "). Caused by " + classAndMethod));
            break;
        }
    }

    private static boolean checkIfBendpointListsAreEqual(List<Location> bendpointList, List<Location> bendpointListToCompare) {
        if (bendpointList.size() != bendpointListToCompare.size()) {
            return false;
        }
        int i = 0;
        while (i < bendpointList.size()) {
            if (bendpointList.get((int)i).x != bendpointListToCompare.get((int)i).x && bendpointList.get((int)i).x != bendpointListToCompare.get((int)(bendpointList.size() - i - 1)).x || bendpointList.get((int)i).y != bendpointListToCompare.get((int)i).y && bendpointList.get((int)i).y != bendpointListToCompare.get((int)(bendpointList.size() - i - 1)).y) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static List<Connection> getConnectionsByWrapperIgnoreOrientation(WorkflowDescription workflowDescription, ConnectionWrapper connectionWrapper) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (Connection connectionInModel : workflowDescription.getConnections()) {
            if ((!connectionWrapper.getSource().getIdentifierAsObject().equals((Object)connectionInModel.getSourceNode().getIdentifierAsObject()) || !connectionWrapper.getTarget().getIdentifierAsObject().equals((Object)connectionInModel.getTargetNode().getIdentifierAsObject())) && (!connectionWrapper.getTarget().getIdentifierAsObject().equals((Object)connectionInModel.getSourceNode().getIdentifierAsObject()) || !connectionWrapper.getSource().getIdentifierAsObject().equals((Object)connectionInModel.getTargetNode().getIdentifierAsObject()))) continue;
            connections.add(connectionInModel);
        }
        return connections;
    }

    public static List<Connection> getConnectionsByWrapperSameDirection(WorkflowDescription workflowDescription, ConnectionWrapper connectionWrapper) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (Connection connectionInModel : workflowDescription.getConnections()) {
            if (!connectionWrapper.getSource().getIdentifierAsObject().equals((Object)connectionInModel.getSourceNode().getIdentifierAsObject()) || !connectionWrapper.getTarget().getIdentifierAsObject().equals((Object)connectionInModel.getTargetNode().getIdentifierAsObject())) continue;
            connections.add(connectionInModel);
        }
        return connections;
    }
}

