/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionPermitsService;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.spi.DistributedComponentKnowledgeListener;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.LogFactory;

public class ComponentExecutionPermitsServiceImpl
implements ComponentExecutionPermitsService,
DistributedComponentKnowledgeListener {
    private DistributedComponentKnowledgeService componentKnowledgeService;
    private Map<String, ResizableSemaphore> semaphores = null;

    @Override
    public void onDistributedComponentKnowledgeChanged(DistributedComponentKnowledge newState) {
        this.updateSemaphores(newState);
    }

    private synchronized void updateSemaphores(DistributedComponentKnowledge componentKnowledge) {
        if (this.semaphores == null) {
            this.semaphores = Collections.synchronizedMap(new HashMap());
        }
        for (DistributedComponentEntry entry : componentKnowledge.getAllInstallations()) {
            ComponentInstallation compInstallation = entry.getComponentInstallation();
            if (compInstallation.getMaximumCountOfParallelInstances() == null) continue;
            if (!this.semaphores.containsKey(compInstallation.getInstallationId())) {
                this.semaphores.put(compInstallation.getInstallationId(), new ResizableSemaphore(compInstallation.getMaximumCountOfParallelInstances()));
                continue;
            }
            this.semaphores.get(compInstallation.getInstallationId()).updateMaximumPermits(compInstallation.getMaximumCountOfParallelInstances());
        }
    }

    @Override
    public synchronized Future<Boolean> acquire(final String componentIdentifier, final String executionIdentifier) {
        if (this.semaphores == null) {
            this.updateSemaphores(this.componentKnowledgeService.getCurrentSnapshot());
        }
        final ResizableSemaphore semaphore = this.semaphores.get(componentIdentifier);
        return ConcurrencyUtils.getAsyncTaskService().submit((Callable)new Callable<Boolean>(){

            @Override
            @TaskDescription(value="Acquire component execution permit")
            public Boolean call() throws Exception {
                boolean aquired = false;
                if (semaphore != null) {
                    try {
                        semaphore.acquire();
                        aquired = true;
                    }
                    catch (InterruptedException interruptedException) {
                        LogFactory.getLog(this.getClass()).debug((Object)StringUtils.format((String)"Interupted while waiting for execution permit for component '%s' - %s", (Object[])new Object[]{componentIdentifier, executionIdentifier}));
                    }
                }
                return aquired;
            }
        }, StringUtils.format((String)"Waiting for execution permit for component '%s' - %s", (Object[])new Object[]{componentIdentifier, executionIdentifier}));
    }

    @Override
    public synchronized void release(String componentIdentifier) {
        if (this.semaphores == null) {
            this.updateSemaphores(this.componentKnowledgeService.getCurrentSnapshot());
        }
        if (this.semaphores.containsKey(componentIdentifier)) {
            this.semaphores.get(componentIdentifier).release();
        }
    }

    protected void bindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService service) {
        this.componentKnowledgeService = service;
    }

    private class ReducableSemaphore
    extends Semaphore {
        private static final long serialVersionUID = 5372099537410330875L;

        protected ReducableSemaphore(int maxPermits) {
            super(maxPermits, true);
        }

        @Override
        protected void reducePermits(int reduction) {
            super.reducePermits(reduction);
        }
    }

    private class ResizableSemaphore {
        private static final int MINUS_ONE = -1;
        private final ReducableSemaphore semaphore;
        private int maxPermits;

        protected ResizableSemaphore(int maxPermits) {
            this.semaphore = new ReducableSemaphore(maxPermits);
            this.maxPermits = maxPermits;
        }

        protected void acquire() throws InterruptedException {
            this.semaphore.acquire();
        }

        protected synchronized void release() {
            if (this.semaphore.availablePermits() < this.maxPermits) {
                this.semaphore.release();
            }
        }

        protected void updateMaximumPermits(int newMaxPermits) {
            int diff = this.maxPermits - newMaxPermits;
            if (diff < 0) {
                this.semaphore.release(diff * -1);
            } else if (diff > 0) {
                this.semaphore.reducePermits(diff);
            }
            this.maxPermits = newMaxPermits;
        }
    }
}

