/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.workflow.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.component.integration.ToolIntegrationContext;
import de.rcenvironment.core.component.integration.ToolIntegrationContextRegistry;
import de.rcenvironment.core.component.integration.ToolIntegrationService;
import de.rcenvironment.core.component.integration.workflow.WorkflowIntegrationService;
import de.rcenvironment.core.component.integration.workflow.internal.EndpointAdapterToJsonConverter;
import de.rcenvironment.core.component.integration.workflow.internal.WorkflowIntegrationContext;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescriptionPersistenceHandler;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.workflow.execution.function.EndpointAdapters;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class WorkflowIntegrationServiceImpl
implements WorkflowIntegrationService {
    private static final String CONFIGURATION_FILENAME = "configuration.json";
    private static final String CONFIGURATION_TEMPLATE_FILENAME = "configuration.json";
    private static final String INTEGRATED_WORKFLOW_FILENAME = "workflow.wf";
    private ConfigurationService configurationService;
    private WorkflowIntegrationContext integrationContext;
    private ToolIntegrationService toolIntegrationService;

    @Override
    public void integrateWorkflowFileAsComponent(WorkflowDescription workflowDescription, String componentname, EndpointAdapters endpointAdapterDefinitions) throws IOException {
        this.toolIntegrationService.setFileWatcherActive(false);
        this.writeWorkflowFileToIntegrationDirectory(workflowDescription, componentname);
        this.constructAndWriteConfigurationToIntegrationDirectory(componentname, endpointAdapterDefinitions);
        this.toolIntegrationService.setFileWatcherActive(true);
        this.toolIntegrationService.registerRecursive(componentname, (ToolIntegrationContext)this.integrationContext);
    }

    private void writeWorkflowFileToIntegrationDirectory(WorkflowDescription workflowDescription, String componentname) throws IOException {
        File workflowFileTarget = this.createWorkflowFile(componentname);
        this.createParentDirectories(workflowFileTarget);
        this.writeWorkflowDescriptionToFile(workflowDescription, workflowFileTarget);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeWorkflowDescriptionToFile(WorkflowDescription workflowDescription, File workflowFileTarget) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            ByteArrayOutputStream byteOutputStream = this.writeDescriptionToStream(workflowDescription);
            try {
                try (OutputStream fileOutputStream = this.createFileOutputStream(workflowFileTarget);){
                    byteOutputStream.writeTo(fileOutputStream);
                }
                if (byteOutputStream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (byteOutputStream == null) throw throwable;
                byteOutputStream.close();
                throw throwable;
            }
            byteOutputStream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    protected ByteArrayOutputStream writeDescriptionToStream(WorkflowDescription workflowDescription) throws IOException {
        WorkflowDescriptionPersistenceHandler persistenceHandler = new WorkflowDescriptionPersistenceHandler();
        return persistenceHandler.writeWorkflowDescriptionToStream(workflowDescription);
    }

    private void constructAndWriteConfigurationToIntegrationDirectory(String componentname, EndpointAdapters endpointAdapterDefinitions) throws IOException {
        Map<String, Object> configuration = this.getConfigurationForWorkflowIntegration(componentname, endpointAdapterDefinitions);
        OutputStream outputStream = this.constructOutputStreamForConfiguration(componentname);
        this.writeMapToJson(configuration, outputStream);
    }

    private OutputStream constructOutputStreamForConfiguration(String componentname) throws FileNotFoundException {
        File configurationFileTarget = this.createConfigurationFile(componentname);
        return this.createFileOutputStream(configurationFileTarget);
    }

    private String getPathToWorkflowIntegrationDirectory() {
        return String.join((CharSequence)File.separator, this.configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.DEFAULT_WRITEABLE_INTEGRATION_ROOT).getAbsolutePath(), this.integrationContext.getNameOfToolIntegrationDirectory());
    }

    private Map<String, Object> getConfigurationForWorkflowIntegration(String componentname, EndpointAdapters endpointAdapterDefinitions) throws IOException {
        InputStream configurationTemplateStream = this.createConfigurationTemplateStream();
        Map<String, Object> configurationTemplate = this.parseJson(configurationTemplateStream);
        return this.injectValuesIntoConfigurationTemplate(configurationTemplate, componentname, endpointAdapterDefinitions);
    }

    private Map<String, Object> injectValuesIntoConfigurationTemplate(Map<String, Object> configurationTemplate, String componentname, EndpointAdapters endpointAdapterDefinitions) throws IOException {
        configurationTemplate.put("toolName", componentname);
        EndpointAdapterToJsonConverter endpointAdapterConverter = new EndpointAdapterToJsonConverter(endpointAdapterDefinitions);
        configurationTemplate.put("inputs", endpointAdapterConverter.toInputDefinitions());
        configurationTemplate.put("outputs", endpointAdapterConverter.toOutputDefinitions());
        List<Map<String, Object>> endpointAdapterConfiguration = endpointAdapterConverter.toEndpointAdapterDefinitions();
        try {
            String endpointAdapters = new ObjectMapper().writeValueAsString(endpointAdapterConfiguration);
            configurationTemplate.put("endpointAdapters", endpointAdapters);
        }
        catch (JsonProcessingException e) {
            throw new IOException("Could not unparse endpoint adapter definition to JSON", e);
        }
        return configurationTemplate;
    }

    protected InputStream createConfigurationTemplateStream() {
        return this.getClass().getClassLoader().getResourceAsStream("configuration.json");
    }

    protected Map<String, Object> parseJson(InputStream configurationTemplateStream) throws IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        Map configurationTemplate = (Map)mapper.readValue(configurationTemplateStream, HashMap.class);
        return configurationTemplate;
    }

    protected void writeMapToJson(Map<String, Object> configuration, OutputStream outputStream) throws IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        mapper.writeValue(outputStream, configuration);
    }

    private File createConfigurationFile(String componentname) {
        String configurationFilePath = String.join((CharSequence)File.separator, this.getPathToWorkflowIntegrationDirectory(), String.valueOf(this.integrationContext.getToolDirectoryPrefix()) + componentname, "configuration.json");
        return this.createFile(configurationFilePath);
    }

    private File createWorkflowFile(String componentname) {
        String workflowFilePath = String.join((CharSequence)File.separator, this.getToolIntegrationDirectoryPath(componentname), INTEGRATED_WORKFLOW_FILENAME);
        return this.createFile(workflowFilePath);
    }

    private String getToolIntegrationDirectoryPath(String componentname) {
        return String.join((CharSequence)File.separator, this.getPathToWorkflowIntegrationDirectory(), String.valueOf(this.integrationContext.getToolDirectoryPrefix()) + componentname);
    }

    protected File createFile(String path) {
        return new File(path);
    }

    protected void createParentDirectories(File workflowFileTarget) {
        workflowFileTarget.getParentFile().mkdirs();
    }

    protected OutputStream createFileOutputStream(File workflowFileTarget) throws FileNotFoundException {
        return new FileOutputStream(workflowFileTarget);
    }

    @Reference
    public void bindConfigurationService(ConfigurationService service) {
        this.configurationService = service;
    }

    @Reference
    public void bindToolIntegrationService(ToolIntegrationService service) {
        this.toolIntegrationService = service;
    }

    @Reference
    public void bindToolIntegrationServiceRegistry(ToolIntegrationContextRegistry registry) {
        this.integrationContext = (WorkflowIntegrationContext)registry.getToolIntegrationContextByType("workflow");
    }
}

