/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.internal;

import de.rcenvironment.core.communication.api.LiveNetworkIdResolutionService;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.LogicalNodeSessionId;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LiveNetworkIdResolutionServiceImpl
implements LiveNetworkIdResolutionService {
    private final Map<String, InstanceNodeSessionId> instanceNodeSessionIdMap = new HashMap<String, InstanceNodeSessionId>();
    private String localInstanceNodeIdString;
    private String localInstanceNodeSessionIdString;
    private final boolean verboseLogging = DebugSettings.getVerboseLoggingEnabled(this.getClass());
    private final Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstanceNodeSessionId resolveInstanceNodeIdStringToInstanceNodeSessionId(String input) throws IdentifierException {
        InstanceNodeSessionId result;
        LiveNetworkIdResolutionServiceImpl liveNetworkIdResolutionServiceImpl = this;
        synchronized (liveNetworkIdResolutionServiceImpl) {
            result = this.instanceNodeSessionIdMap.get(input);
        }
        if (result != null) {
            return result;
        }
        throw new IdentifierException("Cannot resolve '" + input + "' to a known instance session id; that node has never been reachable, or is not reachable anymore");
    }

    @Override
    public LogicalNodeSessionId resolveToLogicalNodeSessionId(ResolvableNodeId id) throws IdentifierException {
        LogicalNodeSessionId result = this.resolveToLogicalNodeSessionIdInternal(id);
        if (this.verboseLogging) {
            this.log.debug((Object)StringUtils.format((String)"Resolved %s %s to %s", (Object[])new Object[]{id.getType(), id, result}));
        }
        return result;
    }

    private LogicalNodeSessionId resolveToLogicalNodeSessionIdInternal(ResolvableNodeId id) throws IdentifierException {
        InstanceNodeSessionId resolvedInstanceNodeSessionId = this.resolveInstanceNodeIdStringToInstanceNodeSessionId(id.getInstanceNodeIdString());
        switch (id.getType()) {
            case INSTANCE_NODE_SESSION_ID: {
                if (!resolvedInstanceNodeSessionId.isSameInstanceNodeSessionAs((InstanceNodeSessionId)id)) {
                    this.log.debug((Object)StringUtils.format((String)"Resolved a given session id %s to the more recent session id %s for the same instance node", (Object[])new Object[]{id, resolvedInstanceNodeSessionId}));
                }
            }
            case INSTANCE_NODE_ID: {
                return resolvedInstanceNodeSessionId.convertToDefaultLogicalNodeSessionId();
            }
            case LOGICAL_NODE_SESSION_ID: {
                if (!resolvedInstanceNodeSessionId.getSessionIdPart().equals(((LogicalNodeSessionId)id).getSessionIdPart())) {
                    this.log.debug((Object)StringUtils.format((String)"Resolved a given session id %s to the more recent session id %s for the same instance node", (Object[])new Object[]{id, resolvedInstanceNodeSessionId}));
                }
                return ((LogicalNodeSessionId)id).convertToLogicalNodeId().combineWithInstanceNodeSessionId(resolvedInstanceNodeSessionId);
            }
            case LOGICAL_NODE_ID: {
                return ((LogicalNodeId)id).combineWithInstanceNodeSessionId(resolvedInstanceNodeSessionId);
            }
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLocalInstanceNodeSessionId(InstanceNodeSessionId localINSId) {
        LiveNetworkIdResolutionServiceImpl liveNetworkIdResolutionServiceImpl = this;
        synchronized (liveNetworkIdResolutionServiceImpl) {
            if (this.localInstanceNodeIdString != null || this.localInstanceNodeSessionIdString != null) {
                throw new IllegalStateException();
            }
            this.localInstanceNodeIdString = localINSId.getInstanceNodeIdString();
            this.localInstanceNodeSessionIdString = localINSId.getInstanceNodeSessionIdString();
            if (this.instanceNodeSessionIdMap.put(this.localInstanceNodeIdString, localINSId) != null) {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInstanceNodeSessionId(InstanceNodeSessionId newINSId) {
        String instanceNodeIdString = newINSId.getInstanceNodeIdString();
        String instanceNodeSessionIdString = newINSId.getInstanceNodeSessionIdString();
        LiveNetworkIdResolutionServiceImpl liveNetworkIdResolutionServiceImpl = this;
        synchronized (liveNetworkIdResolutionServiceImpl) {
            if (instanceNodeIdString.equals(this.localInstanceNodeIdString) && !instanceNodeSessionIdString.equals(this.localInstanceNodeSessionIdString)) {
                this.log.debug((Object)StringUtils.format((String)"Refused an attempt to replace the local instance's current session id (%s) with another one (%s); this may be caused by stale data received from another instance", (Object[])new Object[]{this.localInstanceNodeSessionIdString, instanceNodeSessionIdString}));
                if (this.isAlphabeticallyMoreRecentThan(instanceNodeSessionIdString, this.localInstanceNodeSessionIdString)) {
                    this.log.debug((Object)"The conflicting session id received from the network (see above) is more recent than the local instance's session id; this may indicate a duplicate node id within the network, which may result from erronously copying and reusing a profile's internal settings");
                }
                return;
            }
            InstanceNodeSessionId existingResolutionForINId = this.instanceNodeSessionIdMap.get(instanceNodeIdString);
            if (existingResolutionForINId == null) {
                this.instanceNodeSessionIdMap.put(instanceNodeIdString, newINSId);
                this.log.debug((Object)StringUtils.format((String)"Registered %s as the first known session id for instance node '%s'", (Object[])new Object[]{newINSId, instanceNodeIdString}));
            } else if (!existingResolutionForINId.equals(newINSId)) {
                if (this.isAlphabeticallyMoreRecentThan(newINSId.getSessionIdPart(), existingResolutionForINId.getSessionIdPart())) {
                    this.log.info((Object)StringUtils.format((String)"Updated the default instance node session id for instance node '%s' from %s to %s; this means that a new session became visible before the old one unregistered from the network (e.g. after a crash or network disconnect)", (Object[])new Object[]{instanceNodeIdString, existingResolutionForINId, newINSId}));
                    this.instanceNodeSessionIdMap.put(instanceNodeIdString, newINSId);
                } else {
                    this.log.debug((Object)StringUtils.format((String)"Ignored an outdated session id for instance node '%s' (current: %s, ignored: %s) received as part of a remote node's network knowledge", (Object[])new Object[]{instanceNodeIdString, existingResolutionForINId, newINSId}));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterInstanceNodeSessionId(InstanceNodeSessionId oldINSId) {
        String instanceNodeIdString = oldINSId.getInstanceNodeIdString();
        LiveNetworkIdResolutionServiceImpl liveNetworkIdResolutionServiceImpl = this;
        synchronized (liveNetworkIdResolutionServiceImpl) {
            InstanceNodeSessionId existingResolutionForINId = this.instanceNodeSessionIdMap.get(instanceNodeIdString);
            if (existingResolutionForINId != null) {
                if (existingResolutionForINId.isSameInstanceNodeSessionAs(oldINSId)) {
                    this.instanceNodeSessionIdMap.remove(instanceNodeIdString);
                } else {
                    this.log.debug((Object)StringUtils.format((String)"The outdated instance node session id %s for instance node '%s' has been properly unregistered now", (Object[])new Object[]{oldINSId, instanceNodeIdString}));
                }
            }
        }
    }

    private boolean isAlphabeticallyMoreRecentThan(String id1, String id2) {
        return id1.compareTo(id2) > 0;
    }
}

