/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.network.channel.internal;

import de.rcenvironment.core.communication.uplink.client.session.api.ClientSideUplinkSession;
import de.rcenvironment.core.communication.uplink.client.session.api.ClientSideUplinkSessionEventHandler;
import de.rcenvironment.core.communication.uplink.common.internal.DataStreamUploadWrapper;
import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.communication.uplink.entities.ToolDocumentationRequest;
import de.rcenvironment.core.communication.uplink.entities.ToolDocumentationResponse;
import de.rcenvironment.core.communication.uplink.network.channel.internal.AbstractChannelEndpoint;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.utils.common.SizeValidatedDataSource;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import java.io.IOException;
import java.util.Optional;

public class DocumentationChannelProviderEndpoint
extends AbstractChannelEndpoint {
    private final ClientSideUplinkSessionEventHandler sessionEventHandler;
    private final String destinationId;

    public DocumentationChannelProviderEndpoint(ClientSideUplinkSession session, long channelId, ClientSideUplinkSessionEventHandler sessionEventHandler, String destinationId) {
        super(session, session.getLocalSessionId(), channelId);
        this.sessionEventHandler = sessionEventHandler;
        this.destinationId = destinationId;
    }

    @Override
    protected boolean processMessageInternal(MessageBlock messageBlock) throws IOException {
        MessageType messageType = messageBlock.getType();
        switch (messageType) {
            case TOOL_DOCUMENTATION_REQUEST: {
                ToolDocumentationRequest request = this.messageConverter.decodeDocumentationRequest(messageBlock);
                Optional<SizeValidatedDataSource> optionalData = this.sessionEventHandler.provideToolDocumentationData(this.destinationId, request.getReferenceId());
                if (optionalData.isPresent()) {
                    SizeValidatedDataSource data = optionalData.get();
                    this.log.debug((Object)("Documentation data for reference id " + request.getReferenceId() + " is available, size " + data.getSize()));
                    if (data.getSize() > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException();
                    }
                    this.sendResponseHeader(true, data.getSize());
                    this.sendDocumentationData(this.channelId, data);
                } else {
                    this.log.debug((Object)("No documentation data for reference id " + request.getReferenceId() + " found, creating empty data response"));
                    this.sendResponseHeader(false, 0L);
                }
                return true;
            }
        }
        throw new ProtocolException("Received unexpected message type " + (Object)((Object)messageType));
    }

    @Override
    public void dispose() {
    }

    private void sendResponseHeader(boolean available, long size) throws IOException {
        this.enqueueMessageBlockForSending(this.messageConverter.encodeDocumentationResponse(new ToolDocumentationResponse(available, size)));
    }

    private void sendDocumentationData(long channelId, SizeValidatedDataSource data) throws IOException {
        try {
            DataStreamUploadWrapper uploadWrapper = new DataStreamUploadWrapper(this.asyncMessageBlockSender);
            uploadWrapper.uploadFromDataSource(channelId, MessageType.TOOL_DOCUMENTATION_CONTENT, data);
        }
        catch (IOException e) {
            this.log.error((Object)"Error while converting documentation data into a network message", (Throwable)e);
            this.sendResponseHeader(false, 0L);
        }
    }
}

