/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.client.session.impl;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import de.rcenvironment.core.communication.configuration.NodeConfigurationService;
import de.rcenvironment.core.communication.sshconnection.InitialUplinkConnectionConfig;
import de.rcenvironment.core.communication.sshconnection.SshConnectionContext;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionProvider;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionRequest;
import de.rcenvironment.core.communication.uplink.client.execution.impl.ToolExecutionProviderImpl;
import de.rcenvironment.core.communication.uplink.client.session.api.ClientSideUplinkSession;
import de.rcenvironment.core.communication.uplink.client.session.api.ClientSideUplinkSessionEventHandler;
import de.rcenvironment.core.communication.uplink.client.session.api.DestinationIdUtils;
import de.rcenvironment.core.communication.uplink.client.session.api.LocalUplinkSessionService;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionListener;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionListenerAdapter;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionService;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionSetup;
import de.rcenvironment.core.communication.uplink.client.session.api.ToolDescriptorListUpdate;
import de.rcenvironment.core.communication.uplink.client.session.api.UplinkLogicalNodeMappingService;
import de.rcenvironment.core.communication.uplink.client.session.impl.SshUplinkConnectionImpl;
import de.rcenvironment.core.communication.uplink.client.session.impl.SshUplinkConnectionSetupImpl;
import de.rcenvironment.core.communication.uplink.client.session.internal.ClientSideUplinkSessionParameters;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkProtocolErrorType;
import de.rcenvironment.core.component.integration.documentation.ToolIntegrationDocumentationService;
import de.rcenvironment.core.configuration.SecureStorageImportService;
import de.rcenvironment.core.configuration.SecureStorageSection;
import de.rcenvironment.core.configuration.SecureStorageService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.FileCompressionFormat;
import de.rcenvironment.core.utils.common.FileCompressionService;
import de.rcenvironment.core.utils.common.SizeValidatedDataSource;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.VersionUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.ssh.jsch.JschSessionFactory;
import de.rcenvironment.core.utils.ssh.jsch.SshParameterException;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallback;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedCallbackManager;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.ThreadGuard;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component
public class SshUplinkConnectionServiceImpl
implements SshUplinkConnectionService {
    private static final String NO_SSH_CONNECTION_WITH_ID_S_CONFIGURED = "No SSH connection with id %s configured.";
    private static final String SLASH = "/";
    private final AsyncTaskService threadPool = ConcurrencyUtils.getAsyncTaskService();
    private final Map<String, SshUplinkConnectionSetup> connectionSetups;
    private List<String> scheduledConnectionSetups;
    private final Log log = LogFactory.getLog(this.getClass());
    private final AsyncOrderedCallbackManager<SshUplinkConnectionListener> callbackManager = ConcurrencyUtils.getFactory().createAsyncOrderedCallbackManager(AsyncCallbackExceptionPolicy.LOG_AND_CANCEL_LISTENER);
    private NodeConfigurationService configurationService;
    private SecureStorageService securePreferencesService;
    private SecureStorageSection secureStorageSection;
    @Reference
    private SecureStorageImportService secureStorageImportService;
    @Reference
    private LocalUplinkSessionService uplinkSessionService;
    private SshUplinkConnectionListener uplinkConnectionlistener;
    @Reference
    private ToolIntegrationDocumentationService toolDocService;
    @Reference
    private UplinkLogicalNodeMappingService logicalNodeMappingService;
    private String clientVersionInfo;

    public SshUplinkConnectionServiceImpl() {
        this.connectionSetups = new HashMap<String, SshUplinkConnectionSetup>();
        this.scheduledConnectionSetups = Collections.synchronizedList(new ArrayList());
        this.uplinkConnectionlistener = this.defineListenerForUplinkConnectionSetups();
    }

    @Override
    public ClientSideUplinkSession getAvtiveSshUplinkSession(String connectionId) {
        SshUplinkConnectionSetup setup = this.connectionSetups.get(connectionId);
        if (setup == null) {
            this.log.warn((Object)StringUtils.format((String)NO_SSH_CONNECTION_WITH_ID_S_CONFIGURED, (Object[])new Object[]{connectionId}));
            return null;
        }
        return setup.getSession();
    }

    @Override
    public boolean sshUplinkConnectionAlreadyExists(SshConnectionContext context) {
        for (String s : this.connectionSetups.keySet()) {
            if (!this.connectionSetups.get(s).getHost().contentEquals(context.getDestinationHost()) || this.connectionSetups.get(s).getPort() != context.getPort()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addSshUplinkConnection(SshConnectionContext context) {
        String connectionId = UUID.randomUUID().toString();
        SshUplinkConnectionSetupImpl newSetup = new SshUplinkConnectionSetupImpl(connectionId, context.getDisplayName(), context.getQualifier(), context.getDestinationHost(), context.getPort(), context.getSshAuthUser(), context.getKeyfileLocation(), context.isUsePassphrase(), context.isConnectImmediately(), context.isAutoRetry(), context.isGateway(), this.uplinkConnectionlistener);
        if (newSetup != null) {
            Map<String, SshUplinkConnectionSetup> map = this.connectionSetups;
            synchronized (map) {
                this.connectionSetups.put(connectionId, newSetup);
                final Collection<SshUplinkConnectionSetup> snapshot = Collections.unmodifiableCollection(this.connectionSetups.values());
                this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshUplinkConnectionListener>(){

                    public void performCallback(SshUplinkConnectionListener listener) {
                        listener.onCollectionChanged(snapshot);
                    }
                });
            }
        }
        return connectionId;
    }

    private SshUplinkConnectionListener defineListenerForUplinkConnectionSetups() {
        SshUplinkConnectionListenerAdapter listenerAdapter = new SshUplinkConnectionListenerAdapter(){

            @Override
            public void onConnectionAttemptFailed(final SshUplinkConnectionSetup setup, final String reason, final boolean firstConsecutiveFailure, final boolean willAutoRetry) {
                if (willAutoRetry) {
                    SshUplinkConnectionServiceImpl.this.scheduleAutoRetry(setup);
                }
                SshUplinkConnectionServiceImpl.this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshUplinkConnectionListener>(){

                    public void performCallback(SshUplinkConnectionListener listener) {
                        listener.onConnectionAttemptFailed(setup, reason, firstConsecutiveFailure, willAutoRetry);
                    }
                });
            }

            @Override
            public void onConnectionClosed(final SshUplinkConnectionSetup setup, final boolean willAutoRetry) {
                setup.setWaitingForRetry(willAutoRetry);
                if (willAutoRetry) {
                    SshUplinkConnectionServiceImpl.this.scheduleAutoRetry(setup);
                }
                SshUplinkConnectionServiceImpl.this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshUplinkConnectionListener>(){

                    public void performCallback(SshUplinkConnectionListener listener) {
                        listener.onConnectionClosed(setup, willAutoRetry);
                    }
                });
            }

            @Override
            public void onConnected(final SshUplinkConnectionSetup setup) {
                setup.resetConsecutiveConnectionFailures();
                SshUplinkConnectionServiceImpl.this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshUplinkConnectionListener>(){

                    public void performCallback(SshUplinkConnectionListener listener) {
                        listener.onConnected(setup);
                    }
                });
            }

            @Override
            public void onCreated(final SshUplinkConnectionSetup setup) {
                SshUplinkConnectionServiceImpl.this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshUplinkConnectionListener>(){

                    public void performCallback(SshUplinkConnectionListener listener) {
                        listener.onCreated(setup);
                    }
                });
            }

            @Override
            public void onPublicationEntriesChanged(final ToolDescriptorListUpdate publicationEntries, final String connectionId) {
                SshUplinkConnectionServiceImpl.this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshUplinkConnectionListener>(){

                    public void performCallback(SshUplinkConnectionListener listener) {
                        listener.onPublicationEntriesChanged(publicationEntries, connectionId);
                    }
                });
            }
        };
        return listenerAdapter;
    }

    private void scheduleAutoRetry(SshUplinkConnectionSetup setup) {
        if (!this.scheduledConnectionSetups.contains(setup.getId())) {
            this.log.debug((Object)StringUtils.format((String)"Scheduling auto-retry of connection %s in %d msec", (Object[])new Object[]{setup.getDisplayName(), 10000}));
            this.threadPool.scheduleAfterDelay("Communication Layer: SshUplinkConnectionService auto-reconnect timer", () -> {
                this.scheduledConnectionSetups.remove(setup.getId());
                if (setup.isWaitingForRetry()) {
                    this.connectSession(setup.getId());
                }
            }, 10000L);
            setup.setWaitingForRetry(true);
            this.scheduledConnectionSetups.add(setup.getId());
        } else {
            this.log.debug((Object)StringUtils.format((String)"Connection %s already scheduled.", (Object[])new Object[]{setup.getDisplayName()}));
        }
    }

    @Override
    public boolean isConnected(String connectionId) {
        return this.connectionSetups.get(connectionId).isConnected();
    }

    @Override
    public boolean isWaitingForRetry(String connectionId) {
        return this.connectionSetups.get(connectionId).isWaitingForRetry();
    }

    @Override
    public void connectSession(String connectionId) {
        ThreadGuard.checkForForbiddenThread();
        String passphrase = "";
        if (this.connectionSetups.get(connectionId).getUsePassphrase()) {
            passphrase = this.retrieveUplinkConnectionPassword(connectionId);
        }
        this.connectSession(connectionId, passphrase);
    }

    @Override
    public void connectSession(String connectionId, String passphrase) {
        ThreadGuard.checkForForbiddenThread();
        SshUplinkConnectionSetup sshConnectionSetup = this.connectionSetups.get(connectionId);
        if (sshConnectionSetup == null) {
            this.log.warn((Object)StringUtils.format((String)NO_SSH_CONNECTION_WITH_ID_S_CONFIGURED, (Object[])new Object[]{connectionId}));
        } else {
            this.connectSession(sshConnectionSetup, passphrase);
        }
    }

    @Override
    public void disconnectSession(String connectionId) {
        final SshUplinkConnectionSetup sshConnectionSetup = this.connectionSetups.get(connectionId);
        if (sshConnectionSetup == null) {
            this.log.warn((Object)StringUtils.format((String)NO_SSH_CONNECTION_WITH_ID_S_CONFIGURED, (Object[])new Object[]{connectionId}));
            return;
        }
        if (sshConnectionSetup.isConnected()) {
            sshConnectionSetup.disconnect();
        } else if (sshConnectionSetup.isWaitingForRetry()) {
            sshConnectionSetup.setWaitingForRetry(false);
            this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshUplinkConnectionListener>(){

                public void performCallback(SshUplinkConnectionListener listener) {
                    listener.onConnectionClosed(sshConnectionSetup, false);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeConnection(String connectionId) {
        final SshUplinkConnectionSetup setup = this.connectionSetups.get(connectionId);
        if (setup == null) {
            this.log.warn((Object)StringUtils.format((String)NO_SSH_CONNECTION_WITH_ID_S_CONFIGURED, (Object[])new Object[]{connectionId}));
            return;
        }
        if (setup.isConnected()) {
            setup.disconnect();
        } else if (setup.isWaitingForRetry()) {
            setup.setWaitingForRetry(false);
        }
        Map<String, SshUplinkConnectionSetup> map = this.connectionSetups;
        synchronized (map) {
            this.connectionSetups.remove(connectionId);
            final Collection<SshUplinkConnectionSetup> snapshot = Collections.unmodifiableCollection(this.connectionSetups.values());
            this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshUplinkConnectionListener>(){

                public void performCallback(SshUplinkConnectionListener listener) {
                    listener.onDisposed(setup);
                    listener.onCollectionChanged(snapshot);
                }
            });
        }
    }

    @Override
    public SshUplinkConnectionSetup getConnectionSetup(String connnectionId) {
        return this.connectionSetups.get(connnectionId);
    }

    @Override
    public Collection<SshUplinkConnectionSetup> getAllSshConnectionSetups() {
        for (SshUplinkConnectionSetup c : this.connectionSetups.values()) {
            if (c.getDisplayName() != null) continue;
            String hostAndPortString = StringUtils.format((String)"%s:%s", (Object[])new Object[]{c.getHost(), c.getPort()});
            c.setDisplayName(hostAndPortString);
        }
        return Collections.unmodifiableCollection(this.connectionSetups.values());
    }

    @Override
    public Map<String, SshUplinkConnectionSetup> getAllActiveSshConnectionSetups() {
        HashMap<String, SshUplinkConnectionSetup> activeConnections = new HashMap<String, SshUplinkConnectionSetup>();
        for (SshUplinkConnectionSetup connection : this.connectionSetups.values()) {
            if (!connection.isConnected()) continue;
            activeConnections.put(connection.getId(), connection);
        }
        return activeConnections;
    }

    @Override
    public void addListener(SshUplinkConnectionListener listener) {
        this.callbackManager.addListener((Object)listener);
    }

    public void removeListener(SshUplinkConnectionListener listener) {
        this.callbackManager.removeListener((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void editSshUplinkConnection(SshConnectionContext context) {
        SshUplinkConnectionSetupImpl newSetup = new SshUplinkConnectionSetupImpl(context.getId(), context.getDisplayName(), context.getQualifier(), context.getDestinationHost(), context.getPort(), context.getSshAuthUser(), context.getKeyfileLocation(), context.isUsePassphrase(), context.isConnectImmediately(), context.isAutoRetry(), context.isGateway(), this.uplinkConnectionlistener);
        if (newSetup != null) {
            Map<String, SshUplinkConnectionSetup> map = this.connectionSetups;
            synchronized (map) {
                this.connectionSetups.put(context.getId(), newSetup);
                final Collection<SshUplinkConnectionSetup> snapshot = Collections.unmodifiableCollection(this.connectionSetups.values());
                this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshUplinkConnectionListener>(){

                    public void performCallback(SshUplinkConnectionListener listener) {
                        listener.onCollectionChanged(snapshot);
                    }
                });
            }
        }
    }

    @Override
    public Collection<String> getAllActiveSshConnectionSetupIds() {
        return this.getAllActiveSshConnectionSetups().keySet();
    }

    @Activate
    public void activate() {
        Version clientVersion = VersionUtils.getVersionOfProduct();
        this.clientVersionInfo = clientVersion != null ? "rce/" + clientVersion.toString().replace("qualifier", "dev") : "rce/-";
        File importFilesDir = this.configurationService.getStandardImportDirectory("uplink-pws");
        try {
            this.secureStorageImportService.processImportDirectory(importFilesDir, "connections.uplink.ssh.passwords", null, null, true, true);
        }
        catch (OperationFailureException e) {
            this.log.warn((Object)("Error while attempting to import SSH Uplink connection passwords from " + importFilesDir + ": " + e.getMessage()));
        }
        try {
            this.secureStorageSection = this.securePreferencesService.getSecureStorageSection("connections.uplink.ssh.passwords");
        }
        catch (IOException iOException) {
            this.log.error((Object)"Failed to initialize secure storage");
        }
        ConcurrencyUtils.getAsyncTaskService().execute("Client-Side Uplink Access: Add pre-configured SSH connections", () -> this.addAndConnectInitialUplinkConfigs(this.configurationService.getInitialUplinkConnectionConfigs()));
    }

    @Deactivate
    public void deactivate() {
        Map<String, SshUplinkConnectionSetup> activeSshConnectionSetups = this.getAllActiveSshConnectionSetups();
        activeSshConnectionSetups.keySet().forEach(connectionId -> this.disconnectSession((String)connectionId));
    }

    private void addAndConnectInitialUplinkConfigs(List<InitialUplinkConnectionConfig> configs) {
        ThreadGuard.checkForForbiddenThread();
        for (InitialUplinkConnectionConfig config : configs) {
            SshUplinkConnectionSetupImpl setup = new SshUplinkConnectionSetupImpl(config.getId(), config.getDisplayName(), config.getQualifier(), config.getHost(), config.getPort(), config.getUser(), config.getKeyFileLocation(), config.getUsePassphrase(), config.getConnectOnStartup(), config.getAutoRetry(), config.isGateway(), this.uplinkConnectionlistener);
            this.connectionSetups.put(config.getId(), setup);
            if (!config.getConnectOnStartup()) continue;
            if (config.getUsePassphrase()) {
                this.connectSession(setup, this.retrieveUplinkConnectionPassword(setup.getId()));
                continue;
            }
            this.connectSession(setup, "");
        }
    }

    @Reference
    public void bindNodeConfigurationService(NodeConfigurationService service) {
        this.configurationService = service;
    }

    private void storeSshConnectionPassword(String connectionId, String password) {
        try {
            this.secureStorageSection.store(connectionId, password);
        }
        catch (OperationFailureException e) {
            this.log.error((Object)("Could not store password: " + (Object)((Object)e)));
        }
    }

    private void removeSshConnectionPasswordIfExists(String connectionId) {
        try {
            this.secureStorageSection.delete(connectionId);
        }
        catch (OperationFailureException e) {
            this.log.error((Object)("Could not remove password: " + (Object)((Object)e)));
        }
    }

    @Override
    public String retrieveUplinkConnectionPassword(String connectionId) {
        String passphrase = null;
        try {
            passphrase = this.secureStorageSection.read(connectionId, null);
        }
        catch (OperationFailureException e) {
            this.log.error((Object)("Could not retrieve password: " + (Object)((Object)e)));
            return null;
        }
        return passphrase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAuthPhraseForSshConnection(String id, String sshAuthPassPhrase, boolean storePassphrase) {
        SshUplinkConnectionSetup oldSetup = this.connectionSetups.get(id);
        SshUplinkConnectionSetupImpl newSetup = new SshUplinkConnectionSetupImpl(id, oldSetup.getDisplayName(), oldSetup.getQualifier(), oldSetup.getHost(), oldSetup.getPort(), oldSetup.getUsername(), oldSetup.getKeyfileLocation(), oldSetup.getUsePassphrase(), oldSetup.getConnectOnStartUp(), oldSetup.getAutoRetry(), oldSetup.isGateway(), this.uplinkConnectionlistener);
        if (newSetup != null) {
            Map<String, SshUplinkConnectionSetup> map = this.connectionSetups;
            synchronized (map) {
                this.connectionSetups.put(id, newSetup);
                final Collection<SshUplinkConnectionSetup> snapshot = Collections.unmodifiableCollection(this.connectionSetups.values());
                this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshUplinkConnectionListener>(){

                    public void performCallback(SshUplinkConnectionListener listener) {
                        listener.onCollectionChanged(snapshot);
                    }
                });
            }
            if (storePassphrase) {
                this.storeSshConnectionPassword(id, sshAuthPassPhrase);
            } else {
                this.removeSshConnectionPasswordIfExists(id);
            }
        }
    }

    @Reference
    protected void bindSecureStorageService(SecureStorageService newService) {
        this.securePreferencesService = newService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectSession(final SshUplinkConnectionSetup setup, String passphrase) {
        ThreadGuard.checkForForbiddenThread();
        SshUplinkConnectionSetup sshUplinkConnectionSetup = setup;
        synchronized (sshUplinkConnectionSetup) {
            if (setup.getSession() != null) {
                this.log.debug((Object)StringUtils.format((String)"Denied new session of connection %s.", (Object[])new Object[]{setup.getDisplayName()}));
                return;
            }
            if (setup.getKeyfileLocation() == null && passphrase == null) {
                this.log.warn((Object)StringUtils.format((String)"Connecting SSH session failed because no key file and no passphrase is given: host %s, port %s.", (Object[])new Object[]{setup.getHost(), setup.getPort()}));
                String error = "No key file or passphrase could be found. Probable cause: This was an automatic reconnection attempt and the passphrase is not stored.";
                this.uplinkConnectionlistener.onConnectionAttemptFailed(setup, error, true, false);
                return;
            }
            try {
                Session sshSession = JschSessionFactory.setupSession((String)setup.getHost(), (int)setup.getPort(), (String)setup.getUsername(), (String)setup.getKeyfileLocation(), (String)passphrase, (Logger)JschSessionFactory.createDelegateLogger((Log)LogFactory.getLog(this.getClass())));
                ClientSideUplinkSessionParameters sessionParameters = new ClientSideUplinkSessionParameters("My display name", setup.getQualifier(), this.clientVersionInfo, null);
                SshUplinkConnectionImpl uplinkConnection = new SshUplinkConnectionImpl(sshSession);
                try {
                    uplinkConnection.open(errorMessage -> this.log.warn((Object)("Uplink connection error: " + errorMessage)));
                }
                catch (IOException e1) {
                    throw new OperationFailureException(StringUtils.format((String)"Failed to connect to Uplink server at %s:%d; reason: %s", (Object[])new Object[]{setup.getHost(), setup.getPort(), e1.toString()}));
                }
                ClientSideUplinkSession uplinkSession = this.uplinkSessionService.createSession(uplinkConnection, sessionParameters, new ClientSideUplinkSessionEventHandler(){
                    private UplinkProtocolErrorType errorType;

                    @Override
                    public void onSessionActivating(String namespaceId, String destinationIdPrefix) {
                        setup.setDestinationIdPrefix(namespaceId);
                        SshUplinkConnectionServiceImpl.this.uplinkConnectionlistener.onConnected(setup);
                        SshUplinkConnectionServiceImpl.this.log.debug((Object)StringUtils.format((String)"Uplink session %s established", (Object[])new Object[]{setup.getSession()}));
                    }

                    @Override
                    public void onActiveSessionTerminating() {
                        SshUplinkConnectionServiceImpl.this.log.debug((Object)StringUtils.format((String)"Uplink session %s is terminating", (Object[])new Object[]{setup.getSession()}));
                    }

                    @Override
                    public void onFatalSessionError(UplinkProtocolErrorType errorType, String errorMessage) {
                        if (errorType.equals((Object)UplinkProtocolErrorType.CLIENT_NAMESPACE_COLLISION) || errorType.equals((Object)UplinkProtocolErrorType.PROTOCOL_VERSION_MISMATCH)) {
                            SshUplinkConnectionServiceImpl.this.uplinkConnectionlistener.onConnectionAttemptFailed(setup, errorMessage, setup.getConsecutiveConnectionFailures() <= 1, false);
                        }
                        this.errorType = errorType;
                        SshUplinkConnectionServiceImpl.this.log.warn((Object)("Uplink session or connection error: " + errorMessage + " (type " + (Object)((Object)errorType) + ", session id: " + setup.getSession() + ")"));
                    }

                    @Override
                    public void onSessionInFinalState() {
                        boolean willAutoRetry = setup.isWaitingForRetry();
                        if (this.errorType != null) {
                            willAutoRetry = willAutoRetry && this.errorType.getClientRetryFlag();
                        }
                        SshUplinkConnectionServiceImpl.this.uplinkConnectionlistener.onConnectionClosed(setup, willAutoRetry);
                        SshUplinkConnectionServiceImpl.this.log.debug((Object)("Uplink session " + setup.getSession() + " terminated"));
                        setup.setSession(null);
                    }

                    @Override
                    public void processToolDescriptorListUpdate(ToolDescriptorListUpdate update) {
                        SshUplinkConnectionServiceImpl.this.uplinkConnectionlistener.onPublicationEntriesChanged(update, setup.getId());
                    }

                    @Override
                    public ToolExecutionProvider setUpToolExecutionProvider(ToolExecutionRequest request) {
                        return new ToolExecutionProviderImpl(request);
                    }

                    @Override
                    public Optional<SizeValidatedDataSource> provideToolDocumentationData(String destinationId, String docReferenceId) {
                        String nodeId = DestinationIdUtils.getNodeIdFromQualifiedDestinationId(destinationId);
                        try {
                            File docDir = SshUplinkConnectionServiceImpl.this.toolDocService.getToolDocumentation(String.valueOf(docReferenceId.split(SshUplinkConnectionServiceImpl.SLASH)[0]) + SshUplinkConnectionServiceImpl.SLASH + docReferenceId.split(SshUplinkConnectionServiceImpl.SLASH)[1], nodeId, docReferenceId.split(SshUplinkConnectionServiceImpl.SLASH)[2]);
                            byte[] data = FileCompressionService.compressDirectoryToByteArray((File)docDir, (FileCompressionFormat)FileCompressionFormat.ZIP, (Boolean)false);
                            return Optional.of(new SizeValidatedDataSource(data));
                        }
                        catch (RemoteOperationException | IOException e) {
                            SshUplinkConnectionServiceImpl.this.log.warn((Object)"Could not retreive tool documentation from tool documentation service: ", e);
                            return null;
                        }
                    }
                });
                ConcurrencyUtils.getAsyncTaskService().execute("Run SSH Uplink session", () -> {
                    if (!uplinkSession.runSession()) {
                        this.log.warn((Object)("An Uplink connection (" + setup.getDisplayName() + ") finished with a warning or error; inspect the log output above for details"));
                    }
                });
                setup.setSession(uplinkSession);
            }
            catch (JSchException | OperationFailureException | SshParameterException | LogConfigurationException e) {
                this.log.warn((Object)StringUtils.format((String)"Connecting SSH session failed: host %s, port %s: %s", (Object[])new Object[]{setup.getHost(), setup.getPort(), e.toString()}));
                String reason = e.getMessage();
                Throwable cause = e.getCause();
                if (reason == null) {
                    reason = "";
                }
                boolean shouldTryToReconnect = setup.getAutoRetry();
                if (cause != null && cause instanceof ConnectException) {
                    reason = "The remote instance could not be reached. Probably the hostname or port is wrong.";
                } else if (cause != null && cause instanceof UnknownHostException) {
                    reason = "No host with this name could be found.";
                } else if (reason.equals("Auth fail")) {
                    reason = "Authentication failed. Probably the username or passphrase is wrong, the wrong key file was used or the account is not enabled on the remote host.";
                    shouldTryToReconnect = false;
                } else if (reason.equals("USERAUTH fail")) {
                    reason = "Authentication failed. The wrong passphrase for the key file " + setup.getKeyfileLocation() + " was used.";
                    shouldTryToReconnect = false;
                } else if (reason.startsWith("invalid privatekey")) {
                    reason = "Authentication failed. An invalid private key was used.";
                    shouldTryToReconnect = false;
                } else if (reason.equals("The authentication phrase cannot be empty")) {
                    reason = "The authentication phrase cannot be empty.";
                    shouldTryToReconnect = false;
                }
                if (shouldTryToReconnect) {
                    setup.raiseConsecutiveConnectionFailures();
                }
                this.uplinkConnectionlistener.onConnectionAttemptFailed(setup, reason, setup.getConsecutiveConnectionFailures() <= 1, shouldTryToReconnect);
                return;
            }
        }
    }
}

