/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.authorization.internal;

import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class AuthorizationCommandPlugin
implements CommandPlugin {
    private static final String GROUP_ID_PARAMETER = "<group id>";
    private static final String ROOT_COMMAND = "auth";
    private AuthorizationService authorizationService;

    public Collection<CommandDescription> getCommandDescriptions() {
        ArrayList<CommandDescription> contributions = new ArrayList<CommandDescription>();
        contributions.add(new CommandDescription(ROOT_COMMAND, "", false, "short form of \"auth list\"", new String[0]));
        contributions.add(new CommandDescription("auth create", GROUP_ID_PARAMETER, false, "creates a new authorization group", new String[]{"<group id> - an identifier consisting of 2-32 letters, numbers, underscores (\"_\") and/or brackets"}));
        contributions.add(new CommandDescription("auth list", null, false, "lists the authorization groups that the local node belongs too", new String[0]));
        contributions.add(new CommandDescription("auth delete", GROUP_ID_PARAMETER, false, "deletes a local authorization group", new String[]{"<group id> - the identifier of the local group to delete"}));
        contributions.add(new CommandDescription("auth export", GROUP_ID_PARAMETER, false, "exports a group as an invitation string that can be imported by another node, allowing that other node to join this group", new String[0]));
        contributions.add(new CommandDescription("auth import", "<invitation string>", false, "imports a group from an invitation string that was previously exported on another node", new String[0]));
        return contributions;
    }

    public void execute(CommandContext context) throws CommandException {
        context.consumeExpectedToken(ROOT_COMMAND);
        String subCmd = context.consumeNextToken();
        if (subCmd == null || subCmd.equals("list")) {
            this.performList(context);
        } else if (subCmd.equals("create")) {
            this.performCreate(context);
        } else if (subCmd.equals("export")) {
            this.performExport(context);
        } else if (subCmd.equals("import")) {
            this.performImport(context);
        } else if (subCmd.equals("delete")) {
            this.performDelete(context);
        } else {
            throw CommandException.unknownCommand((CommandContext)context);
        }
    }

    private void performList(CommandContext context) throws CommandException {
        if (context.hasRemainingTokens()) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        List<AuthorizationAccessGroup> groups = this.authorizationService.listAccessibleGroups(true);
        for (AuthorizationAccessGroup group : groups) {
            context.println((Object)group.getDisplayName());
        }
    }

    private void performCreate(CommandContext context) throws CommandException {
        String groupId = this.fetchSingleParameter(context);
        try {
            AuthorizationAccessGroup group = this.authorizationService.createLocalGroup(groupId);
            context.println((Object)StringUtils.format((String)"Created local group %s (full id: %s)", (Object[])new Object[]{group.getDisplayName(), group.getFullId()}));
        }
        catch (OperationFailureException e) {
            throw CommandException.executionError((String)("Error creating the new group: " + e.getMessage()), (CommandContext)context);
        }
    }

    private void performExport(CommandContext context) throws CommandException {
        String groupId = this.fetchSingleParameter(context);
        try {
            AuthorizationAccessGroup group = this.authorizationService.findLocalGroupById(groupId);
            if (group == null) {
                throw CommandException.executionError((String)("Failed to export group " + groupId + ": There is no matching local authorized group"), (CommandContext)context);
            }
            context.println((Object)this.authorizationService.exportToString(group));
        }
        catch (OperationFailureException e) {
            throw CommandException.executionError((String)StringUtils.format((String)"Error exporting group %s: %s", (Object[])new Object[]{groupId, e.getMessage()}), (CommandContext)context);
        }
    }

    private void performImport(CommandContext context) throws CommandException {
        String exportString = this.fetchSingleParameter(context);
        try {
            AuthorizationAccessGroup group = this.authorizationService.importFromString(exportString);
            context.println((Object)("Successfully imported group " + group.getDisplayName()));
        }
        catch (OperationFailureException e) {
            throw CommandException.executionError((String)("Error importing group from invitation string " + exportString + ": " + e.getMessage()), (CommandContext)context);
        }
    }

    private void performDelete(CommandContext context) throws CommandException {
        String groupId = this.fetchSingleParameter(context);
        try {
            AuthorizationAccessGroup group = this.authorizationService.findLocalGroupById(groupId);
            if (group == null) {
                throw CommandException.executionError((String)("Found no local group matching " + groupId + " to delete"), (CommandContext)context);
            }
            this.authorizationService.deleteLocalGroupData(group);
            context.println((Object)("Deleted local group " + group.getDisplayName()));
        }
        catch (OperationFailureException e) {
            throw CommandException.executionError((String)("Error deleting group " + groupId + ": " + e.getMessage()), (CommandContext)context);
        }
    }

    @Reference
    protected void bindAuthorizationService(AuthorizationService newService) {
        this.authorizationService = newService;
    }

    private String fetchSingleParameter(CommandContext context) throws CommandException {
        List tokens = context.consumeRemainingTokens();
        if (tokens.size() != 1) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        String parameter = (String)tokens.get(0);
        return parameter;
    }
}

