/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.gui;

import de.rcenvironment.components.outputwriter.gui.Messages;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.utils.common.components.PropertyTabGuiHelper;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class OutputWriterRootLocationSection
extends ValidatingWorkflowNodePropertySection {
    private static final String FRONT_SLASH = "/";
    private Button workflowStartCheckbox;
    private Button overwriteCheckbox;
    private Text rootText;
    private Button rootSelectFromProjectButton;
    private Button rootSelectFromFileSystemButton;
    private Composite noteComposite;

    public void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        parent.setLayout((Layout)new FillLayout(512));
        super.createCompositeContent(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory toolkit = aTabbedPropertySheetPage.getWidgetFactory();
        WorkflowNodePropertySection.LayoutComposite root = new WorkflowNodePropertySection.LayoutComposite(parent);
        Composite rootComposite = toolkit.createFlatFormComposite((Composite)root);
        rootComposite.setLayout((Layout)new GridLayout(1, true));
        this.createRootSection(rootComposite, (FormToolkit)toolkit);
        rootComposite.layout();
    }

    private Composite createRootSection(Composite parent, FormToolkit toolkit) {
        Section sectionProperties = toolkit.createSection(parent, 256);
        sectionProperties.setText(Messages.rootFolderSectionTitle);
        GridData layoutData = new GridData(1808);
        sectionProperties.setLayoutData((Object)layoutData);
        Composite rootgroup = toolkit.createComposite((Composite)sectionProperties);
        rootgroup.setLayout((Layout)new GridLayout(2, false));
        this.rootText = new Text(rootgroup, 2048);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.rootText.setLayoutData((Object)gridData);
        this.rootText.setEditable(true);
        this.rootText.setData("property.control", (Object)"SelectedRoot");
        this.rootSelectFromProjectButton = new Button(rootgroup, 0);
        this.rootSelectFromProjectButton.setText("Select from project ...");
        this.rootSelectFromProjectButton.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.rootSelectFromProjectButton.addSelectionListener((SelectionListener)new SelectFromProjectSelectionListener());
        this.rootSelectFromFileSystemButton = new Button(rootgroup, 0);
        this.rootSelectFromFileSystemButton.setText("Select from file system ...");
        this.rootSelectFromFileSystemButton.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.rootSelectFromFileSystemButton.addSelectionListener((SelectionListener)new SelectFromFileSystemSelectionListener());
        this.workflowStartCheckbox = new Button(rootgroup, 32);
        this.workflowStartCheckbox.setText(Messages.selectAtStart);
        this.workflowStartCheckbox.setLayoutData((Object)new GridData(16384, 128, true, false, 2, 1));
        this.workflowStartCheckbox.setData("property.control", (Object)"SelectRootOnWorkflowStart");
        this.overwriteCheckbox = new Button(rootgroup, 32);
        this.overwriteCheckbox.setText(Messages.overwriteOption);
        this.overwriteCheckbox.setLayoutData((Object)new GridData(16384, 128, true, false, 2, 1));
        this.overwriteCheckbox.setData("property.control", (Object)"OverwriteFilesAndDirs");
        this.noteComposite = toolkit.createComposite(rootgroup);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.noteComposite.setLayoutData((Object)gridData);
        this.noteComposite.setLayout((Layout)new GridLayout(2, false));
        CLabel noteLabel = new CLabel(this.noteComposite, 0);
        noteLabel.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.WARNING_16));
        noteLabel.setText(Messages.note);
        sectionProperties.setClient((Control)rootgroup);
        sectionProperties.setVisible(true);
        return rootgroup;
    }

    private void setEnabilityRoot(boolean enabled) {
        this.noteComposite.setVisible(enabled);
        this.rootText.setEnabled(enabled);
        this.rootSelectFromProjectButton.setEnabled(enabled);
        this.rootSelectFromFileSystemButton.setEnabled(enabled);
    }

    public void refreshSection() {
        super.refreshSection();
        this.setEnabilityRoot(!this.workflowStartCheckbox.getSelection());
    }

    protected RootLocationDefaultUpdater createUpdater() {
        return new RootLocationDefaultUpdater();
    }

    protected class RootLocationDefaultUpdater
    extends WorkflowNodePropertySection.DefaultUpdater {
        protected RootLocationDefaultUpdater() {
            super((WorkflowNodePropertySection)OutputWriterRootLocationSection.this);
        }

        public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
            super.updateControl(control, propertyName, newValue, oldValue);
            if (control instanceof Button && ((Button)control).getText().equals(Messages.selectAtStart)) {
                OutputWriterRootLocationSection.this.setEnabilityRoot(Boolean.valueOf(newValue) == false);
            }
        }
    }

    private class SelectFromFileSystemSelectionListener
    implements SelectionListener {
        private SelectFromFileSystemSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell(), 4096);
            dialog.setText(Messages.selectDirectory);
            dialog.setMessage("Select directory from file system");
            this.checkIfPathExists(dialog, OutputWriterRootLocationSection.this.rootText.getText());
            String path = dialog.open();
            if (path != null) {
                OutputWriterRootLocationSection.this.rootText.setText(path);
            }
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        private void checkIfPathExists(DirectoryDialog dialog, String text) {
            File file = new File(text);
            if (!text.equals("") && file.exists() && file.isDirectory()) {
                dialog.setFilterPath(file.toString());
            } else {
                File[] paths = File.listRoots();
                if (paths[0].getPath() != null) {
                    dialog.setFilterPath(paths[0].getPath());
                }
            }
        }
    }

    private class SelectFromProjectSelectionListener
    implements SelectionListener {
        private SelectFromProjectSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            IResource resource = PropertyTabGuiHelper.selectDirectoryFromActiveProjectIncludingItsRoot((Shell)Display.getCurrent().getActiveShell(), (String)Messages.selectDirectory, (String)"Select directory from project");
            if (resource != null) {
                String selectedPath = resource.getFullPath().makeRelative().toPortableString();
                OutputWriterRootLocationSection.this.rootText.setText("${dir:workspace}/" + selectedPath);
            }
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }
    }
}

