/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.gui;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.outputwriter.common.OutputLocation;
import de.rcenvironment.components.outputwriter.common.OutputLocationList;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.EditDynamicEndpointCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import org.apache.commons.logging.LogFactory;

public class OutputWriterEditDynamicInputCommand
extends EditDynamicEndpointCommand {
    private ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
    private String oldJsonString = "";
    private String outputLocationId;
    private boolean removeInput;

    public OutputWriterEditDynamicInputCommand(EndpointType direction, EndpointDescription oldDescription, EndpointDescription newDescription, String outputLocationId, boolean removeInput, Refreshable ... refreshable) {
        super(direction, oldDescription, newDescription, refreshable);
        this.mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        this.outputLocationId = outputLocationId;
        this.removeInput = removeInput;
    }

    public void execute() {
        try {
            String inputJsonString = this.getProperties().getConfigurationDescription().getConfigurationValue("outputLocations");
            if (inputJsonString != null && !inputJsonString.equals("") && this.outputLocationId != null && !this.outputLocationId.equals("")) {
                OutputLocationList list = (OutputLocationList)this.mapper.readValue(inputJsonString, OutputLocationList.class);
                OutputLocation location = list.getOutputLocationById(this.outputLocationId);
                if (this.removeInput) {
                    location.getInputs().remove(this.oldDesc.getName());
                }
                String outputJsonString = this.mapper.writeValueAsString((Object)list);
                this.getProperties().getConfigurationDescription().setConfigurationValue("outputLocations", outputJsonString);
                this.oldJsonString = inputJsonString;
                this.newDesc.setParentGroupName("write");
            }
        }
        catch (IOException e) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)("Error when writing components to JSON: " + e.getMessage()));
        }
        super.execute();
    }

    public void undo() {
        this.getProperties().getConfigurationDescription().setConfigurationValue("outputLocations", this.oldJsonString);
        super.undo();
    }
}

