/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.gui.view;

import de.rcenvironment.components.optimizer.common.Dimension;
import de.rcenvironment.components.optimizer.common.Measure;
import de.rcenvironment.components.optimizer.common.OptimizerResultSet;
import de.rcenvironment.components.optimizer.common.ResultStructure;
import de.rcenvironment.components.optimizer.gui.properties.Messages;
import de.rcenvironment.components.optimizer.gui.view.OptimizerDatastore;
import de.rcenvironment.core.component.execution.api.ComponentExecutionInformation;
import de.rcenvironment.core.gui.utils.common.ClipboardHelper;
import de.rcenvironment.core.gui.utils.common.configuration.ExcelFileExporterDialog;
import de.rcenvironment.core.gui.utils.incubator.StudyDataExportMessageHelper;
import de.rcenvironment.core.utils.common.variables.legacy.TypedValue;
import de.rcenvironment.core.utils.common.variables.legacy.VariableType;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ChartDataComposite
extends Composite
implements ISelectionProvider {
    private static final int DEFAULT_COLUMN_WIDTH = 100;
    private static final String SAVE_LOCATION_PROPERTIES_NODE = "de.rcenvironment.core.gui.resources.savelocations";
    private static final String EXPORT_TO_EXCEL_PROPERTIES_IDENTIFIER = "export_to_excel_save_location";
    private ComponentExecutionInformation componentExecutionInformation;
    private Button saveDataButton;
    private TableViewer tableViewer;
    private Table table;
    private OptimizerDatastore resultDatastore;
    private final OptimizerDatastore.OptimizerResultSetAddListener datasetAddListener = new OptimizerDatastore.OptimizerResultSetAddListener(){

        @Override
        public void handleStudyDatasetAdd(final OptimizerResultSet dataset) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ChartDataComposite.this.isDisposed()) {
                        return;
                    }
                    ChartDataComposite.this.tableViewer.add((Object)dataset);
                    ChartDataComposite.this.update();
                }
            });
        }
    };

    public ChartDataComposite(Composite parent, int style, ComponentExecutionInformation componentExecutionInformation) {
        super(parent, style);
        this.componentExecutionInformation = componentExecutionInformation;
    }

    public void dispose() {
        if (this.resultDatastore != null) {
            this.resultDatastore.removeDatasetAddListener(this.datasetAddListener);
        }
        super.dispose();
    }

    public void createControls() {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginBottom = 5;
        this.setLayout((Layout)layout);
        this.tableViewer = new TableViewer((Composite)this, 65538);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData layoutData = new GridData(1808);
        layoutData.horizontalIndent = 0;
        layoutData.verticalIndent = 0;
        layoutData.horizontalSpan = 2;
        this.table.setLayoutData((Object)layoutData);
        final Button copyToClipboardButton = new Button((Composite)this, 8);
        copyToClipboardButton.setText(Messages.copyToClipboardLabel);
        layoutData = new GridData();
        copyToClipboardButton.setLayoutData((Object)layoutData);
        copyToClipboardButton.setEnabled(false);
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                copyToClipboardButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        copyToClipboardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ISelection selection = ChartDataComposite.this.getSelection();
                LinkedList<String> keys = new LinkedList<String>();
                TableColumn[] tableColumnArray = ChartDataComposite.this.table.getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    keys.add(column.getText());
                    ++n2;
                }
                int keysCount = keys.size();
                StringBuilder builder = new StringBuilder();
                if (selection != null && selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Iterator iterator = structuredSelection.iterator();
                    while (iterator.hasNext()) {
                        OptimizerResultSet o = (OptimizerResultSet)iterator.next();
                        int index = 0;
                        while (index < keysCount) {
                            String key = (String)keys.get(index);
                            if (o != null && o.getComponent() != null) {
                                double value = o.getValue(key);
                                builder.append(value);
                            }
                            if (index < keysCount - 1) {
                                builder.append("\t");
                            }
                            ++index;
                        }
                        if (!iterator.hasNext()) continue;
                        builder.append("\n");
                    }
                    String content = builder.toString();
                    ClipboardHelper.setContent((String)content);
                }
            }
        });
        this.saveDataButton = new Button((Composite)this, 8);
        this.saveDataButton.setText(Messages.excelExport);
        this.saveDataButton.setEnabled(false);
        this.saveDataButton.addSelectionListener((SelectionListener)new ExportDataListener(this));
    }

    public void setStudyDatastore(OptimizerDatastore studyDatastore) {
        if (this.resultDatastore == studyDatastore) {
            return;
        }
        if (this.resultDatastore == null) {
            this.resultDatastore = studyDatastore;
            StudyDatastoreContentProvider contentProvider = new StudyDatastoreContentProvider();
            this.initializeStructure();
            studyDatastore.addDatasetAddListener(this.datasetAddListener);
            this.tableViewer.setContentProvider((IContentProvider)contentProvider);
            this.tableViewer.setInput((Object)studyDatastore);
        }
    }

    private void initializeStructure() {
        ResultStructure structure = this.resultDatastore.getStructure();
        List<Dimension> list = this.getSortedDimensions(structure);
        TableViewerColumn itColumn = new TableViewerColumn(this.tableViewer, 0);
        itColumn.getColumn().setText("Iteration");
        itColumn.getColumn().setWidth(100);
        itColumn.getColumn().setMoveable(true);
        class ValueLabelProvider
        extends ColumnLabelProvider {
            private final String key;
            private boolean isMeasure;

            ValueLabelProvider(String key, boolean isMeasure) {
                this.key = key;
                this.isMeasure = isMeasure;
            }

            public String getText(Object element) {
                if (!(element instanceof OptimizerResultSet)) {
                    return null;
                }
                String keyToLookup = this.key;
                if (this.isMeasure) {
                    keyToLookup = "Output: " + keyToLookup;
                }
                double value = ((OptimizerResultSet)element).getValue(keyToLookup);
                String result = String.valueOf(value);
                return result;
            }
        }
        itColumn.setLabelProvider((CellLabelProvider)new ValueLabelProvider("Iteration", false));
        for (Dimension dimension : list) {
            TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
            column.getColumn().setText(dimension.getName());
            column.getColumn().setWidth(100);
            column.getColumn().setMoveable(true);
            column.setLabelProvider((CellLabelProvider)new ValueLabelProvider(dimension.getName(), true));
        }
        List<Measure> measureList = this.getSortedMeasures(structure);
        for (Measure measure : measureList) {
            TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
            column.getColumn().setText(measure.getName());
            column.getColumn().setWidth(100);
            column.getColumn().setMoveable(true);
            column.setLabelProvider((CellLabelProvider)new ValueLabelProvider(measure.getName(), false));
        }
    }

    private List<Measure> getSortedMeasures(ResultStructure structure) {
        Collection measureCollection = structure.getMeasures();
        ArrayList<Measure> measureList = new ArrayList<Measure>(measureCollection);
        Collections.sort(measureList, new Comparator<Measure>(){

            @Override
            public int compare(Measure o1, Measure o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return measureList;
    }

    private List<Dimension> getSortedDimensions(ResultStructure structure) {
        Collection collection = structure.getDimensions();
        ArrayList<Dimension> list = new ArrayList<Dimension>(collection);
        Collections.sort(list, new Comparator<Dimension>(){

            @Override
            public int compare(Dimension o1, Dimension o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Dimension iteration = null;
        for (Dimension dimension : list) {
            if (!dimension.getName().equals("Iteration")) continue;
            iteration = dimension;
        }
        list.remove(iteration);
        return list;
    }

    public void update() {
        super.update();
        if (!this.resultDatastore.getDatasets().isEmpty()) {
            this.saveDataButton.setEnabled(true);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.tableViewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.tableViewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.tableViewer.setSelection(selection);
    }

    private class ExportDataListener
    implements SelectionListener {
        private IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("de.rcenvironment.core.gui.resources.savelocations");
        private final Shell cdc;

        ExportDataListener(ChartDataComposite cd) {
            this.cdc = cd.getShell();
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            boolean success = true;
            FileDialog fd = new FileDialog(this.cdc, 8192);
            fd.setText("Save");
            fd.setOverwrite(true);
            String lastSaveLocation = this.preferences.get(ChartDataComposite.EXPORT_TO_EXCEL_PROPERTIES_IDENTIFIER, System.getProperty("user.dir"));
            fd.setFilterPath(lastSaveLocation);
            String[] filterExt = new String[]{"*.xls"};
            fd.setFilterExtensions(filterExt);
            String selected = fd.open();
            if (selected != null) {
                File excelFile = null;
                if (ChartDataComposite.this.resultDatastore != null) {
                    if (!selected.substring(selected.lastIndexOf(46) + 1).toLowerCase().equals("xls")) {
                        selected = String.valueOf(selected) + ".xls";
                    }
                    excelFile = new File(selected);
                    TypedValue[][] values = new TypedValue[ChartDataComposite.this.resultDatastore.getDatasetCount() + 1][];
                    Iterator<OptimizerResultSet> it = ChartDataComposite.this.resultDatastore.getDatasets().iterator();
                    List dimensions = ChartDataComposite.this.getSortedDimensions(ChartDataComposite.this.resultDatastore.getStructure());
                    List measures = ChartDataComposite.this.getSortedMeasures(ChartDataComposite.this.resultDatastore.getStructure());
                    int i = 0;
                    while (it.hasNext()) {
                        int j;
                        OptimizerResultSet next = it.next();
                        if (i == 0) {
                            values[i] = new TypedValue[next.getValues().size()];
                            values[i][0] = new TypedValue(VariableType.String, "Iteration");
                            j = 0;
                            while (j < dimensions.size()) {
                                values[0][j + 1] = new TypedValue(VariableType.String, ((Dimension)dimensions.get(j)).getName());
                                ++j;
                            }
                            j = dimensions.size() + 1;
                            while (j < measures.size() + dimensions.size() + 1) {
                                values[0][j] = new TypedValue(VariableType.String, ((Measure)measures.get(j - dimensions.size() - 1)).getName());
                                ++j;
                            }
                            ++i;
                        }
                        values[i] = new TypedValue[next.getValues().size()];
                        values[i][0] = new TypedValue((Serializable)Double.valueOf(next.getValue("Iteration")));
                        j = 0;
                        while (j < dimensions.size()) {
                            values[i][j + 1] = new TypedValue((Serializable)Double.valueOf(next.getValue("Output: " + ((Dimension)dimensions.get(j)).getName())));
                            ++j;
                        }
                        j = dimensions.size() + 1;
                        while (j < measures.size() + dimensions.size() + 1) {
                            values[i][j] = new TypedValue((Serializable)Double.valueOf(next.getValue(((Measure)measures.get(j - dimensions.size() - 1)).getName())));
                            ++j;
                        }
                        ++i;
                    }
                    success = ExcelFileExporterDialog.exportExcelFile((File)excelFile, (TypedValue[][])values);
                } else {
                    success = false;
                }
                if (excelFile != null) {
                    StudyDataExportMessageHelper.showConfirmationOrWarningMessageDialog((boolean)success, (String)excelFile.getPath());
                    this.preferences.put(ChartDataComposite.EXPORT_TO_EXCEL_PROPERTIES_IDENTIFIER, excelFile.getParent());
                }
            }
        }
    }

    private final class StudyDatastoreContentProvider
    implements IStructuredContentProvider {
        private StudyDatastoreContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (!ChartDataComposite.this.resultDatastore.getDatasets().isEmpty()) {
                ChartDataComposite.this.saveDataButton.setEnabled(true);
            }
            return ChartDataComposite.this.resultDatastore.getDatasets().toArray(new OptimizerResultSet[0]);
        }
    }
}

