/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model.loader;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroContentProvider;
import org.eclipse.ui.internal.intro.impl.model.loader.ModelLoaderUtil;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.intro.config.IIntroContentProvider;
import org.eclipse.ui.intro.config.IIntroContentProviderSite;

public class ContentProviderManager {
    private static ContentProviderManager inst = new ContentProviderManager();
    private Map<String, ContentProviderWrapper> contentProviders = new HashMap<String, ContentProviderWrapper>();

    protected ContentProviderManager() {
    }

    public static ContentProviderManager getInst() {
        return inst;
    }

    public IIntroContentProvider getContentProvider(IntroContentProvider provider) {
        ContentProviderWrapper providerWrapper = this.contentProviders.get(provider.getId());
        if (providerWrapper == null) {
            return null;
        }
        IIntroContentProvider providerClass = providerWrapper.getIIntroContentProvider();
        return providerClass;
    }

    public IIntroContentProvider createContentProvider(IntroContentProvider provider, IIntroContentProviderSite site) {
        String pluginId = provider.getPluginId() != null ? provider.getPluginId() : provider.getBundle().getSymbolicName();
        Object aClass = ModelLoaderUtil.createClassInstance(pluginId, provider.getClassName());
        IIntroContentProvider providerClass = null;
        if (aClass != null && aClass instanceof IIntroContentProvider) {
            providerClass = (IIntroContentProvider)aClass;
            providerClass.init(site);
            if (provider.getId() != null) {
                ContentProviderWrapper wrapper = new ContentProviderWrapper(providerClass, provider.getParentPage());
                this.contentProviders.put(provider.getId(), wrapper);
            }
        } else {
            Log.warning("Failed to create Intro model content provider: " + provider.getClassName());
        }
        return providerClass;
    }

    public AbstractIntroPage getContentProviderParentPage(IIntroContentProvider provider) {
        for (ContentProviderWrapper wrapper : this.contentProviders.values()) {
            boolean foundKey;
            boolean bl = foundKey = wrapper.getIIntroContentProvider().equals(provider);
            if (!foundKey) continue;
            return wrapper.getParentPage();
        }
        return null;
    }

    public void clear() {
        for (ContentProviderWrapper providerWrapper : this.contentProviders.values()) {
            IIntroContentProvider provider = providerWrapper.getIIntroContentProvider();
            provider.dispose();
        }
        this.contentProviders.clear();
        if (Log.logInfo) {
            Log.info("Cleared Intro model content providers");
        }
    }

    class ContentProviderWrapper {
        IIntroContentProvider provider;
        AbstractIntroPage parentPage;

        ContentProviderWrapper(IIntroContentProvider provider, AbstractIntroPage parentPage) {
            this.provider = provider;
            this.parentPage = parentPage;
        }

        IIntroContentProvider getIIntroContentProvider() {
            return this.provider;
        }

        AbstractIntroPage getParentPage() {
            return this.parentPage;
        }
    }
}

