/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.toolkitbridge.api;

import de.rcenvironment.core.toolkitbridge.internal.DefaultToolkitConfiguration;
import de.rcenvironment.toolkit.core.api.Toolkit;
import de.rcenvironment.toolkit.core.api.ToolkitException;
import de.rcenvironment.toolkit.core.setup.ToolkitConfiguration;
import de.rcenvironment.toolkit.core.setup.ToolkitFactory;
import org.apache.commons.logging.LogFactory;

public final class StaticToolkitHolder {
    private static Toolkit instance;
    private static final Object sharedInstanceLock;

    static {
        sharedInstanceLock = StaticToolkitHolder.class;
    }

    private StaticToolkitHolder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Toolkit getInstance() {
        Object object = sharedInstanceLock;
        synchronized (object) {
            if (instance == null) {
                throw new IllegalStateException("No toolkit instance available - most likely, the code tried to access a service before the toolkit was initialized or after it has been shut down");
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(Toolkit newinstance) {
        Object object = sharedInstanceLock;
        synchronized (object) {
            if (newinstance != null && instance != null) {
                throw new IllegalStateException("Duplicate toolkit initialization");
            }
            instance = newinstance;
        }
    }

    public static <T> T getService(Class<T> serviceClass) {
        Object service = StaticToolkitHolder.getInstance().getServiceRegistry().getService(serviceClass);
        if (service == null) {
            throw new IllegalStateException("The registered toolkit does not contain a service for interface " + serviceClass);
        }
        return (T)service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getServiceIfInitialized(Class<T> serviceClass) {
        Object object = sharedInstanceLock;
        synchronized (object) {
            if (instance != null) {
                return StaticToolkitHolder.getService(serviceClass);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getServiceWithUnitTestFallback(Class<T> serviceClass) {
        Object object = sharedInstanceLock;
        synchronized (object) {
            if (instance == null) {
                instance = StaticToolkitHolder.createImplicitToolkit();
            }
        }
        return StaticToolkitHolder.getService(serviceClass);
    }

    private static Toolkit createImplicitToolkit() {
        LogFactory.getLog(StaticToolkitHolder.class).info((Object)"Creating an implicit toolkit instance (usually as part of a unit test)");
        try {
            return ToolkitFactory.create((ToolkitConfiguration)new DefaultToolkitConfiguration());
        }
        catch (ToolkitException e) {
            throw new IllegalStateException("Error creating implicit toolkit instance", e);
        }
    }
}

