/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.execute.AbstractUpdateBehavior;
import de.rcenvironment.core.gui.workflow.execute.CheckboxLabelProvider;
import de.rcenvironment.core.gui.workflow.execute.WorkflowDescriptionContentProvider;
import de.rcenvironment.core.gui.workflow.execute.WorkflowNodeTargetPlatformLabelProvider;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class TableBehaviour
extends AbstractUpdateBehavior {
    private TableViewer tableViewer;
    private Color color;
    private int currentlyUsedSortingColumn = 1;

    public TableBehaviour(TableViewer tableviewer, WorkflowNodeTargetPlatformLabelProvider instanceProvider, CheckboxLabelProvider checkProvider) {
        super(instanceProvider, checkProvider);
        this.tableViewer = tableviewer;
    }

    @Override
    public void updateInstanceColumn(ViewerCell cell) {
        final WorkflowNode workflowNode = (WorkflowNode)cell.getElement();
        TableItem item = (TableItem)cell.getItem();
        TableEditor editor = new TableEditor(this.tableViewer.getTable());
        final CCombo combo = new CCombo((Composite)this.tableViewer.getTable(), 8);
        combo.setData((Object)workflowNode);
        combo.setData("EDITOR", (Object)editor);
        combo.setBackground(this.color);
        combo.addListener(11, new Listener(){

            public void handleEvent(Event argEvent) {
                combo.setText(combo.getText());
            }
        });
        if (!this.comboList.contains(combo)) {
            this.comboList.add(combo);
        }
        editor.grabHorizontal = true;
        editor.horizontalAlignment = 1;
        editor.setEditor((Control)combo, item, 2);
        if (this.editingSupport.getValues(workflowNode).size() > 0) {
            for (String value : this.editingSupport.getValues(workflowNode)) {
                combo.add(value);
            }
        } else {
            combo.setEnabled(false);
            combo.setText("No target instance available");
        }
        Integer selectionIndex = (Integer)this.editingSupport.getValue(workflowNode);
        if (selectionIndex != null && selectionIndex <= combo.getItemCount()) {
            combo.select(selectionIndex.intValue());
        } else {
            combo.select(0);
        }
        this.instanceProvider.handleSelection(combo, workflowNode);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (combo != null) {
                    TableBehaviour.this.instanceProvider.handleSelection(combo, workflowNode);
                    TableBehaviour.this.instanceProvider.getPage().prepareErrorStatement();
                }
            }
        });
        this.prepareValuesForMasterCombo();
    }

    @Override
    public void setComboColor(Color colorToSet) {
        this.color = colorToSet;
    }

    @Override
    public void refreshColumns() {
        this.tableViewer.getTable().setRedraw(false);
        this.checkProvider.clearButtonList();
        this.instanceProvider.clearComboList();
        if (this.currentlyUsedSortingColumn == 2) {
            if (this.tableViewer.getTable().getSortDirection() == 128) {
                this.tableViewer.setContentProvider((IContentProvider)new WorkflowDescriptionContentProvider(128, "COLUMN_INSTANCE"));
            } else {
                this.tableViewer.setContentProvider((IContentProvider)new WorkflowDescriptionContentProvider(1024, "COLUMN_INSTANCE"));
            }
        } else if (this.tableViewer.getTable().getSortDirection() == 128) {
            this.tableViewer.setContentProvider((IContentProvider)new WorkflowDescriptionContentProvider(128, "COLUMN_NAME"));
        } else {
            this.tableViewer.setContentProvider((IContentProvider)new WorkflowDescriptionContentProvider(1024, "COLUMN_NAME"));
        }
        this.isCheckBoxColumnEnabled();
        if (this.columnImageActive) {
            if (allCheckboxesClicked) {
                this.tableViewer.getTable().getColumn(0).setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.CHECK_CHECKED));
            } else {
                this.tableViewer.getTable().getColumn(0).setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.CHECK_UNCHECKED));
            }
        }
        this.tableViewer.getTable().setRedraw(true);
        this.tableViewer.getTable().redraw();
        this.tableViewer.getTable().update();
        this.checkIfDisableMasterBtn();
    }

    @Override
    public void updateCheckBoxColumn(ViewerCell cell) {
        WorkflowNode node = (WorkflowNode)cell.getElement();
        TableEditor editor = new TableEditor(this.tableViewer.getTable());
        TableItem item = (TableItem)cell.getItem();
        final Button btn = new Button((Composite)this.tableViewer.getTable(), 32);
        btn.setBackground(cell.getBackground());
        this.synchronizeButtons();
        if (node.isChecked()) {
            btn.setSelection(true);
        } else {
            btn.setSelection(false);
        }
        this.checkIfDisableMasterBtn();
        btn.setData("CHECK_BOX", (Object)node);
        btn.setData("EDITOR", (Object)editor);
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableBehaviour.this.saveIndexOfComboBeforeRefresh();
                WorkflowNode node = (WorkflowNode)btn.getData("CHECK_BOX");
                node.setChecked(btn.getSelection());
                if (!TableBehaviour.this.checkifAllClicked() && TableBehaviour.this.columnImageActive) {
                    allCheckboxesClicked = false;
                    TableBehaviour.this.tableViewer.getTable().getColumn(0).setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.CHECK_UNCHECKED));
                }
                TableBehaviour.this.prepareValuesForMasterCombo();
                TableBehaviour.this.checkIfDisableMasterBtn();
                TableBehaviour.this.setSavedComboIndex();
            }
        });
        this.btnList.add(btn);
        editor.grabHorizontal = true;
        editor.horizontalAlignment = 16384;
        editor.setEditor((Control)btn, item, 0);
        if (this.editingSupport.getValues(node).size() <= 1) {
            btn.setEnabled(false);
        } else {
            btn.setEnabled(true);
        }
        this.isCheckBoxColumnEnabled();
        if (!this.columnImageActive) {
            this.tableViewer.getTable().getColumn(0).setImage(this.checkDisabled);
        } else {
            this.tableViewer.getTable().getColumn(0).setImage(this.uncheckedImg);
        }
    }

    @Override
    public boolean useFilter(String filterText, Object element) {
        WorkflowNode node = (WorkflowNode)element;
        if (filterText == null) {
            return true;
        }
        if (filterText.equals("")) {
            return true;
        }
        String filterTextSmall = filterText.toLowerCase();
        String temp = node.getComponentDescription().getNode().toString().toLowerCase();
        String componentName = node.getName().toLowerCase();
        String targetInstance = temp.replaceFirst("\"", "");
        return targetInstance.contains(filterTextSmall) || componentName.contains(filterTextSmall);
    }

    public boolean checkifAllClicked() {
        boolean clicked = true;
        ArrayList<Button> allEnabledBtns = new ArrayList<Button>();
        for (Button b : this.btnList) {
            if (!b.isEnabled()) continue;
            allEnabledBtns.add(b);
        }
        for (Button btn : allEnabledBtns) {
            if (btn.getSelection()) continue;
            clicked = false;
        }
        if (this.columnImageActive && clicked && this.btnList.size() > 0) {
            allCheckboxesClicked = true;
            this.tableViewer.getTable().getColumn(0).setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.CHECK_CHECKED));
        }
        return clicked;
    }

    private void synchronizeButtons() {
        for (Button b : this.btnList) {
            WorkflowNode node = (WorkflowNode)b.getData("CHECK_BOX");
            b.setSelection(node.isChecked());
        }
    }

    public int getCurrentlyUsedSortingColumn() {
        return this.currentlyUsedSortingColumn;
    }

    public void setCurrentlyUsedSortingColumn(int currentlyUsedSortingColumn) {
        this.currentlyUsedSortingColumn = currentlyUsedSortingColumn;
    }
}

