/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.properties;

import de.rcenvironment.core.component.api.LoopComponentConstants;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class FaultTolerantLoopSection
extends ValidatingWorkflowNodePropertySection {
    private static final String TEXT_DISCARD = "Discard the evaluation loop run and continue with next one";
    private static final String TEXT_FINALLY_FAIL = "If an evaluation loop run was discarded, finally fail on loop termination (only applicable outside nested loops)";
    private static final String TEXT_ONLY_FAIL_LOOP = "Only fail the loop and forward failure to outer loop (only applicable if used in nested loop)";
    private Button failRadioButtonNAV;
    private Button discardAndContinueRadioButtonNAV;
    private Button rerunAndDiscardRadioButtonNAV;
    private Text rerunTimesAndFailTextNAV;
    private Button rerunAndFailRadioButtonNAV;
    private Text rerunTimesAndDiscardTextNAV;
    private Label rerunTimesAndDiscardLabelNAV;
    private Button failLoopIfAnyRunFailedCheckboxNAV;
    private Button onlyFailLoopCheckboxNAV;
    private Button failRadioButtonCmpFlr;
    private Button discardAndContinueRadioButtonCmpFlr;
    private boolean loopDriverSupportsDiscard;

    @Override
    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        parent.setLayout((Layout)new GridLayout(1, true));
        TabbedPropertySheetWidgetFactory factory = aTabbedPropertySheetPage.getWidgetFactory();
        Section sectionPropertiesNAV = factory.createSection(parent, 320);
        sectionPropertiesNAV.setText("Fault-tolerance in case of 'not-a-value' received");
        Composite compositeNAV = factory.createFlatFormComposite((Composite)sectionPropertiesNAV);
        compositeNAV.setLayout((Layout)new GridLayout(3, false));
        factory.createLabel(compositeNAV, "If a component in the loop sent 'not-a-value':");
        BehaviorInCaseOfFailureSelectionListenerNAV listenerNAV = new BehaviorInCaseOfFailureSelectionListenerNAV();
        this.failRadioButtonNAV = factory.createButton(compositeNAV, "Fail", 16);
        this.spanHorizontal((Control)this.failRadioButtonNAV);
        this.failRadioButtonNAV.setData("faultTolerance-NAV_5e0ed1cd", (Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Fail);
        this.failRadioButtonNAV.addSelectionListener((SelectionListener)listenerNAV);
        this.failRadioButtonNAV.setData("property.control", (Object)"faultTolerance-NAV_5e0ed1cd");
        this.discardAndContinueRadioButtonNAV = factory.createButton(compositeNAV, TEXT_DISCARD, 16);
        this.spanHorizontal((Control)this.discardAndContinueRadioButtonNAV);
        this.discardAndContinueRadioButtonNAV.setData("faultTolerance-NAV_5e0ed1cd", (Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Discard);
        this.discardAndContinueRadioButtonNAV.addSelectionListener((SelectionListener)listenerNAV);
        this.rerunAndFailRadioButtonNAV = factory.createButton(compositeNAV, "Rerun the evaluation loop at the maximum of", 16);
        this.rerunAndFailRadioButtonNAV.setData("faultTolerance-NAV_5e0ed1cd", (Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.RerunAndFail);
        this.rerunAndFailRadioButtonNAV.addSelectionListener((SelectionListener)listenerNAV);
        this.rerunTimesAndFailTextNAV = new Text(compositeNAV, 0x1000800);
        GridData gridData = new GridData(0x1000000);
        gridData.widthHint = 40;
        this.rerunTimesAndFailTextNAV.setLayoutData((Object)gridData);
        this.rerunTimesAndFailTextNAV.setData("property.control", (Object)"maxRerunBeforeFail-NAV_5e0ed1cd");
        this.rerunTimesAndFailTextNAV.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(this.rerunTimesAndFailTextNAV, 18));
        factory.createLabel(compositeNAV, "time(s) and fail if maximum exceeded");
        this.rerunAndDiscardRadioButtonNAV = factory.createButton(compositeNAV, "Rerun the evaluation loop at the maximum of", 16);
        this.rerunAndDiscardRadioButtonNAV.setData("faultTolerance-NAV_5e0ed1cd", (Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.RerunAndDiscard);
        this.rerunAndDiscardRadioButtonNAV.addSelectionListener((SelectionListener)listenerNAV);
        this.rerunTimesAndDiscardTextNAV = new Text(compositeNAV, 0x1000800);
        gridData = new GridData();
        gridData.widthHint = 40;
        this.rerunTimesAndDiscardTextNAV.setLayoutData((Object)gridData);
        this.rerunTimesAndDiscardTextNAV.setData("property.control", (Object)"maxRerunBeforeDiscard-NAV_5e0ed1cd");
        this.rerunTimesAndDiscardTextNAV.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(this.rerunTimesAndDiscardTextNAV, 18));
        this.rerunTimesAndDiscardLabelNAV = factory.createLabel(compositeNAV, "time(s) and discard if maximum exceeded");
        this.failLoopIfAnyRunFailedCheckboxNAV = factory.createButton(compositeNAV, TEXT_FINALLY_FAIL, 32);
        this.spanHorizontal((Control)this.failLoopIfAnyRunFailedCheckboxNAV);
        this.failLoopIfAnyRunFailedCheckboxNAV.setData("property.control", (Object)"finallyFailIfDiscarded-NAV_5e0ed1cd");
        this.onlyFailLoopCheckboxNAV = factory.createButton(compositeNAV, TEXT_ONLY_FAIL_LOOP, 32);
        this.spanHorizontal((Control)this.onlyFailLoopCheckboxNAV);
        this.onlyFailLoopCheckboxNAV.setData("property.control", (Object)"failLoopOnly-NAV_5e0ed1cd");
        sectionPropertiesNAV.setClient((Control)compositeNAV);
        Section sectionPropertiesCmpFlr = factory.createSection(parent, 320);
        sectionPropertiesCmpFlr.setText("Fault-tolerance in case of component failure");
        Composite compositeCmpFlr = factory.createFlatFormComposite((Composite)sectionPropertiesCmpFlr);
        compositeCmpFlr.setLayout((Layout)new GridLayout(1, false));
        compositeCmpFlr.setLayoutData((Object)gridData);
        factory.createLabel(compositeCmpFlr, "If a component in the loop fails:");
        BehaviorInCaseOfFailureSelectionListenerCompFailure listenerCmpFlr = new BehaviorInCaseOfFailureSelectionListenerCompFailure();
        this.failRadioButtonCmpFlr = factory.createButton(compositeCmpFlr, "Fail component", 16);
        this.spanHorizontal((Control)this.failRadioButtonCmpFlr);
        this.failRadioButtonCmpFlr.setData("loopFaultTolerance_5e0ed1cd", (Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Fail);
        this.failRadioButtonCmpFlr.addSelectionListener((SelectionListener)listenerCmpFlr);
        this.failRadioButtonCmpFlr.setData("property.control", (Object)"loopFaultTolerance_5e0ed1cd");
        this.discardAndContinueRadioButtonCmpFlr = factory.createButton(compositeCmpFlr, TEXT_DISCARD, 16);
        this.spanHorizontal((Control)this.discardAndContinueRadioButtonCmpFlr);
        this.discardAndContinueRadioButtonCmpFlr.setData("loopFaultTolerance_5e0ed1cd", (Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Discard);
        this.discardAndContinueRadioButtonCmpFlr.addSelectionListener((SelectionListener)listenerCmpFlr);
        sectionPropertiesCmpFlr.setClient((Control)compositeCmpFlr);
    }

    private void spanHorizontal(Control control) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        control.setLayoutData((Object)gridData);
    }

    @Override
    protected void setWorkflowNode(WorkflowNode workflowNode) {
        super.setWorkflowNode(workflowNode);
        LoopComponentConstants.LoopBehaviorInCaseOfFailure loopBehaviorInCaseOfFailureNAV = LoopComponentConstants.LoopBehaviorInCaseOfFailure.fromString((String)this.getProperty("faultTolerance-NAV_5e0ed1cd"));
        LoopComponentConstants.LoopBehaviorInCaseOfFailure loopBehaviorInCaseOfFailureCmpFlr = LoopComponentConstants.LoopBehaviorInCaseOfFailure.fromString((String)this.getProperty("loopFaultTolerance_5e0ed1cd"));
        this.loopDriverSupportsDiscard = workflowNode.getComponentDescription().getComponentInterface().getLoopDriverSupportsDiscard();
        this.failRadioButtonNAV.setSelection(loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Fail));
        this.failRadioButtonCmpFlr.setSelection(loopBehaviorInCaseOfFailureCmpFlr.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Fail));
        this.rerunAndFailRadioButtonNAV.setSelection(loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.RerunAndFail));
        this.rerunTimesAndFailTextNAV.setEnabled(loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.RerunAndFail));
        this.onlyFailLoopCheckboxNAV.setEnabled((loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Fail) || loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.RerunAndFail)) && Boolean.valueOf(this.getProperty("isNestedLoop_5e0ed1cd")) != false);
        this.discardAndContinueRadioButtonNAV.setEnabled(this.loopDriverSupportsDiscard);
        this.discardAndContinueRadioButtonCmpFlr.setEnabled(this.loopDriverSupportsDiscard);
        this.rerunAndDiscardRadioButtonNAV.setEnabled(this.loopDriverSupportsDiscard);
        this.rerunTimesAndDiscardTextNAV.setEnabled(this.loopDriverSupportsDiscard);
        this.rerunTimesAndDiscardLabelNAV.setEnabled(this.loopDriverSupportsDiscard);
        this.failLoopIfAnyRunFailedCheckboxNAV.setEnabled(this.loopDriverSupportsDiscard && Boolean.valueOf(this.getProperty("isNestedLoop_5e0ed1cd")) == false);
        if (this.loopDriverSupportsDiscard) {
            this.discardAndContinueRadioButtonNAV.setSelection(loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Discard));
            this.discardAndContinueRadioButtonCmpFlr.setSelection(loopBehaviorInCaseOfFailureCmpFlr.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Discard));
            this.rerunAndDiscardRadioButtonNAV.setSelection(loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.RerunAndDiscard));
            this.rerunTimesAndDiscardTextNAV.setEnabled(loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.RerunAndDiscard));
            this.failLoopIfAnyRunFailedCheckboxNAV.setEnabled(this.failLoopIfAnyRunFailedCheckboxNAV.getEnabled() && (loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Discard) || loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.RerunAndDiscard)));
        }
        this.setSelectionOfCheckbox();
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.setActivationOfCheckboxes();
    }

    private void setActivationOfCheckboxes() {
        boolean isNestedLoop = Boolean.valueOf(this.getProperty("isNestedLoop_5e0ed1cd"));
        this.failLoopIfAnyRunFailedCheckboxNAV.setEnabled(!isNestedLoop && (this.discardAndContinueRadioButtonNAV.getSelection() || this.rerunAndDiscardRadioButtonNAV.getSelection()));
        this.onlyFailLoopCheckboxNAV.setEnabled(isNestedLoop && (this.failRadioButtonNAV.getSelection() || this.rerunAndFailRadioButtonNAV.getSelection()));
        this.setSelectionOfCheckbox();
    }

    private void setSelectionOfCheckbox() {
        if (!this.failLoopIfAnyRunFailedCheckboxNAV.isEnabled()) {
            this.failLoopIfAnyRunFailedCheckboxNAV.setSelection(false);
        }
        if (!this.onlyFailLoopCheckboxNAV.isEnabled()) {
            this.onlyFailLoopCheckboxNAV.setSelection(false);
        }
    }

    public void refreshFaultToleranceSection() {
        if (this.discardAndContinueRadioButtonNAV.isDisposed()) {
            return;
        }
        this.setWorkflowNode(this.node);
    }

    @Override
    protected FaultToleranceUpdater createUpdater() {
        return new FaultToleranceUpdater();
    }

    private class BehaviorInCaseOfFailureSelectionListenerCompFailure
    implements SelectionListener {
        private BehaviorInCaseOfFailureSelectionListenerCompFailure() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            Button button = (Button)event.getSource();
            FaultTolerantLoopSection.this.setProperty("loopFaultTolerance_5e0ed1cd", button.getData("loopFaultTolerance_5e0ed1cd").toString());
        }
    }

    private class BehaviorInCaseOfFailureSelectionListenerNAV
    implements SelectionListener {
        private BehaviorInCaseOfFailureSelectionListenerNAV() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            Button button = (Button)event.getSource();
            FaultTolerantLoopSection.this.setProperty("faultTolerance-NAV_5e0ed1cd", button.getData("faultTolerance-NAV_5e0ed1cd").toString());
            FaultTolerantLoopSection.this.rerunTimesAndFailTextNAV.setEnabled(button == FaultTolerantLoopSection.this.rerunAndFailRadioButtonNAV);
            FaultTolerantLoopSection.this.rerunTimesAndDiscardTextNAV.setEnabled(button == FaultTolerantLoopSection.this.rerunAndDiscardRadioButtonNAV);
            FaultTolerantLoopSection.this.setActivationOfCheckboxes();
        }
    }

    protected class FaultToleranceUpdater
    extends WorkflowNodePropertySection.DefaultUpdater {
        protected FaultToleranceUpdater() {
        }

        @Override
        public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
            super.updateControl(control, propertyName, newValue, oldValue);
            FaultTolerantLoopSection.this.refreshFaultToleranceSection();
        }
    }
}

