/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands.endpoint;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;

public class EditDynamicEndpointCommand
extends WorkflowNodeCommand {
    protected final EndpointType direction;
    protected EndpointDescription oldDesc;
    protected EndpointDescription newDesc;
    protected Refreshable[] refreshable;
    private boolean executable = true;
    private boolean undoable = false;
    private EndpointDescriptionsManager manager;

    public EditDynamicEndpointCommand(EndpointType direction, EndpointDescription oldDescription, EndpointDescription newDescription, Refreshable ... refreshable) {
        this.direction = direction;
        this.oldDesc = oldDescription;
        this.newDesc = newDescription;
        this.refreshable = refreshable;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean canExecute() {
        return this.executable;
    }

    @Override
    public void execute() {
        this.manager = this.direction == EndpointType.INPUT ? this.getProperties().getInputDescriptionsManager() : this.getProperties().getOutputDescriptionsManager();
        if (this.executable) {
            if (this.manager.getEndpointDescription(this.oldDesc.getName()).getEndpointDefinition().isStatic()) {
                this.manager.editStaticEndpointDescription(this.oldDesc.getName(), this.newDesc.getDataType(), this.newDesc.getMetaData());
            } else {
                this.manager.editDynamicEndpointDescription(this.oldDesc.getName(), this.newDesc.getName(), this.newDesc.getDataType(), this.newDesc.getMetaData(), this.newDesc.getDynamicEndpointIdentifier());
            }
            this.executable = false;
            this.undoable = true;
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }

    @Override
    public boolean canUndo() {
        return this.undoable;
    }

    @Override
    public void undo() {
        this.manager = this.direction == EndpointType.INPUT ? this.getProperties().getInputDescriptionsManager() : this.getProperties().getOutputDescriptionsManager();
        if (this.undoable) {
            if (this.manager.getEndpointDescription(this.newDesc.getName()).getEndpointDefinition().isStatic()) {
                this.manager.editStaticEndpointDescription(this.newDesc.getName(), this.oldDesc.getDataType(), this.oldDesc.getMetaData());
            } else {
                this.manager.editDynamicEndpointDescription(this.newDesc.getName(), this.oldDesc.getName(), this.oldDesc.getDataType(), this.oldDesc.getMetaData(), this.oldDesc.getDynamicEndpointIdentifier());
            }
            this.executable = true;
            this.undoable = false;
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }
}

