/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.commons;

import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.datamodel.api.FinalWorkflowState;
import java.io.Serializable;
import java.util.Map;

public class WorkflowRunDescription
implements Serializable,
Comparable<WorkflowRunDescription> {
    private static final long serialVersionUID = 2449195140856943911L;
    private final Long workflowRunID;
    private final String workflowTitle;
    private final String controllerLogicalNodeId;
    private transient LogicalNodeId controllerLogicalNodeIdObject;
    private final String storageLogicalNodeId;
    private transient LogicalNodeId storageLogicalNodeIdObject;
    private final Long startTime;
    private final Long endTime;
    private final FinalWorkflowState finalState;
    private final Boolean areFilesDeleted;
    private final Boolean markedForDeletion;
    private final Map<String, String> metaData;

    public WorkflowRunDescription(Long workflowRunID, String workflowTitle, String controllerLogicalNodeId, String storageLogicalNodeId, Long startTime, Long endTime, FinalWorkflowState finalState, Boolean areFilesDeleted, Boolean markedForDeletion, Map<String, String> metaData) {
        this.workflowRunID = workflowRunID;
        this.workflowTitle = workflowTitle;
        this.controllerLogicalNodeId = controllerLogicalNodeId;
        this.storageLogicalNodeId = storageLogicalNodeId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.finalState = finalState;
        this.areFilesDeleted = areFilesDeleted;
        this.markedForDeletion = markedForDeletion;
        this.metaData = metaData;
    }

    public static WorkflowRunDescription cloneAndReplaceNodeIds(WorkflowRunDescription original, String newNodeIdString) {
        return new WorkflowRunDescription(original.workflowRunID, original.workflowTitle, newNodeIdString, newNodeIdString, original.startTime, original.endTime, original.finalState, original.areFilesDeleted, original.markedForDeletion, original.getMetaData());
    }

    public String getWorkflowTitle() {
        return this.workflowTitle;
    }

    public String getControllerLogicalNodeIdString() {
        return this.controllerLogicalNodeId;
    }

    public synchronized LogicalNodeId getControllerLogicalNodeId() {
        if (this.controllerLogicalNodeIdObject == null && this.controllerLogicalNodeId != null) {
            try {
                this.controllerLogicalNodeIdObject = NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeId((String)this.controllerLogicalNodeId);
            }
            catch (IdentifierException e) {
                throw new RuntimeException("Failed to parse component run location string (expected an instance id or logical node id)", e);
            }
        }
        return this.controllerLogicalNodeIdObject;
    }

    public String getStorageLogicalNodeIdString() {
        return this.storageLogicalNodeId;
    }

    public synchronized LogicalNodeId getStorageLogicalNodeId() {
        if (this.storageLogicalNodeIdObject == null && this.storageLogicalNodeId != null) {
            try {
                this.storageLogicalNodeIdObject = NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeId((String)this.storageLogicalNodeId);
            }
            catch (IdentifierException e) {
                throw new RuntimeException("Failed to parse component run location string (expected an instance id or logical node id)", e);
            }
        }
        return this.storageLogicalNodeIdObject;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public Long getWorkflowRunID() {
        return this.workflowRunID;
    }

    public FinalWorkflowState getFinalState() {
        return this.finalState;
    }

    public Boolean getAreFilesDeleted() {
        return this.areFilesDeleted;
    }

    public Boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public String getAdditionalInformationIfAvailable() {
        if (this.metaData.containsKey("additionalInformation")) {
            return this.metaData.get("additionalInformation");
        }
        return null;
    }

    public String getErrorLogFileReference() {
        return this.metaData.get("wfErrorLogFile");
    }

    @Override
    public int compareTo(WorkflowRunDescription arg0) {
        return this.getStartTime().compareTo(arg0.getStartTime());
    }
}

