/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.impl;

import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.model.api.ComponentImageManagerService;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.impl.ComponentImageCacheService;
import de.rcenvironment.core.component.model.impl.ComponentImageUtility;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(scope=ServiceScope.SINGLETON)
public final class ComponentImageManagerImpl
implements ComponentImageManagerService {
    private static final String REQUESTED_ICON_SIZE_NOT_DEFINED = "Requested icon size is not defined inside this switch case";
    private static final String NULL_HASH = "d41d8cd98f00b204e9800998ecf8427e";
    private static final String INTEGRATION = "de.rcenvironment.integration.common.".replace(".common.", "");
    private Map<String, ImagePackage> iconImageMap = new HashMap<String, ImagePackage>();
    private ComponentImageCacheService cacheService;
    private DistributedComponentKnowledgeService knowledgeService;
    private ImagePackage rceDefaultImagePackage;
    private ImagePackage integratedDefaultImagePackage;

    public ComponentImageManagerImpl() {
        this.createDefaultImagePackages();
    }

    private Image getIconImage(String iconHash, String componentId, IconSize size) {
        ComponentInterface ci = this.getComponentInterfaceByHash(iconHash);
        byte[] rawData = null;
        if (ci != null) {
            switch (size) {
                case ICON16: {
                    rawData = ci.getIcon16();
                    break;
                }
                case ICON24: {
                    rawData = ci.getIcon24();
                    break;
                }
                case ICON32: {
                    rawData = ci.getIcon32();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(REQUESTED_ICON_SIZE_NOT_DEFINED);
                }
            }
        }
        if (rawData == null) {
            rawData = this.cacheService.getImageData(iconHash, size);
        }
        if (rawData == null) {
            LogFactory.getLog(this.getClass()).debug((Object)"Finding component interface with image data failed, using fallback icon.");
            return this.getDefaultIcon(componentId, size);
        }
        try {
            return new Image((Device)Display.getCurrent(), (InputStream)new ByteArrayInputStream(rawData));
        }
        catch (SWTException e) {
            LogFactory.getLog(this.getClass()).debug((Object)"Creating component icon failed, using fallback icon.", (Throwable)e);
            return null;
        }
    }

    @Override
    public synchronized ImagePackage getImagePackage(String componentId) {
        ComponentInterface ci = this.getComponentInterfaceById(componentId);
        String iconHash = null;
        if (ci != null) {
            iconHash = ci.getIconHash();
        }
        if (NULL_HASH.equals(iconHash) || iconHash == null) {
            iconHash = this.cacheService.getIconHash(componentId);
        }
        if (iconHash != null) {
            if (this.iconImageMap.containsKey(iconHash)) {
                return this.iconImageMap.get(iconHash);
            }
            ImagePackage tmpImagePackage = new ImagePackage(iconHash);
            this.iconImageMap.put(iconHash, tmpImagePackage);
            return tmpImagePackage;
        }
        if (componentId != null && componentId.contains(INTEGRATION)) {
            return this.integratedDefaultImagePackage;
        }
        return this.rceDefaultImagePackage;
    }

    private void createDefaultImagePackages() {
        this.rceDefaultImagePackage = new DefaultImagePackage("", this.getDefaultIcon(null, IconSize.ICON16), this.getDefaultIcon(null, IconSize.ICON24), this.getDefaultIcon(null, IconSize.ICON32));
        String integration = "de.rcenvironment.integration.common.";
        this.integratedDefaultImagePackage = new DefaultImagePackage("", this.getDefaultIcon(integration, IconSize.ICON16), this.getDefaultIcon(integration, IconSize.ICON24), this.getDefaultIcon(integration, IconSize.ICON32));
    }

    private ComponentInterface getComponentInterfaceById(String componentId) {
        Collection<DistributedComponentEntry> installations = ComponentImageUtility.getDistinctInstallations(this.knowledgeService.getCurrentSnapshot().getAllInstallations());
        ComponentInterface remoteComponentInterface = null;
        for (DistributedComponentEntry entry : installations) {
            if (!entry.getComponentInterface().getIdentifierAndVersion().equals(componentId)) continue;
            remoteComponentInterface = entry.getComponentInterface();
        }
        return remoteComponentInterface;
    }

    private ComponentInterface getComponentInterfaceByHash(String iconHash) {
        Collection<DistributedComponentEntry> installations = ComponentImageUtility.getDistinctInstallations(this.knowledgeService.getCurrentSnapshot().getAllInstallations());
        ComponentInterface remoteComponentInterface = null;
        for (DistributedComponentEntry entry : installations) {
            if (!entry.getComponentInterface().getIconHash().equals(iconHash)) continue;
            remoteComponentInterface = entry.getComponentInterface();
            break;
        }
        return remoteComponentInterface;
    }

    private Image getDefaultIcon(String componentId, IconSize iconSize) {
        StandardImages image;
        switch (iconSize) {
            case ICON16: {
                if (componentId == null || !componentId.contains(INTEGRATION)) {
                    image = StandardImages.RCE_LOGO_16;
                    break;
                }
                image = StandardImages.INTEGRATED_TOOL_DEFAULT_16;
                break;
            }
            case ICON24: {
                if (componentId == null || !componentId.contains(INTEGRATION)) {
                    image = StandardImages.RCE_LOGO_24;
                    break;
                }
                image = StandardImages.INTEGRATED_TOOL_DEFAULT_16;
                break;
            }
            case ICON32: {
                if (componentId == null || !componentId.contains(INTEGRATION)) {
                    image = StandardImages.RCE_LOGO_32;
                    break;
                }
                image = StandardImages.INTEGRATED_TOOL_DEFAULT_32;
                break;
            }
            default: {
                throw new IllegalArgumentException(REQUESTED_ICON_SIZE_NOT_DEFINED);
            }
        }
        return ImageManager.getInstance().getSharedImage((ImageSource)image);
    }

    @Reference
    private void bindComponentImageCacheService(ComponentImageCacheService imageCacheService) {
        this.cacheService = imageCacheService;
    }

    @Reference
    private void bindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService componentKnowledgeService) {
        this.knowledgeService = componentKnowledgeService;
    }

    private class DefaultImagePackage
    extends ImagePackage {
        DefaultImagePackage(String iconHash, Image icon16, Image icon24, Image icon32) {
            super(iconHash);
            this.setImage(icon16, IconSize.ICON16);
            this.setImage(icon24, IconSize.ICON24);
            this.setImage(icon32, IconSize.ICON32);
        }
    }

    public static enum IconSize {
        ICON16,
        ICON24,
        ICON32;

    }

    public class ImagePackage {
        private String iconHash;
        private Image icon16 = null;
        private Image icon24 = null;
        private Image icon32 = null;

        public ImagePackage(String iconHash) {
            this.iconHash = iconHash;
        }

        protected void setImage(Image image, IconSize size) {
            switch (size) {
                case ICON16: {
                    this.icon16 = image;
                    break;
                }
                case ICON24: {
                    this.icon24 = image;
                    break;
                }
                case ICON32: {
                    this.icon32 = image;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(ComponentImageManagerImpl.REQUESTED_ICON_SIZE_NOT_DEFINED);
                }
            }
        }

        public synchronized Image getIcon16(String componentId) {
            if (this.icon16 != null && !this.icon16.isDisposed()) {
                return this.icon16;
            }
            Image tmpImage = ComponentImageManagerImpl.this.getIconImage(this.getIconHash(), componentId, IconSize.ICON16);
            this.setImage(tmpImage, IconSize.ICON16);
            return tmpImage;
        }

        public synchronized Image getIcon24(String componentId) {
            if (this.icon24 != null && !this.icon24.isDisposed()) {
                return this.icon24;
            }
            Image tmpImage = ComponentImageManagerImpl.this.getIconImage(this.getIconHash(), componentId, IconSize.ICON24);
            this.setImage(tmpImage, IconSize.ICON24);
            return tmpImage;
        }

        public synchronized Image getIcon32(String componentId) {
            if (this.icon32 != null && !this.icon32.isDisposed()) {
                return this.icon32;
            }
            Image tmpImage = ComponentImageManagerImpl.this.getIconImage(this.getIconHash(), componentId, IconSize.ICON32);
            this.setImage(tmpImage, IconSize.ICON32);
            return tmpImage;
        }

        public String getIconHash() {
            return this.iconHash;
        }
    }
}

