/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.api;

import de.rcenvironment.core.component.execution.api.ComponentExecutionIdentifier;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.Serializable;

public class WorkflowGraphHop
implements Serializable {
    private static final long serialVersionUID = 2180475342338990576L;
    private final ComponentExecutionIdentifier executionIdentifier;
    private final String ouputName;
    private final ComponentExecutionIdentifier targetExecutionIdentifier;
    private final String targetInputName;
    private final String hopOutputId;

    public WorkflowGraphHop(ComponentExecutionIdentifier sourceExecutionIdentifier, String sourceOutputName, ComponentExecutionIdentifier targetExecutionIdentifier, String targetInputName) {
        this(sourceExecutionIdentifier, sourceOutputName, targetExecutionIdentifier, targetInputName, null);
    }

    public WorkflowGraphHop(ComponentExecutionIdentifier hopExecutionIdentifier, String hopOuputName, ComponentExecutionIdentifier targetExecutionIdentifier, String targetInputName, String hopOutputId) {
        this.executionIdentifier = hopExecutionIdentifier;
        this.ouputName = hopOuputName;
        this.targetExecutionIdentifier = targetExecutionIdentifier;
        this.targetInputName = targetInputName;
        this.hopOutputId = hopOutputId;
    }

    public ComponentExecutionIdentifier getHopExecutionIdentifier() {
        return this.executionIdentifier;
    }

    public String getHopOuputName() {
        return this.ouputName;
    }

    public ComponentExecutionIdentifier getTargetExecutionIdentifier() {
        return this.targetExecutionIdentifier;
    }

    public String getTargetInputName() {
        return this.targetInputName;
    }

    protected String getHopOutputIdentifier() {
        return this.hopOutputId;
    }

    public String toString() {
        return StringUtils.format((String)"%s@%s -> %s@%s", (Object[])new Object[]{this.ouputName, this.executionIdentifier, this.targetInputName, this.targetExecutionIdentifier});
    }

    public boolean connectsSameNodes(WorkflowGraphHop other) {
        return this.executionIdentifier.equals(other.executionIdentifier) && this.targetExecutionIdentifier.equals(other.targetExecutionIdentifier);
    }
}

