/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.cpacs;

import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.Component;
import de.rcenvironment.core.component.integration.CommonToolIntegratorComponent;
import de.rcenvironment.core.component.integration.cpacs.CpacsIntegrationHistoryDataItem;
import de.rcenvironment.core.component.xml.api.EndpointXMLService;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.DataTypeException;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.datamodel.types.api.NotAValueTD;
import de.rcenvironment.core.scripting.ScriptingService;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.xml.XMLException;
import de.rcenvironment.core.utils.common.xml.XSLTErrorHandler;
import de.rcenvironment.core.utils.common.xml.api.XMLMapperService;
import de.rcenvironment.core.utils.common.xml.api.XMLSupportService;
import de.rcenvironment.toolkit.utils.text.AbstractTextLinesReceiver;
import de.rcenvironment.toolkit.utils.text.TextLinesReceiver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class CpacsToolIntegratorComponent
extends CommonToolIntegratorComponent {
    private static final Log LOG = LogFactory.getLog(CpacsToolIntegratorComponent.class);
    private static final String FILE_SUFFIX_MAPPED = "-mapped";
    private static final String STRING_CPACS_RESULT_FILE_CREATED = "Created CPACS result file '%s'.";
    private static final String SUFFIX_MAPPED = "-mapped";
    private static final String STRING_NOT_AVAILABLE_IN_WDB = "; it is not available in the workflow data browser";
    private static final String STRING_TOOL_INPUT_FILE_NOT_FOUND = "Tool input file '%s' not found";
    private static final String STRING_XML_ERROR_DURING_MAPPING = "Failed to perform %s mapping";
    private static final String STRING_TOOL_INPUT_CREATED = "Created tool input file '%s'.";
    private static final String STRING_MAPPING_USAGE = "Using %s %s mapping...";
    private static final String STRING_MAPPING_TYPE_XML = "pairing";
    private static final String STRING_MAPPING_TYPE_XSL = "raw XSLT";
    private static final String STRING_TOOL_MAPPING_DIRECTION_INPUT = "tool input";
    private static final String STRING_MAPPING_DIRECTION_INPUT = "input";
    private static final String STRING_TOOL_MAPPING_DIRECTION_OUTPUT = "tool output";
    private static final String STRING_MAPPING_DIRECTION_OUTPUT = "output";
    private static final String STRING_MAPPING_DIRECTION_TOOLSPECIFIC = "tool specific input";
    private static final String STRING_MAPPING_FILE_NOT_FOUND = "Mapping file '%s' not found";
    private static final String STRING_ERROR_SOLVING_FILE_EXTENSION = "Failed to resolve file extension of mapping file '%s'";
    private static final String CREATE_MAPPING_XSLT_FILEPATH = "/resources/CreateMapping.xslt";
    private static final String XMLFILE_SEPARATOR = "/";
    private XMLMapperService xmlMapper;
    private XMLSupportService xmlSupport;
    private EndpointXMLService dynamicEndpointMapper;
    private File lastRunToolinputFile;
    private File tmpOutputFile;

    public void start() throws ComponentException {
        this.dynamicEndpointMapper = (EndpointXMLService)this.componentContext.getService(EndpointXMLService.class);
        this.xmlMapper = (XMLMapperService)this.componentContext.getService(XMLMapperService.class);
        this.xmlSupport = (XMLSupportService)this.componentContext.getService(XMLSupportService.class);
        super.start();
        this.lastRunToolinputFile = null;
    }

    protected void beforePreScriptExecution(Map<String, TypedDatum> inputValues, Map<String, String> inputNamesToLocalFile) throws ComponentException {
        HashMap<String, TypedDatum> dynamicInputs = new HashMap<String, TypedDatum>();
        for (String inputName : this.componentContext.getInputsWithDatum()) {
            if (!this.componentContext.isDynamicInput(inputName)) continue;
            dynamicInputs.put(inputName, this.componentContext.readInput(inputName));
        }
        String cpacsInitial = inputNamesToLocalFile.get(this.getCpacsInitialEndpointName());
        if (cpacsInitial == null) {
            throw new ComponentException(StringUtils.format((String)"Failed to read CPACS from input '%s'; input is not configured", (Object[])new Object[]{this.getCpacsInitialEndpointName()}));
        }
        this.performDynamicInputMapping(cpacsInitial, dynamicInputs);
        if (!this.isMockMode()) {
            this.performInputMapping(cpacsInitial, dynamicInputs);
            if (this.getHistoryDataItem() != null) {
                try {
                    File toolInputFile = new File(this.getToolInput());
                    String toolInputFileReference = this.datamanagementService.createTaggedReferenceFromLocalFile(this.componentContext, toolInputFile, toolInputFile.getName());
                    this.getHistoryDataItem().setToolInputFile(toolInputFile.getName(), toolInputFileReference);
                }
                catch (IOException e) {
                    String errorMessage = "Failed to store tool input file into the data management; it is not available in the workflow data browser";
                    String errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)LOG, (String)errorMessage, (Throwable)e);
                    this.componentContext.getLog().componentError(errorMessage, (Throwable)e, errorId);
                }
            }
        }
    }

    private void performDynamicInputMapping(String cpacsInitial, Map<String, TypedDatum> dynamicInputs) throws ComponentException {
        try {
            this.dynamicEndpointMapper.updateXMLWithInputs(new File(cpacsInitial), dynamicInputs, this.componentContext);
        }
        catch (DataTypeException e) {
            throw new ComponentException("Failed to map dynamic input values into CPACS file", (Throwable)e);
        }
        if (!dynamicInputs.isEmpty() && this.getHistoryDataItem() != null) {
            try {
                String cpacsWithVariablesFileReference = this.datamanagementService.createTaggedReferenceFromLocalFile(this.componentContext, new File(cpacsInitial), "cpacsWithVariables.xml");
                this.getHistoryDataItem().setCpacsWithVariablesFileReference(cpacsWithVariablesFileReference);
            }
            catch (IOException e) {
                String errorMessage = "Failed to store CPACS file with dynamic input values into the data management; it is not available in the workflow data browser";
                String errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)LOG, (String)errorMessage, (Throwable)e);
                this.componentContext.getLog().componentError(errorMessage, (Throwable)e, errorId);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void performInputMapping(String cpacsInitial, Map<String, TypedDatum> dynamicInputs) throws ComponentException {
        block20: {
            this.createIntermediateFolders();
            mappingFile = new File(this.getInputMapping());
            if (!mappingFile.exists()) ** GOTO lbl23
            if (mappingFile.getName().endsWith("xml")) {
                this.componentLog.componentInfo(StringUtils.format((String)"Using %s %s mapping...", (Object[])new Object[]{"pairing", "input"}));
                try {
                    mappingDoc = this.transformXMLMapping(mappingFile.getAbsolutePath(), cpacsInitial, "");
                    toolInputFilePath = this.getToolInput();
                    this.xmlMapper.transformXMLFileWithXMLMappingInformation(new File(cpacsInitial), new File(toolInputFilePath), mappingDoc);
                    if (!new File(toolInputFilePath).exists()) ** GOTO lbl24
                    this.componentLog.componentInfo(StringUtils.format((String)"Created tool input file '%s'.", (Object[])new Object[]{toolInputFilePath}));
                }
                catch (XMLException | XPathExpressionException e) {
                    throw new ComponentException(StringUtils.format((String)"Failed to perform %s mapping", (Object[])new Object[]{"tool input"}), e);
                }
            } else if (mappingFile.getName().endsWith("xsl")) {
                this.componentLog.componentInfo(StringUtils.format((String)"Using %s %s mapping...", (Object[])new Object[]{"raw XSLT", "input"}));
                try {
                    this.xmlMapper.transformXMLFileWithXSLT(new File(cpacsInitial), new File(this.getToolInput()), mappingFile, (TextLinesReceiver)new CpacsToolIntegratorTextLinesReceiver());
                }
                catch (XMLException e) {
                    throw new ComponentException(StringUtils.format((String)"Failed to perform %s mapping", (Object[])new Object[]{"tool input"}), (Throwable)e);
                }
            } else {
                throw new ComponentException(StringUtils.format((String)"Failed to resolve file extension of mapping file '%s'", (Object[])new Object[]{this.getInputMapping()}));
lbl23:
                // 1 sources

                throw new ComponentException(StringUtils.format((String)"Mapping file '%s' not found", (Object[])new Object[]{this.getInputMapping()}));
            }
lbl24:
            // 3 sources

            if (!this.hasToolspecificinputfile()) break block20;
            if (this.getHistoryDataItem() != null) {
                try {
                    toolInputFileReference = this.datamanagementService.createTaggedReferenceFromLocalFile(this.componentContext, new File(this.getToolInput()), String.valueOf(this.getToolInputFileName()) + "-mapped");
                    this.getHistoryDataItem().setToolInputWithoutToolspecificFileReference(toolInputFileReference);
                }
                catch (IOException e) {
                    errorMessage = "Failed to store tool input file into the data management; it is not available in the workflow data browser";
                    errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)CpacsToolIntegratorComponent.LOG, (String)errorMessage, (Throwable)e);
                    this.componentContext.getLog().componentError(errorMessage, (Throwable)e, errorId);
                }
            }
            if (!(mappingFile1 = new File(this.getToolspecificInputMapping())).exists()) ** GOTO lbl56
            if (mappingFile1.getName().endsWith("xml")) {
                this.componentLog.componentInfo(StringUtils.format((String)"Using %s %s mapping...", (Object[])new Object[]{"pairing", "tool specific input"}));
                try {
                    mappingDoc = this.transformXMLMapping(this.getToolspecificInputMapping(), this.getToolspecificInputData(), this.getToolInput());
                    this.xmlMapper.transformXMLFileWithXMLMappingInformation(new File(this.getToolspecificInputData()), new File(this.getToolInput()), mappingDoc);
                }
                catch (XMLException | XPathExpressionException e) {
                    throw new ComponentException(StringUtils.format((String)"Failed to perform %s mapping", (Object[])new Object[]{"tool specific input"}), e);
                }
            } else if (mappingFile1.getName().endsWith("xsl")) {
                this.componentLog.componentInfo(StringUtils.format((String)"Using %s %s mapping...", (Object[])new Object[]{"raw XSLT", "tool specific input"}));
                toolInputMapped = new File(String.valueOf(this.getToolInput()) + "-mapped");
                toolInput = new File(this.getToolInput());
                try {
                    FileUtils.copyFile((File)toolInput, (File)toolInputMapped, (boolean)true);
                    this.xmlMapper.transformXMLFileWithXSLT(new File(String.valueOf(this.getToolInput()) + "-mapped"), new File(this.getToolInput()), new File(this.getToolspecificInputMapping()), null);
                }
                catch (IOException e) {
                    throw new ComponentException(StringUtils.format((String)"Tool input file '%s' not found", (Object[])new Object[]{this.getToolInput()}), (Throwable)e);
                }
                catch (XMLException v0) {
                    throw new ComponentException(StringUtils.format((String)"Failed to perform %s mapping", (Object[])new Object[]{"tool specific input"}));
                }
            } else {
                throw new ComponentException(StringUtils.format((String)"Failed to resolve file extension of mapping file '%s'", (Object[])new Object[]{this.getToolspecificInputMapping()}));
lbl56:
                // 1 sources

                throw new ComponentException(StringUtils.format((String)"Mapping file '%s' not found", (Object[])new Object[]{this.getToolspecificInputMapping()}));
            }
        }
    }

    private void createIntermediateFolders() throws ComponentException {
        if (this.copyToolBehaviour.equals("always") || this.copyToolBehaviour.equals("once")) {
            try {
                String inputParent = new File(this.getToolInput()).getParent();
                String outputParent = new File(this.getToolOutput()).getParent();
                if (inputParent != null && !inputParent.equals(this.executionToolDirectory.getAbsolutePath())) {
                    FileUtils.forceMkdir((File)new File(inputParent));
                }
                if (outputParent != null && !outputParent.equals(this.executionToolDirectory.getAbsolutePath())) {
                    FileUtils.forceMkdir((File)new File(outputParent));
                }
            }
            catch (IOException e) {
                throw new ComponentException("Failed to generate intermediate tool input/output folders", (Throwable)e);
            }
        }
    }

    protected boolean needToRun(Map<String, TypedDatum> inputValues, Map<String, String> inputNamesToLocalFile) throws ComponentException {
        String tmpInputFile;
        block5: {
            if (this.isAlwaysRun() || this.isMockMode()) {
                return true;
            }
            try {
                tmpInputFile = FileUtils.readFileToString((File)new File(this.getToolInput()));
                if (this.lastRunToolinputFile == null) break block5;
                String lastRunToolinput = FileUtils.readFileToString((File)this.lastRunToolinputFile);
                if (lastRunToolinput == null || this.lastRunStaticInputValues == null || tmpInputFile.compareTo(lastRunToolinput) != 0 || this.staticInputsAreNotEqual(inputValues, inputNamesToLocalFile)) {
                    lastRunToolinput = tmpInputFile;
                    TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(this.lastRunToolinputFile);
                    this.lastRunToolinputFile = TempFileServiceAccess.getInstance().createTempFileFromPattern("CPACSLastRun*.xml");
                    FileUtils.write((File)this.lastRunToolinputFile, (CharSequence)tmpInputFile);
                    return true;
                }
            }
            catch (IOException e) {
                throw new ComponentException("Failed to read tool input file", (Throwable)e);
            }
        }
        this.lastRunToolinputFile = TempFileServiceAccess.getInstance().createTempFileFromPattern("CPACSLastRun*.xml");
        FileUtils.write((File)this.lastRunToolinputFile, (CharSequence)tmpInputFile);
        return true;
        this.componentLog.componentInfo("Skipping tool execution as input values not changed compared to previous run");
        return false;
    }

    private boolean staticInputsAreNotEqual(Map<String, TypedDatum> inputValues, Map<String, String> inputNamesToLocalFile) {
        for (String inputName : inputValues.keySet()) {
            if (inputName.equals(this.getCpacsInitialEndpointName()) || !this.componentContext.isStaticInput(inputName) || !this.lastRunStaticInputValues.containsKey(inputName)) continue;
            if (this.componentContext.getInputDataType(inputName) == DataType.FileReference) {
                String uuidLastRun = ((FileReferenceTD)this.lastRunStaticInputValues.get(inputName)).getFileReference();
                String uuidCurrentRun = ((FileReferenceTD)inputValues.get(inputName)).getFileReference();
                try {
                    File tempDir = TempFileServiceAccess.getInstance().createManagedTempDir();
                    File lastFile = new File(tempDir, ((FileReferenceTD)this.lastRunStaticInputValues.get(inputName)).getFileName());
                    File currentFile = new File(tempDir, ((FileReferenceTD)inputValues.get(inputName)).getFileName());
                    this.datamanagementService.copyReferenceToLocalFile(uuidLastRun, lastFile, this.componentContext.getStorageNetworkDestination());
                    this.datamanagementService.copyReferenceToLocalFile(uuidCurrentRun, currentFile, this.componentContext.getStorageNetworkDestination());
                    if (!this.compareFiles(tempDir, lastFile, currentFile)) continue;
                    return true;
                }
                catch (IOException e) {
                    String errorMessage = "Failed to read file (previous input value) from the data management; consider input values as changed";
                    String errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)LOG, (String)errorMessage, (Throwable)e);
                    this.componentLog.componentError(errorMessage, (Throwable)e, errorId);
                    return true;
                }
            }
            if (this.componentContext.getInputDataType(inputName) == DataType.DirectoryReference) {
                try {
                    File tempDir = TempFileServiceAccess.getInstance().createManagedTempDir();
                    File lastDir = new File(tempDir, ((DirectoryReferenceTD)this.lastRunStaticInputValues.get(inputName)).getDirectoryName());
                    File currentDir = new File(tempDir, String.valueOf(((DirectoryReferenceTD)inputValues.get(inputName)).getDirectoryName()) + "_curr");
                    this.datamanagementService.copyDirectoryReferenceTDToLocalDirectory(this.componentContext, (DirectoryReferenceTD)this.lastRunStaticInputValues.get(inputName), lastDir);
                    this.datamanagementService.copyDirectoryReferenceTDToLocalDirectory(this.componentContext, (DirectoryReferenceTD)inputValues.get(inputName), currentDir);
                    if (this.compareDirectories(tempDir, lastDir, currentDir)) continue;
                    return true;
                }
                catch (IOException e) {
                    String errorMessage = "Failed to read directory (previous input value) from the data management; consider input values as changed";
                    String errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)LOG, (String)errorMessage, (Throwable)e);
                    this.componentLog.componentError(errorMessage, (Throwable)e, errorId);
                    return true;
                }
            }
            if (((TypedDatum)this.lastRunStaticInputValues.get(inputName)).equals(inputValues.get(inputName))) continue;
            return true;
        }
        return false;
    }

    private boolean compareDirectories(File tempDir, File lastDir, File currentDir) {
        File[] lastList = lastDir.listFiles();
        File[] currentList = currentDir.listFiles();
        String md5Last = this.expandFiles(lastList, "");
        String md5Current = this.expandFiles(currentList, "");
        return md5Last.equals(md5Current);
    }

    private String expandFiles(File[] dirFiles, String md5in) {
        String md5out = md5in;
        Arrays.sort(dirFiles);
        File[] fileArray = dirFiles;
        int n = dirFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory() && !file.isHidden()) {
                md5out = String.valueOf(md5out) + this.expandFiles(file.listFiles(), md5out);
            } else if (file.isFile() && !file.isHidden()) {
                try {
                    byte[] fileInput = FileUtils.readFileToByteArray((File)file);
                    md5out = String.valueOf(md5out) + DigestUtils.md5Hex((byte[])fileInput);
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed to expand files", (Throwable)e);
                    md5out = "";
                }
            }
            ++n2;
        }
        return md5out;
    }

    private boolean compareFiles(File tempDir, File lastFile, File currentFile) throws IOException {
        if (!FileUtils.contentEquals((File)lastFile, (File)currentFile)) {
            lastFile.delete();
            currentFile.delete();
            TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(tempDir);
            return true;
        }
        lastFile.delete();
        currentFile.delete();
        TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(tempDir);
        return false;
    }

    protected void afterPostScriptExecution(Map<String, TypedDatum> inputValues, Map<String, String> inputNamesToLocalFile) throws ComponentException {
        Set outputsWithNotAValue = this.getOutputsWithNotAValueWritten();
        if (outputsWithNotAValue.contains(this.getCpacsOutputName())) {
            this.writeNotAValueToDynamicOutputs(outputsWithNotAValue);
            this.componentLog.componentInfo("not-a-value was sent to the output '%s' to which the resulting CPACS file is intended to be written to; thus, output mapping is skipped, the resulting CPACS file is not sent and not-a-value is sent to all of the dynamic outputs (if existent) which would extract some value from the resulting CPACS file");
            return;
        }
        File outputFile = new File(this.getToolOutput());
        if (this.needsToRun) {
            if (!outputFile.exists()) {
                throw new ComponentException(StringUtils.format((String)"Failed to perform output mapping. Tool output file is missing after post script execution: %s", (Object[])new Object[]{this.getToolOutput()}));
            }
            if (!this.isAlwaysRun()) {
                try {
                    if (this.tmpOutputFile != null && this.tmpOutputFile.exists()) {
                        TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(this.tmpOutputFile);
                    }
                    this.tmpOutputFile = TempFileServiceAccess.getInstance().createTempFileFromPattern("cpacsToolOutput-*.xml");
                    FileUtils.copyFile((File)outputFile, (File)this.tmpOutputFile);
                }
                catch (IOException iOException) {
                    throw new ComponentException("Failed to generate the temporary file for caching tool results.");
                }
            }
        } else {
            try {
                FileUtils.copyFile((File)this.tmpOutputFile, (File)outputFile);
            }
            catch (IOException iOException) {
                throw new ComponentException("Failed to perform output mapping after skipped tool execution. The temporary tool output file of last execution is missing.");
            }
        }
        if (this.getHistoryDataItem() != null) {
            try {
                String toolOutputFileReference = this.datamanagementService.createTaggedReferenceFromLocalFile(this.componentContext, outputFile, outputFile.getName());
                this.getHistoryDataItem().setToolOutputFile(outputFile.getName(), toolOutputFileReference);
            }
            catch (IOException iOException) {
                throw new ComponentException(StringUtils.format((String)"Failed to find tool output file: %s", (Object[])new Object[]{this.getToolOutput()}));
            }
        }
        try {
            String cpacsInitial = inputNamesToLocalFile.get(this.getCpacsInitialEndpointName());
            this.performOutputMapping(cpacsInitial);
            this.dynamicEndpointMapper.updateOutputsFromXML(new File(this.getCpacsResult()), this.componentContext);
            File resultFile = new File(this.getCpacsResult());
            FileReferenceTD outgoingCPACSFileReference = this.datamanagementService.createFileReferenceTDFromLocalFile(this.componentContext, resultFile, this.componentContext.getConfigurationValue("cpacsResultFilename"));
            this.componentContext.writeOutput(this.getCpacsOutputName(), (TypedDatum)outgoingCPACSFileReference);
            if (this.getHistoryDataItem() != null) {
                this.getHistoryDataItem().addOutput(this.getCpacsOutputName(), (TypedDatum)outgoingCPACSFileReference);
            }
        }
        catch (DataTypeException e) {
            throw new ComponentException("Failed to extract dynamic output values from CPACS", (Throwable)e);
        }
        catch (IOException e) {
            throw new ComponentException("Failed to create result CPACS file", (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new ComponentException(StringUtils.format((String)"Failed to write output to CPACS output '%s'.", (Object[])new Object[]{this.getCpacsOutputName()}), (Throwable)e);
        }
    }

    private void writeNotAValueToDynamicOutputs(Set<String> outputsWithNotAValue) {
        TypedDatumFactory typedDatumFactory = ((TypedDatumService)this.componentContext.getService(TypedDatumService.class)).getFactory();
        for (String outputName : this.componentContext.getOutputs()) {
            if (!this.componentContext.isDynamicOutput(outputName) || outputsWithNotAValue.contains(outputName)) continue;
            this.componentContext.writeOutput(outputName, (TypedDatum)typedDatumFactory.createNotAValue(NotAValueTD.Cause.InvalidInputs));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void performOutputMapping(String cpacsInitial) throws ComponentException {
        File mappingFile = new File(this.getOutputMapping());
        if (!mappingFile.exists()) throw new ComponentException(StringUtils.format((String)STRING_MAPPING_FILE_NOT_FOUND, (Object[])new Object[]{this.getOutputMapping()}));
        if (mappingFile.getName().endsWith("xml")) {
            this.componentLog.componentInfo(StringUtils.format((String)STRING_MAPPING_USAGE, (Object[])new Object[]{STRING_MAPPING_TYPE_XML, STRING_TOOL_MAPPING_DIRECTION_OUTPUT}));
            try {
                Document mappingDoc = this.transformXMLMapping(mappingFile.getAbsolutePath(), this.getToolOutput(), cpacsInitial);
                String cpacsResultFilePath = this.getCpacsResult();
                File resultFile = new File(cpacsResultFilePath);
                FileUtils.copyFile((File)new File(cpacsInitial), (File)resultFile);
                this.xmlMapper.transformXMLFileWithXMLMappingInformation(new File(this.getToolOutput()), resultFile, mappingDoc);
                if (!resultFile.exists()) return;
                this.componentLog.componentInfo(StringUtils.format((String)STRING_CPACS_RESULT_FILE_CREATED, (Object[])new Object[]{cpacsResultFilePath}));
                return;
            }
            catch (XMLException | IOException | XPathExpressionException e) {
                throw new ComponentException(StringUtils.format((String)STRING_XML_ERROR_DURING_MAPPING, (Object[])new Object[]{STRING_TOOL_MAPPING_DIRECTION_OUTPUT}), e);
            }
        }
        if (!mappingFile.getName().endsWith("xsl")) throw new ComponentException(StringUtils.format((String)STRING_ERROR_SOLVING_FILE_EXTENSION, (Object[])new Object[]{this.getOutputMapping()}));
        this.componentLog.componentInfo(StringUtils.format((String)STRING_MAPPING_USAGE, (Object[])new Object[]{STRING_MAPPING_TYPE_XSL, STRING_MAPPING_DIRECTION_OUTPUT}));
        try {
            this.xmlMapper.transformXMLFileWithXSLT(new File(cpacsInitial), new File(this.getCpacsResult()), mappingFile, (TextLinesReceiver)new CpacsToolIntegratorTextLinesReceiver());
            return;
        }
        catch (XMLException e) {
            throw new ComponentException(StringUtils.format((String)STRING_XML_ERROR_DURING_MAPPING, (Object[])new Object[]{STRING_MAPPING_DIRECTION_OUTPUT}), (Throwable)e);
        }
    }

    protected void initializeNewHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.historyDataItem = new CpacsIntegrationHistoryDataItem(this.componentContext.getComponentIdentifier());
        }
    }

    private CpacsIntegrationHistoryDataItem getHistoryDataItem() {
        return (CpacsIntegrationHistoryDataItem)this.historyDataItem;
    }

    protected String getCpacsInitialEndpointName() {
        return this.componentContext.getConfigurationValue("cpacsInitialEndpointName");
    }

    protected String getToolInput() {
        return this.executionToolDirectory + File.separator + this.getToolInputFileName();
    }

    private String getToolInputFileName() {
        return this.componentContext.getConfigurationValue("toolInputFileName");
    }

    protected String getInputMapping() {
        return this.executionToolDirectory + File.separator + this.componentContext.getConfigurationValue("mappingInputFilename");
    }

    protected boolean hasToolspecificinputfile() {
        return this.componentContext.getConfigurationValue("hasToolSpecificInput") != null && Boolean.parseBoolean(this.componentContext.getConfigurationValue("hasToolSpecificInput"));
    }

    protected boolean isAlwaysRun() {
        return this.componentContext.getConfigurationValue("alwaysRun") == null || Boolean.parseBoolean(this.componentContext.getConfigurationValue("alwaysRun"));
    }

    protected String getToolspecificInputMapping() {
        return this.executionToolDirectory + File.separator + this.componentContext.getConfigurationValue("toolspecificMappingFilename");
    }

    protected String getToolspecificInputData() {
        return this.executionToolDirectory + File.separator + this.componentContext.getConfigurationValue("toolspecificInputdataFilename");
    }

    protected String getCpacsResult() {
        return this.outputDirectory + File.separator + this.componentContext.getConfigurationValue("cpacsResultFilename");
    }

    protected String getCpacsOutputName() {
        return this.componentContext.getConfigurationValue("cpacsOutgoingEndpointName");
    }

    protected String getOutputMapping() {
        return this.executionToolDirectory + File.separator + this.componentContext.getConfigurationValue("mappingOutputFilename");
    }

    protected String getToolOutput() {
        if (!this.isMockMode()) {
            return this.executionToolDirectory + File.separator + this.componentContext.getConfigurationValue("toolOutputFilename");
        }
        return this.executionToolDirectory + File.separator + this.componentContext.getConfigurationValue("imitationToolOutputFilename");
    }

    protected void bindScriptingService(ScriptingService service) {
        super.bindScriptingService(service);
    }

    protected void bindComponentDataManagementService(ComponentDataManagementService compDataManagementService) {
        super.bindComponentDataManagementService(compDataManagementService);
    }

    private Document transformXMLMapping(String mappingFilename, String sourceFilename, String targetFilename) throws XMLException {
        try {
            TransformerFactory transformerFac = TransformerFactory.newInstance();
            transformerFac.setErrorListener((ErrorListener)new XSLTErrorHandler());
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(CREATE_MAPPING_XSLT_FILEPATH);){
                Transformer transformer1 = transformerFac.newTransformer(new StreamSource(inStream));
                transformer1.setErrorListener((ErrorListener)new XSLTErrorHandler());
                DOMSource mappingSrc = new DOMSource(this.xmlSupport.readXMLFromFile(new File(mappingFilename)));
                Document tempDoc = this.xmlSupport.createDocument();
                DOMResult tempXSLT = new DOMResult(tempDoc);
                transformer1.transform(mappingSrc, tempXSLT);
                DOMSource sourceXSLT = new DOMSource(tempDoc);
                Transformer transformer2 = transformerFac.newTransformer(sourceXSLT);
                transformer2.setErrorListener((ErrorListener)new XSLTErrorHandler());
                transformer2.setParameter("sourceFilename", sourceFilename.replace("\\", XMLFILE_SEPARATOR));
                transformer2.setParameter("targetFilename", targetFilename.replace("\\", XMLFILE_SEPARATOR));
                DOMSource source = new DOMSource(this.xmlSupport.createDocument());
                Document resultDoc = this.xmlSupport.createDocument();
                DOMResult result = new DOMResult(resultDoc);
                transformer2.transform(source, result);
                return resultDoc;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (XMLException | IOException | NullPointerException | TransformerException e) {
            throw new XMLException("XML-Transformation failed: " + e.toString());
        }
    }

    public void tearDown(Component.FinalComponentState state) {
        super.tearDown(state);
        try {
            if (this.lastRunToolinputFile != null) {
                TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(this.lastRunToolinputFile);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to delete temp file: " + this.lastRunToolinputFile.getAbsolutePath()), (Throwable)e);
        }
        try {
            if (this.tmpOutputFile != null) {
                TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(this.tmpOutputFile);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to delete temp file: " + this.tmpOutputFile.getAbsolutePath()), (Throwable)e);
        }
    }

    private final class CpacsToolIntegratorTextLinesReceiver
    extends AbstractTextLinesReceiver {
        private CpacsToolIntegratorTextLinesReceiver() {
        }

        public void addLine(String line) {
            CpacsToolIntegratorComponent.this.componentContext.getLog().componentInfo(line);
        }
    }
}

