/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.sshconnection.impl;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionListener;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionSetup;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.ssh.jsch.JschSessionFactory;
import de.rcenvironment.core.utils.ssh.jsch.SshParameterException;
import de.rcenvironment.core.utils.ssh.jsch.SshSessionConfiguration;
import de.rcenvironment.core.utils.ssh.jsch.SshSessionConfigurationFactory;
import de.rcenvironment.toolkit.modules.concurrency.api.ThreadGuard;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshConnectionSetupImpl
implements SshConnectionSetup {
    private SshSessionConfiguration config;
    private String id;
    private String displayName;
    private Session session;
    private SshConnectionListener listener;
    private boolean connectOnStartup;
    private boolean autoRetry;
    private boolean usePassphrase;
    private int consecutiveConnectionFailures;
    private volatile boolean waitingForRetry;
    private Log log = LogFactory.getLog(this.getClass());

    public SshConnectionSetupImpl(String id, String displayName, String host, int port, String userName, String keyFileLocation, boolean usePassphrase, boolean connectOnStartUp, boolean autoRetry, SshConnectionListener listener) {
        this.config = keyFileLocation == null || keyFileLocation.isEmpty() ? SshSessionConfigurationFactory.createSshSessionConfigurationWithAuthPhrase((String)host, (int)port, (String)userName, null) : SshSessionConfigurationFactory.createSshSessionConfigurationWithKeyFileLocation((String)host, (int)port, (String)userName, (String)keyFileLocation);
        this.id = id;
        this.connectOnStartup = connectOnStartUp;
        this.autoRetry = autoRetry;
        this.listener = listener;
        this.displayName = displayName;
        this.usePassphrase = usePassphrase;
        listener.onCreated(this);
        this.consecutiveConnectionFailures = 0;
        this.waitingForRetry = false;
    }

    @Override
    public String getHost() {
        return this.config.getDestinationHost();
    }

    @Override
    public int getPort() {
        return this.config.getPort();
    }

    @Override
    public String getUsername() {
        return this.config.getSshAuthUser();
    }

    @Override
    public String getKeyfileLocation() {
        return this.config.getSshKeyFileLocation();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean isConnected() {
        if (this.session == null) {
            return false;
        }
        boolean result = this.session.isConnected();
        if (!result) {
            this.session = null;
            this.listener.onConnectionClosed(this, this.autoRetry);
            String retryMessage = "";
            if (this.autoRetry) {
                retryMessage = " Will try to auto-reconnect.";
            }
            this.log.warn((Object)StringUtils.format((String)"SSH session lost: host %s, port %s%s", (Object[])new Object[]{this.config.getDestinationHost(), this.config.getPort(), retryMessage}));
        }
        return result;
    }

    @Override
    public boolean isWaitingForRetry() {
        return this.waitingForRetry;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Session connect(String passphrase) {
        String reason;
        ThreadGuard.checkForForbiddenThread();
        if (this.config.getSshKeyFileLocation() == null && passphrase == null) {
            this.log.warn((Object)StringUtils.format((String)"Connecting SSH session failed because no key file and no passphrase is given: host %s, port %s.", (Object[])new Object[]{this.config.getDestinationHost(), this.config.getPort()}));
            String error = "No key file or passphrase could be found. Probable cause: This was an automatic reconnection attempt and the passphrase is not stored.";
            this.listener.onConnectionAttemptFailed(this, error, true, false);
            return null;
        }
        Logger logger = JschSessionFactory.createDelegateLogger((Log)LogFactory.getLog(this.getClass()));
        try {
            this.session = JschSessionFactory.setupSession((String)this.config.getDestinationHost(), (int)this.config.getPort(), (String)this.config.getSshAuthUser(), (String)this.config.getSshKeyFileLocation(), (String)passphrase, (Logger)logger);
            this.waitingForRetry = false;
            this.consecutiveConnectionFailures = 0;
        }
        catch (JSchException | SshParameterException e) {
            this.log.warn((Object)StringUtils.format((String)"Connecting SSH session failed: host %s, port %s: %s", (Object[])new Object[]{this.config.getDestinationHost(), this.config.getPort(), e.toString()}));
            String reason2 = e.getMessage();
            Throwable cause = e.getCause();
            boolean shouldTryToReconnect = this.autoRetry;
            if (cause != null && cause instanceof ConnectException) {
                reason2 = "The remote instance could not be reached. Probably the hostname or port is wrong.";
            } else if (cause != null && cause instanceof UnknownHostException) {
                reason2 = "No host with this name could be found.";
            } else if (reason2.equals("Auth fail")) {
                reason2 = "Authentication failed. Probably the username or passphrase is wrong, the wrong key file was used or the account is not enabled on the remote host.";
                shouldTryToReconnect = false;
            } else if (reason2.equals("USERAUTH fail")) {
                reason2 = "Authentication failed. The wrong passphrase for the key file " + this.config.getSshKeyFileLocation() + " was used.";
                shouldTryToReconnect = false;
            } else if (reason2.startsWith("invalid privatekey")) {
                reason2 = "Authentication failed. An invalid private key was used.";
                shouldTryToReconnect = false;
            }
            if (shouldTryToReconnect) {
                ++this.consecutiveConnectionFailures;
            }
            this.listener.onConnectionAttemptFailed(this, reason2, this.consecutiveConnectionFailures <= 1, shouldTryToReconnect);
            return null;
        }
        String remoteRCEVersion = null;
        String[] stringArray = this.session.getServerVersion().split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String versionToken = stringArray[n2];
            if (versionToken.startsWith("RemoteAccess/")) {
                remoteRCEVersion = versionToken.split("/")[1];
            }
            ++n2;
        }
        if (remoteRCEVersion == null) {
            this.log.warn((Object)StringUtils.format((String)"Connecting SSH session failed: Could not retreive version of RCE instance on host %s, port %s from server banner.", (Object[])new Object[]{this.config.getDestinationHost(), this.config.getPort()}));
            this.session.disconnect();
            this.session = null;
            reason = "The RCE version of the remote instance could not be retrieved. Possibly it is not an RCE instance.";
            this.listener.onConnectionAttemptFailed(this, reason, true, false);
            return null;
        }
        if (!remoteRCEVersion.contains("10.0.0")) {
            this.log.warn((Object)StringUtils.format((String)"Connecting SSH session failed: Either, the RCE instance on host %s, port %s has an incompatible version, or the user %s does not have the required permissions to run remote access tools and workflows. (Detected server version information: %s, required version: %s)", (Object[])new Object[]{this.config.getDestinationHost(), this.config.getPort(), this.config.getSshAuthUser(), remoteRCEVersion, "10.0.0"}));
            this.session.disconnect();
            this.session = null;
            reason = StringUtils.format((String)"Either, the remote RCE instance has an incompatible version, or the user %s does not have the required permissions to run remote access tools and workflows. \n\n(Detected server version information: %s, required version: %s)", (Object[])new Object[]{this.config.getSshAuthUser(), remoteRCEVersion, "10.0.0"});
            this.listener.onConnectionAttemptFailed(this, reason, true, false);
            return null;
        }
        this.listener.onConnected(this);
        return this.session;
    }

    @Override
    public void disconnect() {
        this.session.disconnect();
        this.listener.onConnectionClosed(this, false);
        this.session = null;
        this.consecutiveConnectionFailures = 0;
        this.waitingForRetry = false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean getConnectOnStartUp() {
        return this.connectOnStartup;
    }

    @Override
    public boolean getUsePassphrase() {
        return this.usePassphrase;
    }

    @Override
    public boolean getAutoRetry() {
        return this.autoRetry;
    }

    @Override
    public void setWaitingForRetry(boolean waitingForRetry) {
        this.waitingForRetry = waitingForRetry;
        if (!waitingForRetry) {
            this.consecutiveConnectionFailures = 0;
        }
    }
}

