/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.rpc;

import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.communication.common.SerializationException;
import de.rcenvironment.core.communication.model.NetworkResponse;
import de.rcenvironment.core.communication.rpc.ServiceCallRequest;
import de.rcenvironment.core.communication.rpc.ServiceCallResult;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ServiceCallResultFactory {
    private static final Log sharedLog = LogFactory.getLog(ServiceCallResultFactory.class);

    private ServiceCallResultFactory() {
    }

    public static ServiceCallResult representNetworkErrorAsRemoteOperationException(ServiceCallRequest serviceCallRequest, NetworkResponse networkResponse) {
        String resultCodeMessage = networkResponse.getResultCode().toString();
        String additionalErrorInformation = null;
        try {
            Serializable deserializedContent = networkResponse.getDeserializedContent();
            if (deserializedContent != null) {
                if (deserializedContent instanceof String) {
                    additionalErrorInformation = (String)((Object)deserializedContent);
                    additionalErrorInformation = ServiceCallResultFactory.parseEncodedErrorInformation(additionalErrorInformation);
                } else {
                    additionalErrorInformation = "Internal error: deserialized extended error information, but it is not a string: " + deserializedContent.toString();
                }
            }
        }
        catch (SerializationException e) {
            additionalErrorInformation = "Internal error: failed to deserialize the extended error message: " + e.getMessage();
        }
        String userMessage = additionalErrorInformation != null ? StringUtils.format((String)"%s: %s", (Object[])new Object[]{resultCodeMessage, additionalErrorInformation}) : resultCodeMessage;
        return new ServiceCallResult(null, null, null, userMessage);
    }

    private static String parseEncodedErrorInformation(String additionalErrorInformation) {
        String reportingNodeRepresentation;
        String[] parts = StringUtils.splitAndUnescape((String)additionalErrorInformation);
        if (parts.length != 2) {
            LogFactory.getLog(ServiceCallResultFactory.class).error((Object)("Received unexpected content in additional error information: " + additionalErrorInformation));
            return additionalErrorInformation;
        }
        String errorId = parts[0];
        String nodeIdString = parts[1];
        if (!StringUtils.isNullorEmpty((String)nodeIdString)) {
            try {
                reportingNodeRepresentation = NodeIdentifierUtils.parseInstanceNodeSessionIdString(nodeIdString).toString();
            }
            catch (IdentifierException e) {
                reportingNodeRepresentation = StringUtils.format((String)"[Failed to parse received node id '%s': %s]", (Object[])new Object[]{nodeIdString, e.toString()});
            }
        } else {
            reportingNodeRepresentation = null;
        }
        if (reportingNodeRepresentation != null) {
            if (StringUtils.isNullorEmpty((String)errorId)) {
                return StringUtils.format((String)"The error was reported by %s", (Object[])new Object[]{reportingNodeRepresentation});
            }
            return StringUtils.format((String)"The error was reported by %s; technical details were logged there as error '%s'", (Object[])new Object[]{reportingNodeRepresentation, errorId});
        }
        if (StringUtils.isNullorEmpty((String)errorId)) {
            return "No further information available";
        }
        return StringUtils.format((String)"Technical details were logged on the target instance as error '%s'", (Object[])new Object[]{errorId});
    }

    public static ServiceCallResult representInternalErrorAtSender(ServiceCallRequest serviceCallRequest, String errorMessage) {
        return ServiceCallResultFactory.representInternalErrorAtSender(serviceCallRequest, errorMessage, null);
    }

    public static ServiceCallResult representInternalErrorAtSender(ServiceCallRequest serviceCallRequest, String errorMessage, Throwable throwable) {
        boolean suppressStacktrace = false;
        String errorId = suppressStacktrace ? LogUtils.logErrorAndAssignUniqueMarker((Log)sharedLog, (String)StringUtils.format((String)"Local error at sender while performing service request to '%s#%s' on target node '%s': %s: %s", (Object[])new Object[]{serviceCallRequest.getServiceName(), serviceCallRequest.getMethodName(), serviceCallRequest.getTargetNodeId(), errorMessage, throwable.toString()})) : LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)sharedLog, (String)StringUtils.format((String)"Local error at sender while performing service request to '%s#%s' on target node '%s': %s", (Object[])new Object[]{serviceCallRequest.getServiceName(), serviceCallRequest.getMethodName(), serviceCallRequest.getTargetNodeId(), errorMessage}), (Throwable)throwable);
        String userMessage = StringUtils.format((String)"There was a local error while performing this operation; you can find more information by looking for the marker '%s' in your instance's log files", (Object[])new Object[]{errorId});
        return new ServiceCallResult(null, null, null, userMessage);
    }

    public static ServiceCallResult wrapReturnValue(Serializable returnValue) {
        return new ServiceCallResult(returnValue, null, null, null);
    }

    public static ServiceCallResult wrapMethodException(Exception methodException) {
        String methodExceptionType = methodException.getClass().getName();
        String methodExceptionMessage = methodException.getMessage();
        return new ServiceCallResult(null, methodExceptionType, methodExceptionMessage, null);
    }

    public static ServiceCallResult representInvalidRequestAtHandler(ServiceCallRequest serviceCallRequest, String internalInfo) {
        String errorId = LogUtils.logErrorAndAssignUniqueMarker((Log)sharedLog, (String)StringUtils.format((String)"Refused request for invalid method '%s#%s()' sent by '%s': %s", (Object[])new Object[]{serviceCallRequest.getServiceName(), serviceCallRequest.getMethodName(), serviceCallRequest.getCallerNodeId(), internalInfo}));
        String userMessage = StringUtils.format((String)"Request refused by destination instance (remote error id: %s)", (Object[])new Object[]{errorId});
        return new ServiceCallResult(null, null, null, userMessage);
    }

    public static ServiceCallResult representInternalErrorAtHandler(ServiceCallRequest serviceCallRequest, String errorMessage) {
        return ServiceCallResultFactory.representInternalErrorAtHandler(serviceCallRequest, errorMessage, null);
    }

    public static ServiceCallResult representInternalErrorAtHandler(ServiceCallRequest serviceCallRequest, String errorMessage, Throwable throwable) {
        String errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)sharedLog, (String)StringUtils.format((String)"Error while handling service request to '%s#%s' from '%s': %s", (Object[])new Object[]{serviceCallRequest.getServiceName(), serviceCallRequest.getMethodName(), serviceCallRequest.getCallerNodeId(), errorMessage}), (Throwable)throwable);
        String userMessage = StringUtils.format((String)"There was an error performing this remote operation; if you have access to the log files of %s, you can find more information by looking for the marker '%s' in its log files", (Object[])new Object[]{serviceCallRequest.getTargetNodeId(), errorId});
        return new ServiceCallResult(null, null, null, userMessage);
    }
}

