/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.routing.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.NetworkGraph;
import de.rcenvironment.core.communication.model.InitialNodeInformation;
import de.rcenvironment.core.communication.model.impl.InitialNodeInformationImpl;
import de.rcenvironment.core.communication.model.internal.NetworkGraphImpl;
import de.rcenvironment.core.communication.model.internal.NetworkGraphLinkImpl;
import de.rcenvironment.core.communication.routing.internal.LinkStateAdvertisement;
import de.rcenvironment.core.communication.routing.internal.LinkStateAdvertisementBatch;
import de.rcenvironment.core.communication.routing.internal.NetworkRoute;
import de.rcenvironment.core.communication.routing.internal.TopologyLink;
import de.rcenvironment.core.communication.routing.internal.TopologyNode;
import de.rcenvironment.core.utils.common.StringUtils;
import edu.uci.ics.jung.algorithms.shortestpath.DijkstraShortestPath;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TopologyMap {
    private static final Log LOGGER = LogFactory.getLog(TopologyMap.class);
    private final DirectedSparseMultigraph<TopologyNode, TopologyLink> networkModel = new DirectedSparseMultigraph();
    private final InitialNodeInformation localNodeInformation;
    private final InstanceNodeSessionId localNodeId;

    public TopologyMap(InitialNodeInformation ownNodeInformation) {
        this.localNodeInformation = ownNodeInformation;
        this.localNodeId = ownNodeInformation.getInstanceNodeSessionId();
        TopologyNode localNode = this.addNode(this.localNodeId);
        localNode.invalidateSequenceNumber();
    }

    protected TopologyMap(InstanceNodeSessionId nodeId) {
        this(new InitialNodeInformationImpl(nodeId));
    }

    public static Collection<InstanceNodeSessionId> toNodeIdentifiers(Collection<TopologyNode> networkNodes) {
        ArrayList<InstanceNodeSessionId> result = new ArrayList<InstanceNodeSessionId>();
        for (TopologyNode networkNode : networkNodes) {
            result.add(networkNode.getNodeIdentifier());
        }
        return result;
    }

    public synchronized boolean update(LinkStateAdvertisement lsa) {
        InstanceNodeSessionId lsaOwner = lsa.getOwner();
        if (lsaOwner.equals(this.localNodeId)) {
            this.getNode(this.localNodeId);
            return false;
        }
        boolean lsaRootPresent = this.containsNode(lsaOwner);
        TopologyNode lsaRoot = this.getNode(lsaOwner);
        if (lsaRootPresent && lsaRoot.getSequenceNumber() >= lsa.getSequenceNumber() || !lsaRootPresent && "shutdown".equals(lsa.getReason())) {
            return false;
        }
        if (lsaRootPresent) {
            for (TopologyNode successor : this.networkModel.getSuccessors((Object)lsaRoot)) {
                for (TopologyLink link : this.networkModel.findEdgeSet((Object)lsaRoot, (Object)successor)) {
                    this.removeLink(link);
                }
            }
        }
        if ("startup".equals(lsa.getReason()) || "update".equals(lsa.getReason())) {
            TopologyNode node = this.addNode(lsaOwner);
            node.setRouting(lsa.isRouting());
            node.setLastSequenceNumber(lsa.getSequenceNumber());
            node.setLastGraphHashCode(lsa.getGraphHashCode());
            node.setDisplayName(lsa.getDisplayName());
            node.setIsWorkflowHost(false);
            for (TopologyLink link : lsa.getLinks()) {
                if (!this.containsNode(link.getDestination())) {
                    this.addNode(link.getDestination());
                }
                this.addLink(link);
            }
        }
        if ("shutdown".equals(lsa.getReason())) {
            LOGGER.debug((Object)("Received a shutdown notice for node " + lsaRoot.getNodeIdentifier() + "; removing it from local topology"));
            this.removeNode(lsaRoot);
        }
        return true;
    }

    public synchronized NetworkRoute getShortestPath(InstanceNodeSessionId source, InstanceNodeSessionId destination) {
        long elapsed = 0L;
        List<TopologyLink> path = new ArrayList();
        ArrayList<InstanceNodeSessionId> nodes = new ArrayList<InstanceNodeSessionId>();
        TopologyNode sourceNode = this.getNode(source);
        if (sourceNode == null) {
            throw new IllegalStateException("Consistency error: The local node is not part of the known topology");
        }
        TopologyNode destinationNode = this.getNode(destination);
        if (destinationNode != null) {
            DijkstraShortestPath alg = new DijkstraShortestPath(this.networkModel);
            long start = System.nanoTime();
            path = alg.getPath((Object)sourceNode, (Object)destinationNode);
            elapsed = System.nanoTime() - start;
            for (TopologyLink link : path) {
                nodes.add(((TopologyNode)this.networkModel.getEndpoints((Object)link).getSecond()).getNodeIdentifier());
            }
            return new NetworkRoute(source, destination, path, nodes, elapsed);
        }
        LOGGER.warn((Object)("Could not determine route to node " + destination + " as it is not part of the known topology"));
        return null;
    }

    public synchronized Set<InstanceNodeSessionId> getIdsOfReachableNodes(boolean restrictToWorkflowHostsAndSelf) {
        HashSet<InstanceNodeSessionId> result = new HashSet<InstanceNodeSessionId>();
        DijkstraShortestPath alg = new DijkstraShortestPath(this.networkModel);
        Map distanceMap = alg.getDistanceMap((Object)this.getNode(this.localNodeId));
        for (TopologyNode node : distanceMap.keySet()) {
            boolean isLocalNode;
            if (restrictToWorkflowHostsAndSelf && !(isLocalNode = this.localNodeId.equals(node.getNodeIdentifier())) && !node.getIsWorkflowHost()) continue;
            result.add(node.getNodeIdentifier());
        }
        return result;
    }

    public synchronized LinkStateAdvertisement generateNewLocalLSA() {
        return this.generateLsa(this.getLocalNodeId(), true);
    }

    public synchronized LinkStateAdvertisementBatch generateLsaBatchOfAllNodes() {
        LinkStateAdvertisementBatch lsaCache = new LinkStateAdvertisementBatch();
        for (TopologyNode node : this.networkModel.getVertices()) {
            lsaCache.put(node.getNodeIdentifier(), this.generateLsa(node.getNodeIdentifier(), false));
        }
        return lsaCache;
    }

    private synchronized LinkStateAdvertisement generateLsa(InstanceNodeSessionId root, boolean incSequenceNumber) {
        TopologyNode rootNode = this.getNode(root);
        rootNode.setLastGraphHashCode(this.hashCode());
        long sequenceNumber = incSequenceNumber ? rootNode.invalidateSequenceNumber() : rootNode.getSequenceNumber();
        return LinkStateAdvertisement.createUpdateLsa(root, rootNode.getDisplayName(), rootNode.getIsWorkflowHost(), sequenceNumber, this.hashCode(), rootNode.isRouting(), this.networkModel.getOutEdges((Object)rootNode));
    }

    public synchronized LinkStateAdvertisement generateShutdownLSA() {
        TopologyNode myself = this.getNode(this.getLocalNodeId());
        myself.setLastGraphHashCode(this.hashCode());
        return LinkStateAdvertisement.createShutDownLsa(this.getLocalNodeId(), this.localNodeInformation.getDisplayName(), false, myself.invalidateSequenceNumber());
    }

    public synchronized LinkStateAdvertisement generateStartupLSA() {
        TopologyNode myself = this.getNode(this.getLocalNodeId());
        myself.setLastGraphHashCode(this.hashCode());
        return LinkStateAdvertisement.createStartUpLsa(this.getLocalNodeId(), this.localNodeInformation.getDisplayName(), false, myself.invalidateSequenceNumber(), myself.isRouting(), this.networkModel.getOutEdges((Object)myself));
    }

    public synchronized boolean hasSameTopologyHashesForAllNodes() {
        for (TopologyNode node : this.getNodes()) {
            if (node.getLastGraphHashCode() == this.hashCode()) continue;
            return false;
        }
        return true;
    }

    public synchronized Collection<TopologyLink> getAllLinksBetween(TopologyNode source, TopologyNode destination) {
        if (source != null && destination != null) {
            return this.networkModel.findEdgeSet((Object)source, (Object)destination);
        }
        return new ArrayList<TopologyLink>();
    }

    public synchronized boolean equals(Object object) {
        if (object instanceof TopologyMap) {
            return this.hashCode() == object.hashCode();
        }
        return false;
    }

    public synchronized int hashCode() {
        String graphSerialization = "NetworkGraph:";
        ArrayList networkNodes = new ArrayList(this.networkModel.getVertices());
        Collections.sort(networkNodes);
        for (TopologyNode networkNode : networkNodes) {
            graphSerialization = String.valueOf(graphSerialization) + networkNode.hashCode();
        }
        ArrayList networkLinks = new ArrayList(this.networkModel.getEdges());
        Collections.sort(networkLinks);
        for (TopologyLink networkLink : networkLinks) {
            graphSerialization = String.valueOf(graphSerialization) + networkLink.hashCode();
        }
        return graphSerialization.hashCode();
    }

    public synchronized TopologyNode getNode(InstanceNodeSessionId nodeId) {
        for (TopologyNode networkNode : this.networkModel.getVertices()) {
            if (!networkNode.getNodeIdentifier().equals(nodeId)) continue;
            return networkNode;
        }
        return null;
    }

    public long getSequenceNumberOfNode(InstanceNodeSessionId id) {
        TopologyNode node = this.getNode(id);
        if (node == null) {
            throw new IllegalArgumentException("No such node: " + id.getInstanceNodeSessionIdString());
        }
        return node.getSequenceNumber();
    }

    public synchronized boolean containsNode(InstanceNodeSessionId nodeId) {
        return this.containsNode(new TopologyNode(nodeId));
    }

    public synchronized boolean containsNode(TopologyNode networkNode) {
        return this.networkModel.containsVertex((Object)networkNode);
    }

    public synchronized boolean containsLinkBetween(InstanceNodeSessionId source, InstanceNodeSessionId destination) {
        TopologyNode sourceNode = this.getNode(source);
        TopologyNode destinationNode = this.getNode(destination);
        if (sourceNode != null && destinationNode != null) {
            return this.networkModel.getSuccessors((Object)sourceNode).contains(destinationNode);
        }
        return false;
    }

    public synchronized boolean containsLink(InstanceNodeSessionId source, InstanceNodeSessionId destination, String connectionId) {
        return this.networkModel.containsEdge((Object)new TopologyLink(source, destination, connectionId));
    }

    public synchronized boolean containsLink(TopologyLink networkLink) {
        return this.networkModel.containsEdge((Object)networkLink);
    }

    public synchronized TopologyLink addLink(InstanceNodeSessionId source, InstanceNodeSessionId destination, String connectionId) {
        TopologyLink newLink = new TopologyLink(source, destination, connectionId);
        if (!this.addLink(newLink)) {
            throw new IllegalStateException("Failed to add new topology link");
        }
        return newLink;
    }

    public synchronized boolean addLink(TopologyLink networkLink) {
        if (networkLink.getConnectionId() == null) {
            throw new NullPointerException("Connection id must not be null");
        }
        TopologyNode sourceNode = this.getNode(networkLink.getSource());
        TopologyNode destinationNode = this.getNode(networkLink.getDestination());
        if (sourceNode == null) {
            sourceNode = this.addNode(networkLink.getSource());
        }
        if (destinationNode == null) {
            destinationNode = this.addNode(networkLink.getDestination());
        }
        if (!this.networkModel.addEdge((Object)networkLink, (Object)sourceNode, (Object)destinationNode)) {
            LOGGER.warn((Object)StringUtils.format((String)"Link edge %s was not added to graph -- duplicate?", (Object[])new Object[]{networkLink}));
            return false;
        }
        return true;
    }

    public synchronized boolean removeLink(InstanceNodeSessionId source, InstanceNodeSessionId destination, String connectionId) {
        return this.removeLink(new TopologyLink(source, destination, connectionId));
    }

    public synchronized boolean removeLink(TopologyLink link) {
        if (this.containsLink(link)) {
            return this.networkModel.removeEdge((Object)link);
        }
        LOGGER.warn((Object)("Edge removal requested for non-existant link: " + link));
        return false;
    }

    public synchronized void removeNode(TopologyNode node) {
        this.networkModel.removeVertex((Object)node);
    }

    public synchronized void removeNode(InstanceNodeSessionId node) {
        this.removeNode(new TopologyNode(node));
    }

    public synchronized TopologyNode addNode(InstanceNodeSessionId nodeId) {
        TopologyNode existingNetworkNode = this.getNode(nodeId);
        if (existingNetworkNode == null) {
            TopologyNode node = new TopologyNode(nodeId);
            this.networkModel.addVertex((Object)node);
            return node;
        }
        return existingNetworkNode;
    }

    public synchronized int getNodeCount() {
        return this.networkModel.getVertexCount();
    }

    public synchronized int getLinkCount() {
        return this.networkModel.getEdgeCount();
    }

    public synchronized Collection<TopologyLink> getAllLinks() {
        return this.networkModel.getEdges();
    }

    public synchronized TopologyLink getLinkForConnection(String channelId) {
        for (TopologyLink link : this.networkModel.getOutEdges((Object)this.getNode(this.getLocalNodeId()))) {
            if (!link.getConnectionId().equals(channelId)) continue;
            return link;
        }
        return null;
    }

    public synchronized boolean hasLinkForConnection(String connectionId) {
        return this.getLinkForConnection(connectionId) != null;
    }

    public synchronized Collection<TopologyNode> getNodes() {
        return this.networkModel.getVertices();
    }

    public synchronized Collection<TopologyNode> getSuccessors(TopologyNode networkNode) {
        return this.networkModel.getSuccessors((Object)networkNode);
    }

    public synchronized Collection<TopologyNode> getSuccessors() {
        return this.getSuccessors(this.getLocalNodeId());
    }

    public synchronized Collection<TopologyNode> getSuccessors(InstanceNodeSessionId nodeId) {
        return this.getSuccessors(this.getNode(nodeId));
    }

    public synchronized Collection<TopologyLink> getAllOutgoingLinks(InstanceNodeSessionId nodeId) {
        return this.getOutgoingLinks(this.getNode(nodeId));
    }

    public Collection<TopologyLink> getOutgoingLinks(TopologyNode node) {
        return this.networkModel.getOutEdges((Object)node);
    }

    public synchronized Collection<TopologyNode> getPredecessors(TopologyNode networkNode) {
        return this.networkModel.getPredecessors((Object)networkNode);
    }

    public InitialNodeInformation getLocalNodeInformation() {
        return this.localNodeInformation;
    }

    public synchronized InstanceNodeSessionId getLocalNodeId() {
        return this.localNodeId;
    }

    public synchronized NetworkGraph toRawNetworkGraph() {
        NetworkGraphImpl rawGraph = new NetworkGraphImpl(this.localNodeId);
        for (TopologyNode node : this.getNodes()) {
            InstanceNodeSessionId nodeId = node.getNodeIdentifier();
            rawGraph.addNode(nodeId);
        }
        for (TopologyLink link : this.getAllLinks()) {
            NetworkGraphLinkImpl graphLink = new NetworkGraphLinkImpl(link.getConnectionId(), link.getSource(), link.getDestination());
            rawGraph.addLink(graphLink);
        }
        return rawGraph;
    }
}

