/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.model.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.NetworkGraphLink;
import de.rcenvironment.core.communication.common.NetworkGraphNode;
import de.rcenvironment.core.communication.model.NetworkRoutingInformation;
import de.rcenvironment.core.communication.model.internal.NetworkGraphImpl;
import de.rcenvironment.core.communication.model.internal.NetworkGraphLinkImpl;
import de.rcenvironment.core.communication.routing.internal.NetworkFormatter;
import de.rcenvironment.core.communication.routing.internal.v2.NoRouteToNodeException;
import de.rcenvironment.core.toolkitbridge.transitional.StatsCounter;
import de.rcenvironment.toolkit.utils.common.AutoCreationMap;
import edu.uci.ics.jung.algorithms.shortestpath.DijkstraShortestPath;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class NetworkRoutingInformationImpl
implements NetworkRoutingInformation {
    private Map<InstanceNodeSessionId, NetworkGraphLink> routingTable;
    private Map<InstanceNodeSessionId, NetworkGraphLink> incomingEdgesById;
    private Set<NetworkGraphLink> spanningTreeLinkSet;
    private Map<InstanceNodeSessionId, List<NetworkGraphLink>> spanningTreeLinkMap;
    private int routingCacheMisses = 0;
    private final InstanceNodeSessionId localNodeId;
    private final Map<InstanceNodeSessionId, NetworkGraphLinkImpl> incomingEdgeMap;
    private final DijkstraShortestPath<InstanceNodeSessionId, NetworkGraphLinkImpl> shortestPathAlgorithm;
    private final Set<InstanceNodeSessionId> reachableNodes;

    public NetworkRoutingInformationImpl(NetworkGraphImpl rawNetworkGraph) {
        DirectedSparseMultigraph<InstanceNodeSessionId, NetworkGraphLinkImpl> rawJungGraph = rawNetworkGraph.getJungGraph();
        this.localNodeId = rawNetworkGraph.getLocalNodeId();
        this.shortestPathAlgorithm = new DijkstraShortestPath(rawJungGraph);
        try {
            this.incomingEdgeMap = this.shortestPathAlgorithm.getIncomingEdgeMap((Object)rawNetworkGraph.getLocalNodeId());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(NetworkFormatter.networkGraphToGraphviz(rawNetworkGraph, false), e);
        }
        this.reachableNodes = Collections.unmodifiableSet(this.incomingEdgeMap.keySet());
    }

    @Override
    public Set<InstanceNodeSessionId> getReachableNodes() {
        return this.reachableNodes;
    }

    @Override
    public synchronized NetworkGraphLink getNextLinkTowards(InstanceNodeSessionId targetNodeId) throws NoRouteToNodeException {
        StatsCounter.count((String)"Network topology/routing", (String)"Route requests");
        if (targetNodeId.equals(this.localNodeId)) {
            throw new NoRouteToNodeException("Cannot route to Local node", this.localNodeId);
        }
        if (this.routingTable == null) {
            StatsCounter.count((String)"Network topology/routing", (String)"Routing table calculations");
            this.routingTable = new HashMap<InstanceNodeSessionId, NetworkGraphLink>();
            this.incomingEdgesById = new HashMap<InstanceNodeSessionId, NetworkGraphLink>();
            for (NetworkGraphLinkImpl link : this.incomingEdgeMap.values()) {
                if (link == null) continue;
                this.incomingEdgesById.put(link.getTargetNodeId(), link);
            }
        }
        return this.determineRoutingTableEntryFor(targetNodeId);
    }

    @Override
    public synchronized List<? extends NetworkGraphLink> getRouteTo(InstanceNodeSessionId destination) {
        if (destination.equals(this.localNodeId)) {
            throw new IllegalArgumentException("Invalid route request to local node");
        }
        List path = this.shortestPathAlgorithm.getPath((Object)this.localNodeId, (Object)destination);
        if (path.size() != 0) {
            return Collections.unmodifiableList(path);
        }
        return null;
    }

    @Override
    public NetworkGraphLink getNextLinkTowards(NetworkGraphNode targetNode) throws NoRouteToNodeException {
        return this.getNextLinkTowards(targetNode.getNodeId());
    }

    @Override
    public synchronized Set<NetworkGraphLink> getSpanningTreeLinks() {
        if (this.spanningTreeLinkSet == null) {
            this.spanningTreeLinkSet = new HashSet<NetworkGraphLink>();
            for (NetworkGraphLinkImpl link : this.incomingEdgeMap.values()) {
                if (link == null) continue;
                this.spanningTreeLinkSet.add(link);
            }
            this.spanningTreeLinkSet = Collections.unmodifiableSet(this.spanningTreeLinkSet);
        }
        return this.spanningTreeLinkSet;
    }

    @Override
    public synchronized Map<InstanceNodeSessionId, List<NetworkGraphLink>> getSpanningTreeLinkMap() {
        if (this.spanningTreeLinkMap == null) {
            this.spanningTreeLinkMap = this.createSpanningTree();
        }
        return this.spanningTreeLinkMap;
    }

    protected int getRoutingCacheMisses() {
        return this.routingCacheMisses;
    }

    protected void resetCacheMisses() {
        this.routingCacheMisses = 0;
    }

    private NetworkGraphLink determineRoutingTableEntryFor(InstanceNodeSessionId targetNodeId) throws NoRouteToNodeException {
        NetworkGraphLink result = this.routingTable.get(targetNodeId);
        if (result != null) {
            return result;
        }
        ++this.routingCacheMisses;
        NetworkGraphLink incomingEdge = this.incomingEdgesById.get(targetNodeId);
        if (incomingEdge == null) {
            throw new NoRouteToNodeException("No incoming edge for " + targetNodeId, targetNodeId);
        }
        InstanceNodeSessionId predecessorNodeId = incomingEdge.getSourceNodeId();
        result = predecessorNodeId.equals(this.localNodeId) ? incomingEdge : this.determineRoutingTableEntryFor(predecessorNodeId);
        this.routingTable.put(targetNodeId, result);
        return result;
    }

    private Map<InstanceNodeSessionId, List<NetworkGraphLink>> createSpanningTree() {
        AutoCreationMap<InstanceNodeSessionId, List<NetworkGraphLink>> spanningTreeLinks = new AutoCreationMap<InstanceNodeSessionId, List<NetworkGraphLink>>(){

            protected List<NetworkGraphLink> createNewEntry(InstanceNodeSessionId key) {
                return new ArrayList<NetworkGraphLink>();
            }
        };
        for (NetworkGraphLinkImpl link : this.incomingEdgeMap.values()) {
            if (link == null) continue;
            ((List)spanningTreeLinks.get((Object)link.getSourceNodeId())).add(link);
        }
        Map temp = spanningTreeLinks.getImmutableShallowCopy();
        return temp;
    }
}

