/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.management.internal;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.channel.MessageChannelService;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.management.BenchmarkService;
import de.rcenvironment.core.communication.management.BenchmarkSetup;
import de.rcenvironment.core.communication.nodeproperties.NodePropertiesService;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.incubator.GraphvizUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetCommandPlugin
implements CommandPlugin {
    private static final String CMD_NET = "net";
    private CommunicationService communicationService;
    private BenchmarkService benchmarkService;
    private NodePropertiesService nodePropertiesService;
    private MessageChannelService messageChannelService;
    private final Log log = LogFactory.getLog(this.getClass());
    private File outputDir;

    public Collection<CommandDescription> getCommandDescriptions() {
        ArrayList<CommandDescription> contributions = new ArrayList<CommandDescription>();
        contributions.add(new CommandDescription(CMD_NET, "", false, "short version of \"net info\"", new String[0]));
        contributions.add(new CommandDescription("net info", "", false, "show a list of reachable RCE nodes", new String[0]));
        contributions.add(new CommandDescription("net graph", "[<base name>]", true, "generates a Graphviz file of the current network topology", new String[0]));
        contributions.add(new CommandDescription("net filter", "", false, "show IP filter status", new String[0]));
        contributions.add(new CommandDescription("net filter reload", "", false, "reloads the IP filter configuration", new String[0]));
        contributions.add(new CommandDescription("net graph -a", "[<base name>]", true, "like \"net graph\", but include unreachable nodes", new String[0]));
        contributions.add(new CommandDescription("net bench", "<taskdef>[;<taskDef>]*", true, "run communication benchmark", new String[]{"<taskDef> = <targetNode|*>([<numMessages>],[<requestSize>],[<responseSize>],", "                           [<responseDelay(msec)>],[<threadsPerTarget>])"}));
        contributions.add(new CommandDescription("net np", "", true, "show known RCE node properties", new String[0]));
        return contributions;
    }

    public void execute(CommandContext context) throws CommandException {
        context.consumeExpectedToken(CMD_NET);
        String subCmd = context.consumeNextToken();
        if (subCmd == null) {
            this.performNetInfo(context);
        } else {
            if ("add".equals(subCmd)) {
                context.println((Object)"Obsolete command; use \"cn add\" instead");
                return;
            }
            if ("bench".equals(subCmd)) {
                this.performNetBench(context);
            } else if ("filter".equals(subCmd)) {
                this.performNetFilter(context);
            } else if ("graph".equals(subCmd)) {
                this.performNetGraph(context);
            } else if ("info".equals(subCmd)) {
                this.performNetInfo(context);
            } else if ("np".equals(subCmd)) {
                this.performNetNp(context);
            } else {
                throw CommandException.unknownCommand((CommandContext)context);
            }
        }
    }

    public void bindCommunicationService(CommunicationService newInstance) {
        this.communicationService = newInstance;
    }

    public void bindBenchmarkService(BenchmarkService newInstance) {
        this.benchmarkService = newInstance;
    }

    public void bindNodePropertiesService(NodePropertiesService newInstance) {
        this.nodePropertiesService = newInstance;
    }

    public void bindConfigurationService(ConfigurationService newInstance) {
        this.outputDir = newInstance.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_OUTPUT);
    }

    public void bindMessageChannelService(MessageChannelService newInstance) {
        this.messageChannelService = newInstance;
    }

    private void performNetGraph(CommandContext context) throws CommandException {
        List parameters;
        if (this.outputDir == null || !this.outputDir.isDirectory()) {
            throw new IllegalStateException("Invalid output dir: " + this.outputDir);
        }
        String formatName = "graphviz";
        if (context.consumeNextTokenIfEquals("-a")) {
            formatName = "graphviz-all";
            context.setDeveloperCommandSetEnabled(true);
        }
        if ((parameters = context.consumeRemainingTokens()).size() > 1) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        String baseName = "rce_network";
        if (parameters.size() == 1) {
            baseName = (String)parameters.get(0);
        }
        String graphvizData = this.communicationService.getFormattedNetworkInformation(formatName);
        File gvFile = new File(this.outputDir, String.valueOf(baseName) + ".gv");
        File pngFile = new File(this.outputDir, String.valueOf(baseName) + ".png");
        try {
            FileUtils.writeStringToFile((File)gvFile, (String)graphvizData);
            context.println((Object)("Graphviz file written to " + gvFile.getAbsolutePath()));
        }
        catch (IOException e) {
            this.log.error((Object)("Error writing script file " + gvFile.getAbsolutePath()), (Throwable)e);
            return;
        }
        if (GraphvizUtils.renderDotFileToPng((File)gvFile, (File)pngFile, (TextOutputReceiver)context.getOutputReceiver())) {
            context.println((Object)("PNG file written to " + pngFile.getAbsolutePath()));
        } else {
            context.println((Object)("Error running graphviz - PNG file " + pngFile.getAbsolutePath() + " was probably not generated"));
        }
    }

    private void performNetInfo(CommandContext context) {
        context.println((Object)this.communicationService.getFormattedNetworkInformation("info"));
    }

    private void performNetBench(CommandContext context) throws CommandException {
        BenchmarkSetup setup;
        context.setDeveloperCommandSetEnabled(true);
        List parameters = context.consumeRemainingTokens();
        if (parameters.size() != 1) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        try {
            String benchmarkDescription = (String)parameters.get(0);
            setup = this.benchmarkService.parseBenchmarkDescription(benchmarkDescription);
        }
        catch (IllegalArgumentException e) {
            throw CommandException.syntaxError((String)("Error parsing benchmark setup: " + e.toString()), (CommandContext)context);
        }
        context.println((Object)"Benchmark starting");
        this.benchmarkService.executeBenchmark(setup, context.getOutputReceiver());
        context.println((Object)"Benchmark complete");
    }

    private void performNetFilter(CommandContext context) throws CommandException {
        String nextToken = context.consumeNextToken();
        if (nextToken == null) {
            this.messageChannelService.printIPFilterInformation(context.getOutputReceiver());
        } else if ("reload".equals(nextToken)) {
            this.messageChannelService.loadAndApplyIPFilterConfiguration();
            this.messageChannelService.printIPFilterInformation(context.getOutputReceiver());
        } else {
            throw CommandException.unknownCommand((CommandContext)context);
        }
    }

    private void performNetNp(CommandContext context) {
        Set<InstanceNodeSessionId> nodes = this.communicationService.getReachableInstanceNodes();
        Map<InstanceNodeSessionId, Map<String, String>> allMetadata = this.nodePropertiesService.getAllNodeProperties(nodes);
        context.println((Object)"Known node properties:");
        for (Map.Entry<InstanceNodeSessionId, Map<String, String>> entry1 : allMetadata.entrySet()) {
            InstanceNodeSessionId nodeId = entry1.getKey();
            context.println((Object)nodeId.toString());
            Map<String, String> map = entry1.getValue();
            for (Map.Entry<String, String> entry2 : map.entrySet()) {
                context.println((Object)StringUtils.format((String)"  %s = %s", (Object[])new Object[]{entry2.getKey(), entry2.getValue()}));
            }
        }
    }
}

