/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.common.internal;

import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.communication.uplink.network.api.AsyncMessageBlockSender;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.utils.common.SizeValidatedDataSource;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class DataStreamUploadWrapper {
    private final AsyncMessageBlockSender messageBlockSender;

    public DataStreamUploadWrapper(AsyncMessageBlockSender messageBlockSender) {
        this.messageBlockSender = messageBlockSender;
    }

    public void uploadFromDataSource(long channelId, MessageType messageType, SizeValidatedDataSource dataSource) throws IOException {
        while (!dataSource.receivedCompletely()) {
            MessageBlock nextChunk = this.encodeNextDataBlock(messageType, dataSource);
            this.messageBlockSender.enqueueMessageBlockForSending(channelId, nextChunk);
        }
    }

    private MessageBlock encodeNextDataBlock(MessageType messageType, SizeValidatedDataSource dataSource) throws IOException {
        int bufferSize = (int)Math.min(dataSource.getRemaining(), 262144L);
        if (bufferSize < 1) {
            throw new ProtocolException("Attempted to create a message block from an already-finished data stream");
        }
        byte[] buffer = new byte[bufferSize];
        IOUtils.readFully((InputStream)dataSource.getStream(), (byte[])buffer);
        return new MessageBlock(messageType.getCode(), buffer);
    }
}

