/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.search.actions;

import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.wst.xsd.ui.internal.search.SearchMessages;
import org.eclipse.wst.xsd.ui.internal.search.actions.FindAction;
import org.eclipse.wst.xsd.ui.internal.search.actions.FindReferencesAction;
import org.eclipse.wst.xsd.ui.internal.search.actions.FindReferencesInProjectAction;
import org.eclipse.wst.xsd.ui.internal.search.actions.FindReferencesInWorkingSetAction;
import org.eclipse.wst.xsd.ui.internal.search.actions.SearchGroup;

public class ReferencesSearchGroup
extends SearchGroup {
    protected static final String MENU_TEXT = SearchMessages.group_references;
    protected IEditorPart fEditor;
    private IWorkbenchSite fSite;
    private IActionBars fActionBars;
    protected FindAction fFindReferencesAction;
    protected FindAction fFindReferencesInProjectAction;
    protected FindAction fFindReferencesInWorkingSetAction;

    public ReferencesSearchGroup(IEditorPart editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.initialize();
    }

    protected void initialize() {
        this.fFindReferencesAction = new FindReferencesAction(this.fEditor);
        this.fFindReferencesAction.setText(SearchMessages.Search_FindDeclarationAction_label);
        this.fFindReferencesAction.setActionDefinitionId("SEARCH_REFERENCES_IN_WORKSPACE");
        this.fFindReferencesInProjectAction = new FindReferencesInProjectAction(this.fEditor);
        this.fFindReferencesInProjectAction.setText(SearchMessages.Search_FindDeclarationsInProjectAction_label);
        this.fFindReferencesInProjectAction.setActionDefinitionId("SEARCH_REFERENCES_IN_PROJECT");
        this.fFindReferencesInWorkingSetAction = new FindReferencesInWorkingSetAction(this.fEditor);
        this.fFindReferencesInWorkingSetAction.setText(SearchMessages.Search_FindDeclarationsInWorkingSetAction_label);
        this.fFindReferencesInWorkingSetAction.setActionDefinitionId(".SEARCH_REFERENCES_IN_WORKING_SET");
    }

    protected String getName() {
        return MENU_TEXT;
    }

    public void fillActions(List list) {
        list.add(this.fFindReferencesAction);
        list.add(this.fFindReferencesInProjectAction);
        list.add(new Separator());
        list.add(this.fFindReferencesInWorkingSetAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        Assert.isNotNull((Object)actionBars);
        super.fillActionBars(actionBars);
        this.fActionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    public void fillContextMenu(IMenuManager manager) {
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        if (provider != null) {
            this.disposeAction(this.fFindReferencesAction, provider);
            this.disposeAction(this.fFindReferencesInProjectAction, provider);
            this.disposeAction(this.fFindReferencesInWorkingSetAction, provider);
        }
        this.fFindReferencesAction = null;
        this.fFindReferencesInProjectAction = null;
        this.fFindReferencesInWorkingSetAction = null;
        this.updateGlobalActionHandlers();
        super.dispose();
    }

    private void updateGlobalActionHandlers() {
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }
}

