/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands;

import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowLabel;
import de.rcenvironment.core.gui.workflow.editor.handlers.AbstractWorkflowPartSendHandler;
import de.rcenvironment.core.gui.workflow.parts.WorkflowLabelPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.commands.Command;

public class WorkflowLabelSendLayerwiseCommand
extends Command {
    private static final int MINUS_ONE = -1;
    private final WorkflowDescription workflowDescription;
    private final List<WorkflowLabel> selectedLabels;
    private final AbstractWorkflowPartSendHandler.SendType sendType;
    private Map<WorkflowLabel, Integer> previousState = new HashMap<WorkflowLabel, Integer>();

    public WorkflowLabelSendLayerwiseCommand(WorkflowDescription workflowDescription, List<WorkflowLabelPart> cleanSelectedLabelParts, AbstractWorkflowPartSendHandler.SendType sendType) {
        this.workflowDescription = workflowDescription;
        this.selectedLabels = new ArrayList<WorkflowLabel>();
        for (WorkflowLabelPart part : cleanSelectedLabelParts) {
            this.selectedLabels.add((WorkflowLabel)part.getModel());
        }
        this.sendType = sendType;
    }

    public void execute() {
        this.savePreviousState();
        this.redo();
    }

    public void redo() {
        this.orderSelectedLabels();
        int[] zIndexList = this.getzIndexList(this.workflowDescription.getWorkflowLabels().size());
        switch (this.sendType) {
            case SEND_BACK: {
                this.sendSelectedArrayIndicesOneLayerBack(zIndexList);
                break;
            }
            case SEND_FORWARD: {
                this.sendSelectedArrayIndicesOneLayerForward(zIndexList);
                break;
            }
            case SEND_TO_BACKGROUND: {
                this.sendSelectedArrayIndicesToBackground(zIndexList);
                break;
            }
            case SEND_TO_FOREGROUND: {
                this.sendSelectedArrayIndicesToForeground(zIndexList);
            }
        }
        this.setNewzIndicesFromIndexList(zIndexList);
        this.workflowDescription.firePropertyChange("e.rcenvironment.wf.l");
    }

    public void undo() {
        for (WorkflowLabel label : this.workflowDescription.getWorkflowLabels()) {
            label.setZIndex(this.previousState.get(label).intValue());
        }
        this.workflowDescription.firePropertyChange("e.rcenvironment.wf.l");
    }

    private void savePreviousState() {
        for (WorkflowLabel label : this.workflowDescription.getWorkflowLabels()) {
            this.previousState.put(label, label.getZIndex());
        }
    }

    private void orderSelectedLabels() {
        Collections.sort(this.selectedLabels, new Comparator<WorkflowLabel>(){

            @Override
            public int compare(WorkflowLabel arg0, WorkflowLabel arg1) {
                if (arg0.getZIndex() < arg1.getZIndex()) {
                    return -1;
                }
                if (arg0.getZIndex() > arg1.getZIndex()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private int[] getzIndexList(int size) {
        int[] returnList = new int[size];
        int i = 0;
        while (i < size) {
            returnList[i] = i;
            ++i;
        }
        return returnList;
    }

    private void sendSelectedArrayIndicesOneLayerBack(int[] indexList) {
        int i = 0;
        while (i < this.selectedLabels.size()) {
            if (this.selectedLabels.get(i).getZIndex() != i) {
                int z = this.selectedLabels.get(i).getZIndex();
                int tempZ = indexList[z];
                indexList[z] = indexList[z - 1];
                indexList[z - 1] = tempZ;
            }
            ++i;
        }
    }

    private void sendSelectedArrayIndicesOneLayerForward(int[] indexList) {
        int i = this.selectedLabels.size() - 1;
        while (i >= 0) {
            WorkflowLabel selectedLabel = this.selectedLabels.get(i);
            int z = selectedLabel.getZIndex();
            if (z != this.workflowDescription.getWorkflowLabels().size() - 1 - (this.selectedLabels.size() - 1 - i) && z < this.workflowDescription.getWorkflowLabels().size() - 1) {
                int tempZ = indexList[z];
                indexList[z] = indexList[z + 1];
                indexList[z + 1] = tempZ;
            }
            --i;
        }
    }

    private void sendSelectedArrayIndicesToBackground(int[] indexList) {
        int i = 0;
        while (i < this.selectedLabels.size()) {
            int j = this.selectedLabels.get(i).getZIndex();
            while (j > i) {
                int tempZ = indexList[j];
                indexList[j] = indexList[j - 1];
                indexList[j - 1] = tempZ;
                --j;
            }
            ++i;
        }
    }

    private void sendSelectedArrayIndicesToForeground(int[] indexList) {
        int i = this.selectedLabels.size() - 1;
        while (i >= 0) {
            int j = this.selectedLabels.get(i).getZIndex();
            while (j < indexList.length - this.selectedLabels.size() + i) {
                int tempZ = indexList[j];
                indexList[j] = indexList[j + 1];
                indexList[j + 1] = tempZ;
                ++j;
            }
            --i;
        }
    }

    private void setNewzIndicesFromIndexList(int[] indexList) {
        HashMap<WorkflowLabel, Integer> assignMap = new HashMap<WorkflowLabel, Integer>();
        int i = 0;
        while (i < indexList.length) {
            for (WorkflowLabel label : this.workflowDescription.getWorkflowLabels()) {
                if (label.getZIndex() != indexList[i]) continue;
                assignMap.put(label, i);
                break;
            }
            ++i;
        }
        for (WorkflowLabel label : assignMap.keySet()) {
            label.setZIndex(((Integer)assignMap.get(label)).intValue());
        }
    }
}

