/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor;

import de.rcenvironment.core.gui.workflow.editor.NewWorkflowPage;
import de.rcenvironment.core.gui.workflow.editor.ProjectSelectionPage;
import de.rcenvironment.core.gui.workflow.editor.ProjectUsages;
import de.rcenvironment.core.utils.common.CrossPlatformFilenameUtils;
import de.rcenvironment.core.utils.common.InvalidFilenameException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class NewWorkflowProjectWizard
extends Wizard
implements INewWizard,
IPageChangingListener {
    public static String sharedWorkflowName;
    private static final String NEW_WORKFLOW_TITLE = "New Workflow";
    private static final String WF_EDITOR_ID = "de.rcenvironment.rce.gui.workflow.editor.WorkflowEditor";
    private static IStructuredSelection workbenchSelection;
    private static boolean canFinishFlag;
    private IFile newWorkflowFile = null;
    private NewWorkflowPage workflowPage;
    private ProjectSelectionPage projectPage;
    private String projectNameToSet;
    private String workspaceToFile = "";

    static {
        canFinishFlag = false;
    }

    public NewWorkflowProjectWizard() {
    }

    public NewWorkflowProjectWizard(ISelection selection) {
        this.initialize(selection);
    }

    private void initialize(ISelection selection) {
        sharedWorkflowName = null;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(NEW_WORKFLOW_TITLE);
        if (selection instanceof IStructuredSelection) {
            NewWorkflowProjectWizard.setWorkbenchSelection((IStructuredSelection)selection);
        }
        NewWorkflowProjectWizard.allowFinish();
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.initialize((ISelection)currentSelection);
    }

    public void addPages() {
        this.workflowPage = new NewWorkflowPage(this, NewWorkflowProjectWizard.getWorkbenchSelection());
        this.projectPage = new ProjectSelectionPage(this, NewWorkflowProjectWizard.getWorkbenchSelection());
        this.addPage((IWizardPage)this.workflowPage);
        this.addPage((IWizardPage)this.projectPage);
        WizardDialog dialog = (WizardDialog)this.getContainer();
        if (dialog != null) {
            dialog.addPageChangingListener((IPageChangingListener)this);
        }
    }

    public boolean performFinish() {
        final String workflowName = this.workflowPage.getWorkflownameTextfield().getText();
        final ProjectUsages usage = this.projectPage.getUsage();
        final String projectName = this.projectPage.getProjectNameTextField().getText();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewWorkflowProjectWizard.this.doFinish(projectName, workflowName, monitor, usage);
                    }
                    catch (InvalidFilenameException | CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        this.openCreatedWorkflow();
        return true;
    }

    private void openCreatedWorkflow() {
        FileEditorInput editorInput = new FileEditorInput(this.newWorkflowFile);
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().findEditor(WF_EDITOR_ID);
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        try {
            activePage.openEditor((IEditorInput)editorInput, desc.getId());
        }
        catch (PartInitException e) {
            throw new RuntimeException(e);
        }
        IViewPart view = activePage.findView("org.eclipse.ui.navigator.ProjectExplorer");
        ((ISetSelectionTarget)view).selectReveal((ISelection)new StructuredSelection((Object)this.newWorkflowFile));
    }

    private void doFinish(String newProjectName, String newWorkflowName, IProgressMonitor monitor, ProjectUsages usage) throws CoreException, InvalidFilenameException {
        UUID id = UUID.randomUUID();
        String workflowString = "{ \r\"identifier\" : \"" + id + "\", \r" + "\"workflowVersion\" : \"" + 5 + "\"\r" + "}";
        this.projectNameToSet = null;
        if ((NewWorkflowProjectWizard.getWorkbenchSelection() instanceof TreeSelection || NewWorkflowProjectWizard.getWorkbenchSelection() instanceof StructuredSelection) && NewWorkflowProjectWizard.getWorkbenchSelection() != null && !usage.equals((Object)ProjectUsages.NEW)) {
            Object file;
            if (NewWorkflowProjectWizard.getWorkbenchSelection().getFirstElement() instanceof IProject) {
                this.projectNameToSet = ((IProject)NewWorkflowProjectWizard.getWorkbenchSelection().getFirstElement()).getName();
            } else if (NewWorkflowProjectWizard.getWorkbenchSelection().getFirstElement() instanceof IFile) {
                file = (IFile)NewWorkflowProjectWizard.getWorkbenchSelection().getFirstElement();
                this.projectNameToSet = file.getProject().getName();
            } else if (NewWorkflowProjectWizard.getWorkbenchSelection().getFirstElement() instanceof IFolder) {
                IFolder folder = (IFolder)NewWorkflowProjectWizard.getWorkbenchSelection().getFirstElement();
                this.projectNameToSet = folder.getProject().getName();
                this.workspaceToFile = String.valueOf(folder.getFullPath().toOSString().substring(this.projectNameToSet.length() + 2)) + File.separator;
            } else if (NewWorkflowProjectWizard.getWorkbenchSelection().getFirstElement() instanceof File) {
                file = (File)NewWorkflowProjectWizard.getWorkbenchSelection().getFirstElement();
                this.handleFileSelection((File)file);
            } else if (NewWorkflowProjectWizard.getWorkbenchSelection().getFirstElement() instanceof TreeSelection) {
                TreeSelection treeSelection = (TreeSelection)NewWorkflowProjectWizard.getWorkbenchSelection().getFirstElement();
                if (treeSelection.getFirstElement() instanceof File) {
                    File file2 = (File)treeSelection.getFirstElement();
                    this.handleFileSelection(file2);
                } else if (treeSelection.getFirstElement() instanceof IProject) {
                    this.projectNameToSet = ((IProject)treeSelection.getFirstElement()).getName();
                }
            }
        } else if (!newProjectName.equals("")) {
            this.projectNameToSet = newProjectName;
        }
        if (this.projectNameToSet == null) {
            usage = ProjectUsages.NEW;
            this.projectNameToSet = newWorkflowName;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectNameToSet);
        if (usage.equals((Object)ProjectUsages.NEW)) {
            project.create(monitor);
            project.open(monitor);
            monitor.worked(1);
        }
        this.newWorkflowFile = project.getFile(String.valueOf(this.workspaceToFile) + newWorkflowName + ".wf");
        CrossPlatformFilenameUtils.throwExceptionIfFilenameNotValid((String)this.newWorkflowFile.getName());
        ByteArrayInputStream stream = new ByteArrayInputStream(workflowString.getBytes());
        this.newWorkflowFile.create((InputStream)stream, true, monitor);
        NewWorkflowProjectWizard.preventFinish();
    }

    private void handleFileSelection(File file) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath location = Path.fromOSString((String)file.getAbsolutePath());
        IFile ifile = workspace.getRoot().getFileForLocation(location);
        this.projectNameToSet = ifile.getProject().getName();
        this.workspaceToFile = String.valueOf(ifile.getProjectRelativePath().toOSString()) + File.separator;
    }

    public boolean canFinish() {
        boolean doFinish = super.canFinish() && canFinishFlag;
        return doFinish;
    }

    public static void allowFinish() {
        canFinishFlag = true;
    }

    public static void preventFinish() {
        canFinishFlag = false;
    }

    public void handlePageChanging(PageChangingEvent pageChangingEvent) {
        NewWorkflowProjectWizard.allowFinish();
        if (pageChangingEvent.getTargetPage().getClass().equals(ProjectSelectionPage.class)) {
            this.projectPage.getProjectNameTextField().setText(sharedWorkflowName);
            if (this.projectPage.getNewProjectRadioButton().getSelection()) {
                this.projectPage.getNewProjectRadioButton().notifyListeners(13, new Event());
            } else {
                this.projectPage.getExistingProjectRadioButton().notifyListeners(13, new Event());
            }
        }
    }

    public static IStructuredSelection getWorkbenchSelection() {
        return workbenchSelection;
    }

    public static void setWorkbenchSelection(IStructuredSelection workbenchSelection) {
        NewWorkflowProjectWizard.workbenchSelection = workbenchSelection;
    }
}

