/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.incubator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public final class ContextMenuItemRemover {
    private static List<String> itemsToRemove;

    private ContextMenuItemRemover() {
    }

    public static void removeUnwantedMenuEntries(Control control) {
        Properties unwanted = new Properties();
        try {
            unwanted.load(ContextMenuItemRemover.class.getResourceAsStream("unwanted.properties"));
        }
        catch (IOException iOException) {
            return;
        }
        String unwantedEntriesProperty = unwanted.getProperty("unwantedContextMenuEntries");
        itemsToRemove = new ArrayList<String>(Arrays.asList(unwantedEntriesProperty.split(",")));
        if (!control.isDisposed() && control.getMenu() != null && control.getData("MenuDetectToken") == null) {
            control.setData("MenuDetectToken", (Object)true);
            control.addMenuDetectListener((MenuDetectListener)new RemoveItemsMenuDetectListener());
        }
    }

    private static class RemoveItemsMenuDetectListener
    implements MenuDetectListener {
        private RemoveItemsMenuDetectListener() {
        }

        public void menuDetected(MenuDetectEvent event) {
            Menu menu = ((Control)event.widget).getMenu();
            if (!menu.isDisposed() && menu != null && menu.getData("MenuListenerToken") == null) {
                menu.setData("MenuListenerToken", (Object)true);
                menu.addMenuListener((MenuListener)new RemoveItemsMenuListener(menu));
            }
        }
    }

    private static class RemoveItemsMenuListener
    implements MenuListener {
        private final Menu menu;

        RemoveItemsMenuListener(Menu menu) {
            this.menu = menu;
        }

        public void menuShown(MenuEvent menuEvent) {
            MenuItem preceedingMainMenuItem = null;
            MenuItem[] menuItemArray = this.menu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem mainMenuItem = menuItemArray[n2];
                MenuItem itemToHandle = null;
                if (!mainMenuItem.isDisposed()) {
                    itemToHandle = mainMenuItem;
                    if (itemsToRemove.contains(mainMenuItem.getText()) || preceedingMainMenuItem != null && preceedingMainMenuItem.getText().isEmpty() && itemToHandle.getText().isEmpty()) {
                        itemToHandle.dispose();
                    } else {
                        preceedingMainMenuItem = itemToHandle;
                    }
                    if (!itemToHandle.isDisposed() && itemToHandle.getMenu() != null && itemToHandle.getMenu().getData("SubMenuListenerToken") == null) {
                        itemToHandle.getMenu().setData("SubMenuListenerToken", (Object)true);
                        itemToHandle.getMenu().addMenuListener((MenuListener)new CustomSubMenuListener());
                    }
                }
                ++n2;
            }
        }

        public void menuHidden(MenuEvent arg0) {
        }

        private final class CustomSubMenuListener
        implements MenuListener {
            private CustomSubMenuListener() {
            }

            public void menuShown(MenuEvent event) {
                MenuItem preceedingSubMenuItem = null;
                Menu subMenu = (Menu)event.widget;
                MenuItem[] menuItemArray = subMenu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem subMenuItem = menuItemArray[n2];
                    if (preceedingSubMenuItem != null && preceedingSubMenuItem.isDisposed()) {
                        preceedingSubMenuItem = null;
                    }
                    if (itemsToRemove.contains(subMenuItem.getText()) || preceedingSubMenuItem != null && preceedingSubMenuItem.getText().isEmpty() && subMenuItem.getText().isEmpty()) {
                        subMenuItem.dispose();
                    } else {
                        preceedingSubMenuItem = subMenuItem;
                    }
                    ++n2;
                }
            }

            public void menuHidden(MenuEvent arg0) {
            }
        }
    }
}

