/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.common.configuration;

import de.rcenvironment.core.gui.utils.common.configuration.Messages;
import de.rcenvironment.core.utils.common.excel.legacy.ExcelFileExporter;
import de.rcenvironment.core.utils.common.variables.legacy.TypedValue;
import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class ExcelFileExporterDialog {
    private static final int MAX_RETRY_ON_EXCEL_EXPORT = 5;

    private ExcelFileExporterDialog() {
    }

    public static boolean exportExcelFile(File excelFile, TypedValue[][] values) {
        boolean success = false;
        int retry = 1;
        int retryCount = 0;
        do {
            try {
                success = ExcelFileExporter.exportValuesToExcelFile((File)excelFile, (TypedValue[][])values);
                retry = 1;
            }
            catch (FileNotFoundException fileNotFoundException) {
                success = false;
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog dialog = new MessageDialog(shell, Messages.exportToExcelDialogTitle, null, String.valueOf(Messages.exportToExcelDialogText) + "\n" + "File: " + excelFile.getAbsolutePath(), 1, new String[]{"Retry", "Cancel"}, 0);
                retry = dialog.open();
                ++retryCount;
            }
        } while (retry == 0 && retryCount < 5);
        return success;
    }
}

