/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.cluster.configuration.internal;

import de.rcenvironment.core.gui.cluster.configuration.internal.PlainClusterConnectionConfiguration;
import de.rcenvironment.core.gui.cluster.configuration.internal.PlainClusterConnectionConfigurationImpl;
import de.rcenvironment.core.gui.cluster.configuration.internal.SensitiveClusterConnectionConfiguration;
import de.rcenvironment.core.gui.cluster.configuration.internal.SensitiveClusterConnectionConfigurationImpl;
import de.rcenvironment.core.utils.cluster.ClusterQueuingSystem;
import java.util.Map;

public class ClusterConnectionConfiguration
implements PlainClusterConnectionConfiguration,
SensitiveClusterConnectionConfiguration {
    private PlainClusterConnectionConfiguration plainConfiguration;
    private SensitiveClusterConnectionConfiguration sensitiveConfiguration;

    public ClusterConnectionConfiguration(ClusterQueuingSystem queueingSystem, Map<String, String> pathToClusterQueuingSystemCommands, String host, int port, String username, String configurationName, String password) {
        this.plainConfiguration = new PlainClusterConnectionConfigurationImpl(queueingSystem, host, port, username, configurationName);
        ((PlainClusterConnectionConfigurationImpl)this.plainConfiguration).setPathToClusterQueuingSystemCommands(pathToClusterQueuingSystemCommands);
        this.sensitiveConfiguration = new SensitiveClusterConnectionConfigurationImpl(password);
        ((SensitiveClusterConnectionConfigurationImpl)this.sensitiveConfiguration).setKey(String.valueOf(this.plainConfiguration.getUsername()) + "@" + this.plainConfiguration.getHost() + ":" + this.plainConfiguration.getPort());
    }

    public ClusterConnectionConfiguration(ClusterQueuingSystem queueingSystem, Map<String, String> pathToClusterQueuingSystemCommands, String host, int port, String username, String configurationName) {
        this(queueingSystem, pathToClusterQueuingSystemCommands, host, port, username, configurationName, null);
    }

    public String toString() {
        if (this.plainConfiguration.getConfigurationName() != null && !this.plainConfiguration.getConfigurationName().isEmpty()) {
            return this.plainConfiguration.getConfigurationName();
        }
        return String.valueOf(this.plainConfiguration.getUsername()) + "@" + this.plainConfiguration.getHost();
    }

    @Override
    public String getKey() {
        return this.sensitiveConfiguration.getKey();
    }

    @Override
    public String getPassword() {
        return this.sensitiveConfiguration.getPassword();
    }

    @Override
    public ClusterQueuingSystem getClusterQueuingSystem() {
        return this.plainConfiguration.getClusterQueuingSystem();
    }

    @Override
    public Map<String, String> getPathToClusterQueuingSystemCommands() {
        return this.plainConfiguration.getPathToClusterQueuingSystemCommands();
    }

    @Override
    public String getHost() {
        return this.plainConfiguration.getHost();
    }

    @Override
    public int getPort() {
        return this.plainConfiguration.getPort();
    }

    @Override
    public String getUsername() {
        return this.plainConfiguration.getUsername();
    }

    @Override
    public String getConfigurationName() {
        return this.plainConfiguration.getConfigurationName();
    }

    @Override
    public void setPassword(String password) {
        this.sensitiveConfiguration.setPassword(password);
    }

    protected PlainClusterConnectionConfiguration getPlainClusterConnectionConfiguration() {
        return this.plainConfiguration;
    }

    protected SensitiveClusterConnectionConfiguration getSensitiveClusterConnectionConfiguration() {
        return this.sensitiveConfiguration;
    }
}

