/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.export.matching;

import de.rcenvironment.core.datamanagement.export.matching.MatchResult;
import de.rcenvironment.core.datamanagement.export.matching.Matcher;
import de.rcenvironment.core.datamodel.types.api.VectorTD;
import de.rcenvironment.core.utils.common.StringUtils;

public class VectorTDMatcher
implements Matcher<VectorTD> {
    @Override
    public MatchResult matches(VectorTD actual, VectorTD expected) {
        int expectedRow;
        MatchResult result = new MatchResult();
        int actualRow = actual.getRowDimension();
        if (actualRow != (expectedRow = expected.getRowDimension())) {
            result.addFailureCause("The vector dimensions are not the same.");
            return result;
        }
        int i = 0;
        while (i < actualRow) {
            if (!actual.getFloatTDOfElement(i).equals(expected.getFloatTDOfElement(i))) {
                result.addFailureCause(StringUtils.format((String)"The vector values in row %s are not the same.", (Object[])new Object[]{i}));
                return result;
            }
            ++i;
        }
        return result;
    }
}

