/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration;

import de.rcenvironment.core.configuration.ConfigurationException;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.WritableConfigurationSegment;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public interface ConfigurationService {
    public static final String SYSTEM_PROPERTY_INSTALLATION_DATA_ROOT_OVERRIDE = "rce.installationData.rootDir";
    public static final String SYSTEM_PROPERTY_SHARED_SETTINGS_ROOT_OVERRIDE = "rce.sharedSettings.rootDir";
    public static final String SYSTEM_PROPERTY_USER_SETTINGS_ROOT_OVERRIDE = "rce.userSettings.rootDir";
    public static final String CONFIGURATION_PLACEHOLDER_SYSTEM_USER_NAME = "${systemUser}";
    public static final String CONFIGURATION_PLACEHOLDER_HOST_NAME = "${hostName}";
    public static final String CONFIGURATION_PLACEHOLDER_PROFILE_NAME = "${profileName}";
    public static final String CONFIGURATION_PLACEHOLDER_VERSION = "${version}";
    public static final String CONFIGURATION_PLACEHOLDER_JAVA_VERSION = "${javaVersion}";
    public static final String CONFIGURATION_PLACEHOLDER_SYSTEM_NAME = "${systemName}";
    public static final String DEFAULT_INSTANCE_NAME_VALUE = "Unnamed instance started by \"${systemUser}\" on ${hostName}";
    public static final String DEFAULT_PARENT_TEMP_DIRECTORY_RELATIVE_PATH_WINDOWS = "rce-temp";
    public static final String DEFAULT_PARENT_TEMP_DIRECTORY_RELATIVE_PATH_LINUX = "rce-temp-${systemUser}";
    public static final String SYSTEM_PROPERTY_USER_HOME = "user.home";
    public static final String SYSTEM_PROPERTY_USER_NAME = "user.name";
    public static final String SYSTEM_PROPERTY_JAVA_VERSION = "java.version";
    public static final String SYSTEM_PROPERTY_OS_NAME = "os.name";

    public void addSubstitutionProperties(String var1, Map<String, String> var2);

    @Deprecated
    public <T> T getConfiguration(String var1, Class<T> var2);

    public ConfigurationSegment getConfigurationSegment(String var1);

    public WritableConfigurationSegment getOrCreateWritableConfigurationSegment(String var1) throws ConfigurationException;

    public void writeConfigurationChanges() throws ConfigurationException, IOException;

    public void reloadConfiguration();

    public String resolveBundleConfigurationPath(String var1, String var2);

    public String getInstanceName();

    public boolean getIsWorkflowHost();

    public double[] getLocationCoordinates();

    public String getLocationName();

    public String getInstanceContact();

    public String getInstanceAdditionalInformation();

    public boolean getIsRelay();

    public File getProfileDirectory();

    public File getProfileConfigurationFile();

    public boolean isUsingIntendedProfileDirectory();

    public boolean hasIntendedProfileDirectoryValidVersion();

    public boolean isIntendedProfileDirectorySuccessfullyLocked();

    public File getOriginalProfileDirectory();

    public File getConfigurablePath(ConfigurablePathId var1);

    public File[] getConfigurablePathList(ConfigurablePathListId var1);

    public File initializeSubDirInConfigurablePath(ConfigurablePathId var1, String var2);

    public File getStandardImportDirectory(String var1);

    public File getParentTempDirectoryRoot();

    public boolean isUsingDefaultConfigurationValues();

    public File getUnpackedFilesLocation(String var1) throws ConfigurationException;

    public static enum ConfigurablePathId {
        INSTALLATION_DATA_ROOT,
        SHARED_USER_SETTINGS_ROOT,
        PROFILE_ROOT,
        PROFILE_CONFIGURATION_DATA,
        PROFILE_INTEGRATION_DATA,
        PROFILE_DATA_MANAGEMENT,
        PROFILE_INTERNAL_DATA,
        PROFILE_OUTPUT,
        DEFAULT_WRITEABLE_CONFIGURATION_ROOT,
        DEFAULT_WRITEABLE_INTEGRATION_ROOT,
        CONFIGURATION_SAMPLES_LOCATION;

    }

    public static enum ConfigurablePathListId {
        READABLE_CONFIGURATION_DIRS,
        READABLE_INTEGRATION_DIRS,
        JDBC_DRIVER_DIRS;

    }
}

