/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.sshremoteaccess.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import de.rcenvironment.core.communication.api.LogicalNodeManagementService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.communication.sshconnection.SshConnectionService;
import de.rcenvironment.core.component.api.ComponentConstants;
import de.rcenvironment.core.component.management.api.LocalComponentRegistrationService;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInstallationBuilder;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.api.ComponentInterfaceBuilder;
import de.rcenvironment.core.component.model.api.ComponentRevisionBuilder;
import de.rcenvironment.core.component.model.configuration.api.ComponentConfigurationModelFactory;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDefinition;
import de.rcenvironment.core.component.model.endpoint.api.ComponentEndpointModelFactory;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinitionsProvider;
import de.rcenvironment.core.component.sshremoteaccess.SshRemoteAccessClientService;
import de.rcenvironment.core.component.sshremoteaccess.internal.RemoteAccessComponentDescription;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.ServiceUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.ssh.jsch.JschFileTransfer;
import de.rcenvironment.core.utils.ssh.jsch.executor.JSchRCECommandLineExecutor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class SshRemoteAccessClientServiceImpl
implements SshRemoteAccessClientService {
    private static final String SLASH = "/";
    private static final int SIZE_32 = 32;
    private static final int SIZE_16 = 16;
    private static final Log LOG = LogFactory.getLog(SshRemoteAccessClientService.class);
    private static final int UPDATE_TOOLS_INTERVAL_SECS = 10;
    private static final String QUOT = "\"";
    private static LocalComponentRegistrationService registry;
    private PlatformService platformService;
    private SshConnectionService sshService;
    private final Map<String, Map<String, ComponentInstallation>> registeredComponentsPerConnection;
    private final Map<String, Map<String, String>> registeredComponentHashesPerConnection;
    private ScheduledFuture<?> taskFuture;
    private ObjectMapper mapper = new ObjectMapper();
    private Map<String, LogicalNodeId> logicalNodeMap;
    private TempFileService tempFileService;
    @Reference
    private LogicalNodeManagementService logicalNodeManagementService;

    public SshRemoteAccessClientServiceImpl() {
        this.registeredComponentsPerConnection = Collections.synchronizedMap(new HashMap());
        this.registeredComponentHashesPerConnection = Collections.synchronizedMap(new HashMap());
        this.logicalNodeMap = new HashMap<String, LogicalNodeId>();
    }

    protected void bindLogicalNodeManagementService(LogicalNodeManagementService newService) {
        this.logicalNodeManagementService = newService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSshRemoteAccessComponents(String connectionId) {
        Session session;
        Map<String, String> registeredComponentHashes;
        Map<String, Object> registeredComponents = this.registeredComponentsPerConnection.get(connectionId);
        if (registeredComponents == null) {
            registeredComponents = Collections.synchronizedMap(new HashMap());
            this.registeredComponentsPerConnection.put(connectionId, registeredComponents);
        }
        if ((registeredComponentHashes = this.registeredComponentHashesPerConnection.get(connectionId)) == null) {
            registeredComponentHashes = Collections.synchronizedMap(new HashMap());
            this.registeredComponentHashesPerConnection.put(connectionId, registeredComponentHashes);
        }
        if ((session = this.sshService.getAvtiveSshSession(connectionId)) != null) {
            JSchRCECommandLineExecutor executor = new JSchRCECommandLineExecutor(session);
            ArrayList<String> componentIdsReceived = new ArrayList<String>();
            this.getAndRegisterRemoteTools(connectionId, registeredComponents, registeredComponentHashes, executor, componentIdsReceived);
            this.getAndRegisterRemoteWorkflows(connectionId, registeredComponents, registeredComponentHashes, executor, componentIdsReceived);
            Map<String, Object> map = registeredComponents;
            synchronized (map) {
                Iterator<String> it = registeredComponents.keySet().iterator();
                while (it.hasNext()) {
                    String regCompName = it.next();
                    if (componentIdsReceived.contains(regCompName)) continue;
                    this.removeToolAccessComponent(regCompName, connectionId);
                    it.remove();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getAndRegisterRemoteWorkflows(String connectionId, Map<String, ComponentInstallation> registeredComponents, Map<String, String> registeredComponentHashes, JSchRCECommandLineExecutor executor, List<String> componentIdsReceived) {
        String command = StringUtils.format((String)"ra list-wfs", (Object[])new Object[0]);
        try {
            executor.start(command);
            Throwable throwable = null;
            Object var8_10 = null;
            try {
                InputStream stdoutStream = executor.getStdout();
                try {
                    try (InputStream stderrStream = executor.getStderr();){
                        LineIterator it = IOUtils.lineIterator((InputStream)stdoutStream, null);
                        this.parseOutputStreamForWorkflowList(connectionId, registeredComponents, registeredComponentHashes, componentIdsReceived, it);
                        executor.waitForTermination();
                    }
                    if (stdoutStream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stdoutStream == null) throw throwable;
                    stdoutStream.close();
                    throw throwable;
                }
                stdoutStream.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException | InterruptedException | NumberFormatException e1) {
            LOG.error((Object)"Executing SSH command (ra list-wfs) failed", (Throwable)e1);
        }
    }

    private void parseOutputStreamForWorkflowList(String connectionId, Map<String, ComponentInstallation> registeredComponents, Map<String, String> registeredComponentHashes, List<String> componentIdsReceived, LineIterator it) {
        Integer numberOfWorkflows = null;
        Integer tokensPerWorkflow = null;
        if (it.hasNext()) {
            String line = it.nextLine();
            if (line.equals("")) {
                LOG.error((Object)("Could not load the list of available workflows from the remote instance. Reason: " + it.nextLine()));
            } else {
                if (line.contains("Your account is not allowed to run an interactive shell or execute commands.")) {
                    LOG.error((Object)("Could not load the list of available workflows from the remote instance. Reason: " + line));
                    this.sshService.disconnectSession(connectionId);
                    return;
                }
                numberOfWorkflows = Integer.parseInt(line);
            }
        }
        if (it.hasNext()) {
            tokensPerWorkflow = Integer.parseInt(it.nextLine());
        }
        if (numberOfWorkflows != null && tokensPerWorkflow != null) {
            if (tokensPerWorkflow != 8) {
                LOG.error((Object)"Unkown format of workflow descriptions");
            } else {
                int i = 0;
                while (i < numberOfWorkflows) {
                    this.parseSingleWorkflowDescription(connectionId, registeredComponents, registeredComponentHashes, componentIdsReceived, it);
                    ++i;
                }
            }
        }
    }

    private void parseSingleWorkflowDescription(String connectionId, Map<String, ComponentInstallation> registeredComponents, Map<String, String> registeredComponentHashes, List<String> componentIdsReceived, LineIterator it) {
        String wfName = it.nextLine();
        String wfVersion = it.nextLine();
        String groupName = it.nextLine();
        String hostId = it.nextLine();
        String hostName = it.nextLine();
        String inputDefinitions = it.nextLine();
        String outputDefinitions = it.nextLine();
        String hash = it.nextLine();
        String componentId = String.valueOf(wfName) + "_wf";
        String componentAndHostId = this.createUniqueToolAndHostId(componentId, hostId, connectionId);
        if (!registeredComponents.containsKey(componentAndHostId)) {
            LOG.info((Object)StringUtils.format((String)"Detected new remote workflow %s (version %s) on host %s.", (Object[])new Object[]{wfName, wfVersion, hostName}));
            this.registerToolAccessComponent(new RemoteAccessComponentDescription(componentId, wfName, wfVersion, hostName, hostId, connectionId, true, inputDefinitions, outputDefinitions, groupName));
            registeredComponentHashes.put(componentAndHostId, hash);
        } else if (!registeredComponentHashes.get(componentAndHostId).equals(hash)) {
            this.removeToolAccessComponent(componentAndHostId, connectionId);
            registeredComponentHashes.remove(componentAndHostId);
            this.registerToolAccessComponent(new RemoteAccessComponentDescription(componentId, wfName, wfVersion, hostName, hostId, connectionId, true, inputDefinitions, outputDefinitions, groupName));
            registeredComponentHashes.put(componentAndHostId, hash);
            LOG.info((Object)StringUtils.format((String)"SSH tool %s changed on host %s.", (Object[])new Object[]{wfName, hostName}));
        }
        componentIdsReceived.add(componentAndHostId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getAndRegisterRemoteTools(String connectionId, Map<String, ComponentInstallation> registeredComponents, Map<String, String> registeredComponentHashes, JSchRCECommandLineExecutor executor, List<String> componentIdsReceived) {
        String toolDescriptionsString;
        block16: {
            String command = StringUtils.format((String)"ra list-tools", (Object[])new Object[0]);
            toolDescriptionsString = "";
            try {
                executor.start(command);
                Throwable throwable = null;
                Object var9_11 = null;
                try {
                    InputStream stdoutStream = executor.getStdout();
                    try {
                        try (InputStream stderrStream = executor.getStderr();){
                            executor.waitForTermination();
                            toolDescriptionsString = IOUtils.toString((InputStream)stdoutStream);
                        }
                        if (stdoutStream == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (stdoutStream == null) throw throwable;
                        stdoutStream.close();
                        throw throwable;
                    }
                    stdoutStream.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException | InterruptedException e1) {
                LOG.error((Object)"Executing SSH command (ra list-tools) failed", (Throwable)e1);
            }
        }
        if (!toolDescriptionsString.contains("Command ra list-tools not executed.") && !toolDescriptionsString.contains("Your account is not allowed to run an interactive shell or execute commands.")) {
            this.parseOutputStringForComponentsList(toolDescriptionsString, connectionId, registeredComponents, registeredComponentHashes, componentIdsReceived);
            return;
        }
        LOG.error((Object)("Could not load the list of available tools from the remote instance. Reason: " + toolDescriptionsString));
    }

    private void parseOutputStringForComponentsList(String toolDescriptionsString, String connectionId, Map<String, ComponentInstallation> registeredComponents, Map<String, String> registeredComponentHashes, List<String> componentIdsReceived) {
        CSVFormat csvFormat = CSVFormat.newFormat((char)' ').withQuote('\"').withQuoteMode(QuoteMode.ALL);
        CSVParser parser = null;
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (StringReader toolDescriptionReader = new StringReader(toolDescriptionsString);){
                parser = csvFormat.parse((Reader)toolDescriptionReader);
                for (CSVRecord record : parser.getRecords()) {
                    this.parseSingleComponentDescription(connectionId, registeredComponents, registeredComponentHashes, componentIdsReceived, record);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Could not parse tool descriptions" + e.toString()));
        }
    }

    private void parseSingleComponentDescription(String connectionId, Map<String, ComponentInstallation> registeredComponents, Map<String, String> registeredComponentHashes, List<String> componentIdsReceived, CSVRecord record) {
        String toolName = record.get(0);
        String toolVersion = record.get(1);
        String hostId = record.get(2);
        String hostName = record.get(3);
        String inputDefinitions = record.get(4);
        String outputDefinitions = record.get(5);
        String group = record.get(6);
        String hash = record.get(7);
        String toolId = toolName;
        String toolAndHostId = this.createUniqueToolAndHostId(toolId, hostId, connectionId);
        if (!registeredComponents.containsKey(toolAndHostId)) {
            LOG.info((Object)StringUtils.format((String)"Detected new SSH tool %s (version %s) on host %s.", (Object[])new Object[]{toolName, toolVersion, hostName}));
            this.registerToolAccessComponent(new RemoteAccessComponentDescription(toolId, toolName, toolVersion, hostName, hostId, connectionId, false, inputDefinitions, outputDefinitions, group));
            registeredComponentHashes.put(toolAndHostId, hash);
        } else if (!registeredComponentHashes.get(toolAndHostId).equals(hash)) {
            this.removeToolAccessComponent(toolAndHostId, connectionId);
            registeredComponentHashes.remove(toolAndHostId);
            this.registerToolAccessComponent(new RemoteAccessComponentDescription(toolId, toolName, toolVersion, hostName, hostId, connectionId, false, inputDefinitions, outputDefinitions, group));
            registeredComponentHashes.put(toolAndHostId, hash);
            LOG.info((Object)StringUtils.format((String)"SSH tool %s changed to version %s on host %s.", (Object[])new Object[]{toolName, toolVersion, hostName}));
        }
        componentIdsReceived.add(toolAndHostId);
    }

    private String createUniqueToolAndHostId(String toolId, String hostId, String connectionId) {
        return String.valueOf(toolId) + SLASH + connectionId + SLASH + hostId;
    }

    protected void registerToolAccessComponent(RemoteAccessComponentDescription component) {
        Set<EndpointDefinition> inputs = this.parseEndpoints(component.getInputDefinitions(), EndpointType.INPUT);
        EndpointDefinitionsProvider inputProvider = ComponentEndpointModelFactory.createEndpointDefinitionsProvider(inputs);
        Set<EndpointDefinition> outputs = this.parseEndpoints(component.getOutputDefinitions(), EndpointType.OUTPUT);
        EndpointDefinitionsProvider outputProvider = ComponentEndpointModelFactory.createEndpointDefinitionsProvider(outputs);
        ConfigurationDefinition configuration = this.generateConfiguration(component.getToolName(), component.getToolVersion(), component.getHostName(), component.getHostId(), component.getConnectionId(), component.isWorkflow());
        ComponentInterface componentInterface = component.isWorkflow() ? new ComponentInterfaceBuilder().setIdentifier("de.rcenvironment.remoteaccess." + component.getComponentId()).setDisplayName(StringUtils.format((String)"%s (%s) [workflow on %s]", (Object[])new Object[]{component.getToolName(), component.getToolVersion(), component.getHostName()})).setIcon16(this.readDefaultToolIcon(16)).setIcon32(this.readDefaultToolIcon(32)).setGroupName(component.getGroup()).setVersion(component.getToolVersion()).setInputDefinitionsProvider(inputProvider).setOutputDefinitionsProvider(outputProvider).setConfigurationDefinition(configuration).setConfigurationExtensionDefinitions(new HashSet()).setColor(ComponentConstants.COMPONENT_COLOR_STANDARD).setShape(ComponentConstants.COMPONENT_SHAPE_STANDARD).setSize(ComponentConstants.COMPONENT_SIZE_STANDARD).build() : new ComponentInterfaceBuilder().setIdentifier("de.rcenvironment.remoteaccess." + component.getComponentId()).setDisplayName(StringUtils.format((String)"%s [SSH forwarded]", (Object[])new Object[]{component.getToolName()})).setIcon16(this.readDefaultToolIcon(16)).setIcon32(this.readDefaultToolIcon(32)).setGroupName(component.getGroup()).setVersion(component.getToolVersion()).setInputDefinitionsProvider(inputProvider).setOutputDefinitionsProvider(outputProvider).setConfigurationDefinition(configuration).setConfigurationExtensionDefinitions(new HashSet()).setColor(ComponentConstants.COMPONENT_COLOR_STANDARD).setShape(ComponentConstants.COMPONENT_SHAPE_STANDARD).setSize(ComponentConstants.COMPONENT_SIZE_STANDARD).build();
        ComponentInstallation ci = new ComponentInstallationBuilder().setComponentRevision(new ComponentRevisionBuilder().setComponentInterface(componentInterface).setClassName("de.rcenvironment.core.component.sshremoteaccess.SshRemoteAccessClientComponent").build()).setNodeId(this.getLocalLogicalNodeIdForRemoteNode(component.getHostId(), component.getConnectionId())).setInstallationId(this.createUniqueToolAndHostId(componentInterface.getIdentifierAndVersion(), component.getHostId(), component.getConnectionId())).build();
        registry.registerOrUpdateLocalComponentInstallation(ci);
        this.registeredComponentsPerConnection.get(component.getConnectionId()).put(this.createUniqueToolAndHostId(component.getComponentId(), component.getHostId(), component.getConnectionId()), ci);
    }

    private LogicalNodeId getLocalLogicalNodeIdForRemoteNode(String remoteNodeId) {
        if (this.logicalNodeMap.containsKey(remoteNodeId)) {
            return this.logicalNodeMap.get(remoteNodeId);
        }
        try {
            LogicalNodeId remoteId = NodeIdentifierUtils.parseLogicalNodeIdString((String)remoteNodeId);
            String recPart = remoteId.getInstanceNodeIdString();
            LogicalNodeId logicalNode = this.logicalNodeManagementService.createRecognizableLocalLogicalNodeId(recPart, null);
            this.logicalNodeMap.put(remoteNodeId, logicalNode);
            return logicalNode;
        }
        catch (IdentifierException e) {
            LOG.error((Object)("Failed to retrieve logical node id for remote node: " + e.toString()));
            return this.platformService.getLocalDefaultLogicalNodeId();
        }
    }

    private LogicalNodeId getLocalLogicalNodeIdForRemoteNode(String remoteNodeId, String connectionId) {
        String id = String.valueOf(remoteNodeId) + SLASH + connectionId;
        if (this.logicalNodeMap.containsKey(id)) {
            return this.logicalNodeMap.get(id);
        }
        LogicalNodeId logicalNode = this.logicalNodeManagementService.createTransientLocalLogicalNodeId(null);
        this.logicalNodeMap.put(id, logicalNode);
        return logicalNode;
    }

    protected void removeToolAccessComponent(String toolAndHostId, String connectionId) {
        ComponentInstallation ci = this.registeredComponentsPerConnection.get(connectionId).get(toolAndHostId);
        if (ci != null) {
            registry.unregisterLocalComponentInstallation(ci.getInstallationId());
        }
    }

    private ConfigurationDefinition generateConfiguration(String toolName, String toolVersion, String hostName, String hostId, String connectionId, boolean isWorkflow) {
        LinkedList configuration = new LinkedList();
        HashMap<String, String> readOnlyConfiguration = new HashMap<String, String>();
        readOnlyConfiguration.put("toolName", toolName);
        readOnlyConfiguration.put("version", toolVersion);
        readOnlyConfiguration.put("connection", connectionId);
        readOnlyConfiguration.put("hostId", hostId);
        readOnlyConfiguration.put("hostName", hostName);
        readOnlyConfiguration.put("isWorkflow", Boolean.toString(isWorkflow));
        return ComponentConfigurationModelFactory.createConfigurationDefinition(configuration, new LinkedList(), new LinkedList(), readOnlyConfiguration);
    }

    private Set<EndpointDefinition> parseEndpoints(String endpointDescriptions, EndpointType type) {
        HashSet<EndpointDefinition> endpoints = new HashSet<EndpointDefinition>();
        try {
            Set rawEndpointData = (Set)this.mapper.readValue(endpointDescriptions, HashSet.class);
            for (Map rawEndpoint : rawEndpointData) {
                EndpointDefinition endpoint = ComponentEndpointModelFactory.createEndpointDefinition((Map)rawEndpoint, (EndpointType)type);
                endpoints.add(endpoint);
            }
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage());
        }
        return endpoints;
    }

    @Reference(unbind="unbindComponentRegistry")
    protected void bindComponentRegistry(LocalComponentRegistrationService newRegistry) {
        registry = newRegistry;
    }

    protected void unbindComponentRegistry(LocalComponentRegistrationService oldRegistry) {
        registry = (LocalComponentRegistrationService)ServiceUtils.createFailingServiceProxy(LocalComponentRegistrationService.class);
    }

    @Reference(unbind="unbindPlatformService")
    protected void bindPlatformService(PlatformService newService) {
        this.platformService = newService;
    }

    protected void unbindPlatformService(PlatformService service) {
        this.platformService = (PlatformService)ServiceUtils.createFailingServiceProxy(PlatformService.class);
    }

    @Reference
    protected void bindSSHConnectionService(SshConnectionService newService) {
        this.sshService = newService;
    }

    public SshConnectionService getSshService() {
        return this.sshService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSshRemoteAccessComponents() {
        Collection activeConnectionIds = this.sshService.getAllActiveSshConnectionSetupIds();
        for (String id : activeConnectionIds) {
            this.updateSshRemoteAccessComponents(id);
        }
        Map<String, Map<String, ComponentInstallation>> map = this.registeredComponentsPerConnection;
        synchronized (map) {
            HashSet<String> outdatedConnectionIds = new HashSet<String>(this.registeredComponentsPerConnection.keySet());
            outdatedConnectionIds.removeAll(activeConnectionIds);
            for (String id : outdatedConnectionIds) {
                Map<String, ComponentInstallation> registeredComponents = this.registeredComponentsPerConnection.get(id);
                if (registeredComponents == null) continue;
                for (String oldCompName : registeredComponents.keySet()) {
                    this.removeToolAccessComponent(oldCompName, id);
                }
                this.registeredComponentsPerConnection.remove(id);
                this.registeredComponentHashesPerConnection.remove(id);
            }
        }
    }

    @Activate
    public void activate() {
        this.taskFuture = ConcurrencyUtils.getAsyncTaskService().scheduleAtFixedInterval("Periodic updating of SSH-accessible remote tools", this::updateSshRemoteAccessComponents, TimeUnit.SECONDS.toMillis(10L));
        this.tempFileService = TempFileServiceAccess.getInstance();
    }

    @Deactivate
    public void deactivate() {
        if (this.taskFuture != null) {
            this.taskFuture.cancel(false);
            this.taskFuture = null;
        }
    }

    private byte[] readDefaultToolIcon(int iconSize) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = this.getClass().getResourceAsStream("/icons/tool" + iconSize + ".png");){
                return IOUtils.toByteArray((InputStream)inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | NullPointerException e) {
            LOG.error((Object)("Failed to read default tool icon: " + e));
            return null;
        }
    }

    @Override
    public Map<String, String> getListOfToolsWithDocumentation(String toolId) {
        HashMap<String, String> nodesWithDocumentation = new HashMap<String, String>();
        ArrayList<String> relevantConnectionIds = new ArrayList<String>();
        toolId = toolId.replace("de.rcenvironment.remoteaccess.", "");
        String[] splitToolId = toolId.split(SLASH);
        String toolName = splitToolId[0];
        String toolNameAndVersion = String.valueOf(splitToolId[0]) + SLASH + splitToolId[1];
        String formattedToolNameAndVersion = QUOT + toolNameAndVersion.replace(QUOT, "\"\"") + QUOT;
        for (String connectionId : this.registeredComponentsPerConnection.keySet()) {
            for (String registeredToolId : this.registeredComponentsPerConnection.get(connectionId).keySet()) {
                if (!registeredToolId.startsWith(toolName)) continue;
                relevantConnectionIds.add(connectionId);
            }
        }
        for (String connectionId : relevantConnectionIds) {
            Session session = this.sshService.getAvtiveSshSession(connectionId);
            if (session == null) continue;
            JSchRCECommandLineExecutor executor = new JSchRCECommandLineExecutor(session);
            String command = StringUtils.format((String)("ra get-doc-list " + formattedToolNameAndVersion), (Object[])new Object[0]);
            try {
                executor.start(command);
                Throwable throwable = null;
                Object var14_16 = null;
                try {
                    InputStream stdoutStream = executor.getStdout();
                    try {
                        try (InputStream stderrStream = executor.getStderr();){
                            LineIterator it = IOUtils.lineIterator((InputStream)stdoutStream, null);
                            Integer numberOfNodeIds = null;
                            if (it.hasNext()) {
                                String line = it.nextLine();
                                if (line.equals("")) {
                                    LOG.error((Object)("Could not load the list of documentations from the remote instance. Reason: " + it.nextLine()));
                                } else {
                                    numberOfNodeIds = Integer.parseInt(line);
                                }
                            }
                            if (numberOfNodeIds != null) {
                                int i = 0;
                                while (i < numberOfNodeIds) {
                                    String hashValue = it.nextLine();
                                    String nodeId = it.nextLine();
                                    LogicalNodeId logicalNode = this.getLocalLogicalNodeIdForRemoteNode(nodeId, connectionId);
                                    nodesWithDocumentation.put(hashValue, logicalNode.getLogicalNodeIdString());
                                    ++i;
                                }
                            }
                            executor.waitForTermination();
                        }
                        if (stdoutStream == null) continue;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (stdoutStream != null) {
                            stdoutStream.close();
                        }
                        throw throwable;
                    }
                    stdoutStream.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException | InterruptedException | NumberFormatException e1) {
                LOG.error((Object)"Executing SSH command (ra get-doc-list) failed", (Throwable)e1);
            }
        }
        return nodesWithDocumentation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File downloadToolDocumentation(String toolId, String logicalNodeId, String hashValue) {
        String currentSessionToken;
        JSchRCECommandLineExecutor rceExecutor;
        Session session;
        File docFile;
        toolId = toolId.replace("de.rcenvironment.remoteaccess.", "");
        String[] splitToolId = toolId.split(SLASH);
        String toolNameAndVersion = String.valueOf(splitToolId[0]) + SLASH + splitToolId[1];
        String formattedToolNameAndVersion = QUOT + toolNameAndVersion.replace(QUOT, "\"\"") + QUOT;
        String sessionId = null;
        String nodeId = null;
        Iterator<Map.Entry<String, LogicalNodeId>> iterator = this.logicalNodeMap.entrySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                docFile = null;
                session = this.sshService.getAvtiveSshSession(sessionId);
                rceExecutor = new JSchRCECommandLineExecutor(session);
                currentSessionToken = this.initializeRemoteExecutionContext(rceExecutor);
                if (currentSessionToken != null) break;
                return null;
            }
            Map.Entry<String, LogicalNodeId> entry = iterator.next();
            if (!entry.getValue().getLogicalNodeIdString().equals(logicalNodeId)) continue;
            String[] splitId = entry.getKey().split(SLASH);
            if (splitId.length != 2) {
                return null;
            }
            nodeId = splitId[0];
            sessionId = splitId[1];
        }
        try {
            File downloadDir;
            block18: {
                downloadDir = this.tempFileService.createManagedTempDir();
                String command = StringUtils.format((String)"ra get-tool-doc %s %s %s %s", (Object[])new Object[]{formattedToolNameAndVersion, nodeId, hashValue, currentSessionToken});
                rceExecutor.start(command);
                Throwable throwable = null;
                Object var16_18 = null;
                try {
                    InputStream stdoutStream = rceExecutor.getStdout();
                    try {
                        try (InputStream stderrStream = rceExecutor.getStderr();){
                            rceExecutor.waitForTermination();
                        }
                        if (stdoutStream == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (stdoutStream == null) throw throwable;
                        stdoutStream.close();
                        throw throwable;
                    }
                    stdoutStream.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            JschFileTransfer.downloadDirectory((Session)session, (String)StringUtils.format((String)"/ra/%s/output", (Object[])new Object[]{currentSessionToken}), (File)downloadDir);
            docFile = new File(downloadDir, "output");
            if (docFile.exists()) return docFile;
            LOG.error((Object)"Downloading documentation command failed");
            return docFile;
        }
        catch (JSchException | IOException | InterruptedException e1) {
            LOG.error((Object)"Downloading documentation command failed", e1);
        }
        return docFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String initializeRemoteExecutionContext(JSchRCECommandLineExecutor rceExecutor) {
        String currentSessionToken = null;
        try {
            rceExecutor.start("ra init --compact");
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                InputStream stdoutStream = rceExecutor.getStdout();
                try {
                    try (InputStream stderrStream = rceExecutor.getStderr();){
                        rceExecutor.waitForTermination();
                        currentSessionToken = IOUtils.toString((InputStream)stdoutStream).trim();
                        if (currentSessionToken.contains("Command ra init --compact not executed.")) {
                            LOG.error((Object)("Could not initiate remote tool or workflow execution. Reason: " + currentSessionToken));
                        }
                        LOG.info((Object)("Received session token " + currentSessionToken));
                        String errStream = IOUtils.toString((InputStream)stderrStream);
                        if (!errStream.isEmpty()) {
                            LOG.error((Object)errStream);
                        }
                    }
                    if (stdoutStream == null) return currentSessionToken;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stdoutStream == null) throw throwable;
                    stdoutStream.close();
                    throw throwable;
                }
                stdoutStream.close();
                return currentSessionToken;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException | InterruptedException e1) {
            LOG.error((Object)"Executing SSH command failed", (Throwable)e1);
        }
        return currentSessionToken;
    }
}

