/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.api;

import de.rcenvironment.core.communication.api.ServiceCallContext;
import de.rcenvironment.core.communication.common.LogicalNodeSessionId;
import de.rcenvironment.core.communication.rpc.internal.ServiceCallContextImpl;
import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContext;
import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContextBuilder;
import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContextHolder;
import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContextMemento;
import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContextNameProvider;

public final class ServiceCallContextUtils {
    private static final ThreadContextNameProvider THREAD_CONTEXT_NAME_PROVIDER = new ThreadContextNameProvider(){

        public String getName(ThreadContext context) {
            ServiceCallContext scc = (ServiceCallContext)context.getAspect(ServiceCallContext.class);
            return scc.toString();
        }
    };

    private ServiceCallContextUtils() {
    }

    public static ServiceCallContext getCurrentServiceCallContext() {
        return (ServiceCallContext)ThreadContextHolder.getCurrentContextAspect(ServiceCallContext.class);
    }

    public static ThreadContextMemento attachServiceCallDataToThreadContext(LogicalNodeSessionId caller, LogicalNodeSessionId target, String serviceName, String methodName) {
        ServiceCallContextImpl serviceCallContext = new ServiceCallContextImpl(caller, target, serviceName, methodName);
        ThreadContext newThreadContext = ThreadContextBuilder.fromCurrent().setAspect(ServiceCallContext.class, (Object)serviceCallContext).setNameProvider(THREAD_CONTEXT_NAME_PROVIDER).build();
        return ThreadContextHolder.setCurrentContext((ThreadContext)newThreadContext);
    }
}

