/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.common.internal;

import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.utils.common.SizeValidatedDataSource;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public abstract class DataStreamDownloadWrapper<T extends SizeValidatedDataSource> {
    private long totalSize;
    private long received;
    private PipedOutputStream localOutputStream;
    private MessageType expectedMessageBlockType;

    public final synchronized T initialize(long size, MessageType messageBlockType) throws IOException {
        if (size < 0L) {
            throw new IllegalArgumentException("Negative size");
        }
        if (this.totalSize > 0L) {
            throw new IllegalStateException("Already initialized");
        }
        this.totalSize = size;
        this.localOutputStream = new PipedOutputStream();
        this.expectedMessageBlockType = messageBlockType;
        PipedInputStream inputStream = new PipedInputStream(this.localOutputStream);
        if (size == 0L) {
            this.localOutputStream.close();
        }
        return this.createReturnObject(size, inputStream);
    }

    public final synchronized boolean processMessageBlock(MessageBlock input) throws IOException {
        boolean complete;
        if (input.getType() != this.expectedMessageBlockType) {
            throw new ProtocolException("Expected message type " + (Object)((Object)this.expectedMessageBlockType) + " but received type " + (Object)((Object)input.getType()));
        }
        this.received += (long)input.getDataLength();
        if (this.received > this.totalSize) {
            throw new ProtocolException("Expected a total of " + this.totalSize + " bytes, but the last message's length added up to " + this.received);
        }
        this.localOutputStream.write(input.getData());
        boolean bl = complete = this.received == this.totalSize;
        if (complete) {
            this.localOutputStream.close();
        }
        return complete;
    }

    public abstract T createReturnObject(long var1, PipedInputStream var3);
}

