/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.transport.jms.common;

import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.SerializationException;
import de.rcenvironment.core.communication.model.InitialNodeInformation;
import de.rcenvironment.core.communication.model.NetworkRequest;
import de.rcenvironment.core.communication.model.NetworkResponse;
import de.rcenvironment.core.communication.model.impl.InitialNodeInformationImpl;
import de.rcenvironment.core.communication.protocol.NetworkRequestFactory;
import de.rcenvironment.core.communication.protocol.NetworkResponseFactory;
import de.rcenvironment.core.communication.transport.jms.common.JMSHandshakeInformation;
import de.rcenvironment.core.communication.utils.MessageUtils;
import java.io.Serializable;
import java.net.ProtocolException;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;

public final class JmsProtocolUtils {
    private JmsProtocolUtils() {
    }

    public static Message createHandshakeMessage(JMSHandshakeInformation handshakeInformation, Session session) throws JMSException {
        ObjectMessage initialMessage = session.createObjectMessage();
        initialMessage.setStringProperty("messageType", "initial");
        initialMessage.setStringProperty("protocol.version", handshakeInformation.getProtocolVersionString());
        initialMessage.setStringProperty("channel.id", handshakeInformation.getChannelId());
        initialMessage.setStringProperty("queuename.requests.incoming", handshakeInformation.getTemporaryQueueInformation());
        InitialNodeInformation initialNodeInformation = handshakeInformation.getInitialNodeInformation();
        if (initialNodeInformation != null) {
            byte[] handshakeBytes = MessageUtils.serializeSafeObject((Serializable)initialNodeInformation);
            initialMessage.setObject((Serializable)handshakeBytes);
        }
        return initialMessage;
    }

    public static JMSHandshakeInformation parseHandshakeMessage(Message message, String expectedProtocolVersion) throws JMSException, ProtocolException {
        JMSHandshakeInformation result = new JMSHandshakeInformation();
        result.setProtocolVersionString(message.getStringProperty("protocol.version"));
        result.setTemporaryQueueInformation(message.getStringProperty("queuename.requests.incoming"));
        if (!result.matchesVersion(expectedProtocolVersion)) {
            return result;
        }
        result.setChannelId(message.getStringProperty("channel.id"));
        byte[] handshakeRequestBytes = (byte[])((ObjectMessage)message).getObject();
        if (handshakeRequestBytes == null || handshakeRequestBytes.length == 0) {
            throw new ProtocolException("Received handshake request without payload");
        }
        try {
            result.setInitialNodeInformation((InitialNodeInformation)MessageUtils.deserializeObject((byte[])handshakeRequestBytes, InitialNodeInformationImpl.class));
        }
        catch (SerializationException e) {
            throw new ProtocolException("Failed to deserialize initial node information from handshake message: " + e.toString());
        }
        return result;
    }

    public static Message createMessageFromNetworkRequest(NetworkRequest request, Session session) throws JMSException {
        Map metadata = request.accessRawMetaData();
        ObjectMessage jmsRequest = session.createObjectMessage();
        jmsRequest.setObject((Serializable)request.getContentBytes());
        jmsRequest.setObjectProperty("metadata", (Object)metadata);
        jmsRequest.setStringProperty("messageType", "request");
        return jmsRequest;
    }

    public static NetworkRequest createNetworkRequestFromMessage(Message jmsRequest) throws JMSException, CommunicationException {
        byte[] content = (byte[])((ObjectMessage)jmsRequest).getObject();
        if (content.length == 0) {
            throw new CommunicationException("Received message with zero-length payload");
        }
        Map requestMetadata = (Map)jmsRequest.getObjectProperty("metadata");
        NetworkRequest originalRequest = NetworkRequestFactory.reconstructNetworkRequest((byte[])content, (Map)requestMetadata);
        return originalRequest;
    }

    public static Message createMessageFromNetworkResponse(NetworkResponse response, Session session) throws JMSException {
        ObjectMessage jmsResponse = session.createObjectMessage();
        jmsResponse.setObject((Serializable)response.getContentBytes());
        jmsResponse.setIntProperty("result.code", response.getResultCode().getCode());
        return jmsResponse;
    }

    public static NetworkResponse createNetworkResponseFromMessage(Message jmsResponse, NetworkRequest request) throws JMSException {
        byte[] content = (byte[])((ObjectMessage)jmsResponse).getObject();
        if (jmsResponse.propertyExists("result.code")) {
            int resultCode = jmsResponse.getIntProperty("result.code");
            return NetworkResponseFactory.generateResponseWithResultCode((NetworkRequest)request, (byte[])content, (int)resultCode);
        }
        return NetworkResponseFactory.generateSuccessResponse((NetworkRequest)request, (byte[])content);
    }

    public static Message createChannelShutdownMessage(Session session, String channelId, String securityToken) throws JMSException {
        TextMessage poisonPill = session.createTextMessage();
        poisonPill.setStringProperty("messageType", "shutdown.channel");
        poisonPill.setStringProperty("channel.id", channelId);
        poisonPill.setText(securityToken);
        return poisonPill;
    }

    public static Message createQueueShutdownMessage(Session session, String securityToken) throws JMSException {
        TextMessage poisonPill = session.createTextMessage();
        poisonPill.setStringProperty("messageType", "shutdown.queue.s2c");
        poisonPill.setText(securityToken);
        return poisonPill;
    }

    public static void configureMessageProducer(MessageProducer producer) throws JMSException {
        producer.setDeliveryMode(1);
    }

    public static void sendWithTransientProducer(Session session, Message message, Destination destination) throws JMSException {
        try (MessageProducer producer = session.createProducer(destination);){
            JmsProtocolUtils.configureMessageProducer(producer);
            producer.send(message);
        }
    }
}

