/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.transport.jms.common;

import de.rcenvironment.core.communication.channel.ServerContactPoint;
import de.rcenvironment.core.communication.model.InitialNodeInformation;
import de.rcenvironment.core.communication.transport.jms.common.AbstractJmsQueueConsumer;
import de.rcenvironment.core.communication.transport.jms.common.JMSHandshakeInformation;
import de.rcenvironment.core.communication.transport.jms.common.JmsMessageChannel;
import de.rcenvironment.core.communication.transport.jms.common.JmsProtocolUtils;
import de.rcenvironment.core.communication.transport.jms.common.RemoteInitiatedMessageChannelFactory;
import de.rcenvironment.core.communication.transport.spi.MessageChannel;
import de.rcenvironment.core.communication.transport.spi.MessageChannelEndpointHandler;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.net.ProtocolException;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;

public final class InitialInboxConsumer
extends AbstractJmsQueueConsumer
implements Runnable {
    private final MessageChannelEndpointHandler endpointHandler;
    private ServerContactPoint associatedSCP;
    private RemoteInitiatedMessageChannelFactory passiveConnectionFactory;
    private final AsyncTaskService threadPool = ConcurrencyUtils.getAsyncTaskService();
    private final String expectedProtocolVersion;

    public InitialInboxConsumer(Connection localJmsConnection, ServerContactPoint scp, RemoteInitiatedMessageChannelFactory passiveConnectionFactory) throws JMSException {
        super(localJmsConnection, "initial/c2b");
        this.associatedSCP = scp;
        this.endpointHandler = scp.getEndpointHandler();
        this.expectedProtocolVersion = scp.getExpectedProtocolVersion();
        this.passiveConnectionFactory = passiveConnectionFactory;
    }

    @Override
    @TaskDescription(value="JMS Network Transport: Incoming connection listener")
    public void run() {
        super.run();
    }

    @Override
    protected void dispatchMessage(Message message, Connection connection) {
        this.threadPool.execute("JMS Network Transport: Dispatch initial handshake request", () -> {
            try (Session responseSession = this.jmsConnection.createSession(false, 1);){
                this.dispatchMessageInternal(message, responseSession, connection);
            }
            catch (JMSException e) {
                this.log.error((Object)("JMS exception in response session for request from queue " + this.queueName), (Throwable)e);
            }
        });
    }

    private void dispatchMessageInternal(Message message, Session session, Connection connection) {
        String messageType;
        try {
            messageType = message.getStringProperty("messageType");
        }
        catch (JMSException jMSException) {
            this.log.warn((Object)"Received message with undefined message type");
            return;
        }
        try {
            if ("initial".equals(messageType)) {
                this.handleHandshakeRequest(message, session, connection);
            } else {
                this.log.warn((Object)("Received message of unhandled type " + messageType + " from queue " + this.queueName));
            }
        }
        catch (ProtocolException | JMSException e) {
            this.log.warn((Object)StringUtils.format((String)"Error while dispatching message of type %s: %s", (Object[])new Object[]{messageType, e.toString()}));
        }
    }

    private void handleHandshakeRequest(Message message, Session session, Connection connection) throws JMSException, ProtocolException {
        Message jmsResponse;
        JMSHandshakeInformation remoteHandshakeInformation = JmsProtocolUtils.parseHandshakeMessage(message, this.expectedProtocolVersion);
        if (remoteHandshakeInformation.matchesVersion(this.expectedProtocolVersion)) {
            InitialNodeInformation remoteNodeInformation = remoteHandshakeInformation.getInitialNodeInformation();
            InitialNodeInformation ownNodeInformation = this.endpointHandler.exchangeNodeInformation(remoteNodeInformation);
            JMSHandshakeInformation ownHandshakeInformation = new JMSHandshakeInformation();
            this.log.debug((Object)("Received initial handshake request from " + remoteNodeInformation));
            JmsMessageChannel remoteInitiatedChannel = this.passiveConnectionFactory.createRemoteInitiatedMessageChannel(ownNodeInformation, remoteHandshakeInformation, ownHandshakeInformation, this.associatedSCP, connection, session);
            remoteInitiatedChannel.markAsEstablished();
            this.endpointHandler.onRemoteInitiatedChannelEstablished((MessageChannel)remoteInitiatedChannel, this.associatedSCP);
            ownHandshakeInformation.setProtocolVersionString(this.expectedProtocolVersion);
            ownHandshakeInformation.setChannelId(remoteInitiatedChannel.getChannelId());
            ownHandshakeInformation.setInitialNodeInformation(ownNodeInformation);
            this.log.debug((Object)("Remote-initiated connection established, sending handshake response to " + remoteNodeInformation));
            jmsResponse = JmsProtocolUtils.createHandshakeMessage(ownHandshakeInformation, session);
        } else {
            JMSHandshakeInformation ownHandshakeInformation = new JMSHandshakeInformation();
            ownHandshakeInformation.setProtocolVersionString(this.expectedProtocolVersion);
            this.log.debug((Object)("Received handshake request with an incompatible version ('" + remoteHandshakeInformation.getProtocolVersionString() + "'); sending minimal response"));
            jmsResponse = JmsProtocolUtils.createHandshakeMessage(ownHandshakeInformation, session);
        }
        JmsProtocolUtils.sendWithTransientProducer(session, jmsResponse, message.getJMSReplyTo());
    }
}

