/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.execution;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.components.switchcmp.common.SwitchComponentConstants;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.update.spi.PersistentComponentDescriptionUpdater;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;

public class SwitchPersistentComponentDescriptionUpdater
implements PersistentComponentDescriptionUpdater {
    private static final String V1_1 = "1.1";
    private static final String STATIC_INPUTS = "staticInputs";
    private static final String DYNAMIC_INPUTS = "dynamicInputs";
    private static final String REQUIRED_IF_CONNCECTED = "RequiredIfConnected";
    private static final String NOT_REQUIRED = "NotRequired";
    private static final String REQUIRED = "Required";
    private static ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();

    public String[] getComponentIdentifiersAffectedByUpdate() {
        return SwitchComponentConstants.COMPONENT_IDS;
    }

    public int getFormatVersionsAffectedByUpdate(String persistentComponentDescriptionVersion, boolean silent) {
        int versionsToUpdate = 0;
        if (silent && persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo(V1_1) < 0) {
            versionsToUpdate |= 4;
        }
        return versionsToUpdate;
    }

    public PersistentComponentDescription performComponentDescriptionUpdate(int formatVersion, PersistentComponentDescription description, boolean silent) throws IOException {
        if (silent && formatVersion == 4 && description.getComponentVersion().compareTo(V1_1) < 0) {
            description = this.updateToComponentVersion11(description);
        }
        return description;
    }

    private PersistentComponentDescription updateToComponentVersion11(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        JsonNode dynamicInputs;
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        JsonNode staticInputs = node.get(STATIC_INPUTS);
        if (staticInputs != null) {
            for (JsonNode endpoint : staticInputs) {
                ObjectNode metaData = (ObjectNode)endpoint.get("metadata");
                if (metaData == null) continue;
                metaData.put("inputExecutionConstraint_4aae3eea", REQUIRED);
            }
        }
        if ((dynamicInputs = node.get(DYNAMIC_INPUTS)) != null) {
            for (JsonNode endpoint : dynamicInputs) {
                ObjectNode metaData = (ObjectNode)endpoint.get("metadata");
                String currentConstraint = metaData.get("inputExecutionConstraint_4aae3eea").textValue();
                if (!currentConstraint.equals(NOT_REQUIRED)) continue;
                metaData.put("inputExecutionConstraint_4aae3eea", REQUIRED_IF_CONNCECTED);
            }
        }
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion(V1_1);
        return description;
    }
}

