/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.doe.execution.validator;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.doe.common.DOEAlgorithms;
import de.rcenvironment.components.doe.execution.Messages;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.spi.AbstractLoopComponentValidator;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DOEComponentValidator
extends AbstractLoopComponentValidator {
    public String getIdentifier() {
        return "de.rcenvironment.doe.v2";
    }

    protected List<ComponentValidationMessage> validateLoopComponentSpecific(ComponentDescription componentDescription) {
        ComponentValidationMessage noInputMessage;
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        boolean hasOutputs = this.getOutputs(componentDescription).size() > 0;
        String methodName = this.getProperty(componentDescription, "method");
        if (!hasOutputs) {
            noInputMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "", Messages.noOutputsDefinedLong, Messages.noOutputsDefinedLong);
            messages.add(noInputMessage);
        } else {
            int outputCount = this.getOutputs(componentDescription).size();
            int runNumber = Integer.parseInt(this.getProperty(componentDescription, "runNumber"));
            ComponentValidationMessage tooManySamplesMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "", Messages.tooManySamples, Messages.tooManySamples);
            if (methodName.equals("Full factorial design")) {
                if (Math.pow(runNumber, outputCount) >= DOEAlgorithms.MAXMIMAL_RUNS) {
                    messages.add(tooManySamplesMessage);
                }
            } else if ((double)runNumber >= DOEAlgorithms.MAXMIMAL_RUNS) {
                messages.add(tooManySamplesMessage);
            }
        }
        if (!(methodName.equals("Custom design table") || methodName.equals("Monte Carlo design") || methodName.equals("Custom design table as input") || this.getOutputs(componentDescription).size() >= 2)) {
            ComponentValidationMessage outputTooLow = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "method", Messages.numOutputsG2Long, Messages.numOutputsG2Long);
            messages.add(outputTooLow);
        }
        if (methodName.equals("Custom design table")) {
            this.checkStartAndEndSample(componentDescription, messages);
            this.checkTableDimensions(componentDescription, messages);
        }
        if (methodName.equals("Full factorial design") && (this.getProperty(componentDescription, "runNumber") == null || Integer.parseInt(this.getProperty(componentDescription, "runNumber")) < 2)) {
            noInputMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "runNumber", Messages.numLevelsInvalidLong, Messages.numLevelsInvalidLong);
            messages.add(noInputMessage);
        }
        return messages;
    }

    protected List<ComponentValidationMessage> validateOnWorkflowStartComponentSpecific(ComponentDescription componentDescription) {
        return null;
    }

    private void checkTableDimensions(ComponentDescription componentDescription, List<ComponentValidationMessage> messages) {
        String table = this.getProperty(componentDescription, "table");
        if (table == null || table.isEmpty() || table.equals("null")) {
            ComponentValidationMessage startSampleErrorMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "table", Messages.noTableLong, Messages.noTableLong);
            messages.add(startSampleErrorMessage);
        } else {
            ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
            try {
                ComponentValidationMessage startSampleErrorMessage;
                Double[][] tableValues = (Double[][])mapper.readValue(table, Double[][].class);
                if (tableValues != null && tableValues.length > 0 && tableValues[0] != null && tableValues[0].length < this.getOutputs(componentDescription).size()) {
                    startSampleErrorMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "table", Messages.tableTooShortLong, Messages.tableTooShortLong);
                    messages.add(startSampleErrorMessage);
                }
                if (tableValues != null && tableValues.length > 0 && tableValues[0].length > this.getOutputs(componentDescription).size()) {
                    startSampleErrorMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, "table", Messages.tableTooLongLong, Messages.tableTooLongLong);
                    messages.add(startSampleErrorMessage);
                }
                ComponentValidationMessage noValueError = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "table", Messages.undefinedValues, Messages.undefinedValues);
                int i = 0;
                while (i < Integer.parseInt(this.getProperty(componentDescription, "runNumber")) && tableValues != null && i < tableValues.length) {
                    int j = 0;
                    while (j < tableValues[i].length) {
                        if (tableValues[i][j] == null) {
                            messages.add(noValueError);
                            break;
                        }
                        ++j;
                    }
                    if (messages.contains(noValueError)) break;
                    ++i;
                }
                if (this.getProperty(componentDescription, "method").equals("Custom design table") && this.getProperty(componentDescription, "endSample") != null && !this.getProperty(componentDescription, "endSample").isEmpty() && Double.parseDouble(this.getProperty(componentDescription, "endSample")) > Double.parseDouble(this.getProperty(componentDescription, "runNumber")) - 1.0) {
                    ComponentValidationMessage endSampleErrorMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "endSample", Messages.endSampleTooHighLong, Messages.endSampleTooHighLong);
                    messages.add(endSampleErrorMessage);
                }
            }
            catch (IOException iOException) {
                ComponentValidationMessage startSampleErrorMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "table", Messages.noTableLong, Messages.noTableLong);
                messages.add(startSampleErrorMessage);
            }
        }
    }

    private void checkStartAndEndSample(ComponentDescription componentDescription, Collection<ComponentValidationMessage> messages) {
        ComponentValidationMessage startSampleErrorMessage;
        ComponentValidationMessage startSampleErrorMessage2;
        String startSampleString = this.getProperty(componentDescription, "startSample");
        Integer startSample = null;
        try {
            startSample = Integer.parseInt(startSampleString);
        }
        catch (NumberFormatException numberFormatException) {
            startSampleErrorMessage2 = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "startSample", Messages.startSampleNotInteger, Messages.startSampleNotInteger);
            messages.add(startSampleErrorMessage2);
        }
        if (startSample != null && startSample < 0) {
            startSampleErrorMessage2 = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "startSample", Messages.startSampleG0, Messages.startSampleG0);
            messages.add(startSampleErrorMessage2);
        }
        if (startSample != null && startSample > Integer.parseInt(this.getProperty(componentDescription, "runNumber"))) {
            startSampleErrorMessage2 = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "startSample", Messages.startSampleTooHigh, Messages.startSampleTooHigh);
            messages.add(startSampleErrorMessage2);
        }
        String endSampleString = this.getProperty(componentDescription, "endSample");
        Integer endSample = null;
        try {
            endSample = Integer.parseInt(endSampleString);
        }
        catch (NumberFormatException numberFormatException) {
            startSampleErrorMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "endSample", Messages.endSampleNotInteger, Messages.endSampleNotInteger);
            messages.add(startSampleErrorMessage);
        }
        if (endSample != null && endSample < 0) {
            startSampleErrorMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "endSample", Messages.endSampleG0, Messages.endSampleG0);
            messages.add(startSampleErrorMessage);
        }
        if (startSample == null || endSample == null || startSample > endSample) {
            startSampleErrorMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "endSample", Messages.endSampleGStart, Messages.endSampleGStart);
            messages.add(startSampleErrorMessage);
        }
    }

    protected Set<EndpointDescription> getOutputs(ComponentDescription componentDescription) {
        HashSet<EndpointDescription> outputs = new HashSet<EndpointDescription>(super.getOutputs(componentDescription));
        Iterator outputsIterator = outputs.iterator();
        while (outputsIterator.hasNext()) {
            EndpointDescription next = (EndpointDescription)outputsIterator.next();
            if (!"toForward".equals(next.getDynamicEndpointIdentifier()) && !"Done".equals(next.getName()) && !"Number of samples".equals(next.getName())) continue;
            outputsIterator.remove();
        }
        return outputs;
    }
}

