/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.converger.gui;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.AddDynamicInputCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.AddDynamicOutputCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.EditDynamicInputCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.EditDynamicOutputCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.ProcessEndpointsGroupCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.RemoveDynamicInputCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.RemoveDynamicOutputCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointEditDialog;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointSelectionPane;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConvergerEndpointSelectionPane
extends EndpointSelectionPane {
    private final WorkflowNodeCommand.Executor executor;
    private final EndpointSelectionPane outputPane;
    private final EndpointSelectionPane auxiliaryPane;

    public ConvergerEndpointSelectionPane(String title, WorkflowNodeCommand.Executor executor, EndpointSelectionPane outputPane, EndpointSelectionPane auxiliaryPane) {
        super(title, EndpointType.INPUT, "valueToConverge", new String[]{"startToConverge"}, new String[0], executor, false, true);
        this.executor = executor;
        this.outputPane = outputPane;
        this.auxiliaryPane = auxiliaryPane;
    }

    protected void onEditClicked(String name, EndpointEditDialog dialog, Map<String, String> newMetaData) {
        if (!this.endpointManager.getEndpointDescription(name).getDynamicEndpointIdentifier().equals(this.dynEndpointIdToManage)) {
            dialog.setReadOnlyType(2);
        }
        super.onEditClicked(name, dialog, newMetaData);
    }

    protected void executeAddCommand(String name, DataType type, Map<String, String> metaData) {
        ProcessEndpointsGroupCommand groupCommand = new ProcessEndpointsGroupCommand(this.executor, new Refreshable[]{this, this.outputPane});
        groupCommand.add((WorkflowNodeCommand)new AddDynamicInputCommand("valueToConverge", name, type, metaData, new Refreshable[]{this, this.outputPane}));
        if (metaData.get("hasStartValue") == null || !Boolean.parseBoolean(metaData.get("hasStartValue"))) {
            HashMap<String, String> startMetaData = new HashMap<String, String>();
            startMetaData.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.Required.name());
            groupCommand.add((WorkflowNodeCommand)new AddDynamicInputCommand("startToConverge", String.valueOf(name) + "_start", type, startMetaData, "startValues", new Refreshable[]{this, this.outputPane}));
        }
        groupCommand.add((WorkflowNodeCommand)new AddDynamicOutputCommand("valueToConverge", name, type, Collections.emptyMap(), new Refreshable[]{this, this.outputPane}));
        groupCommand.add((WorkflowNodeCommand)new AddDynamicOutputCommand("auxiliaryValue", String.valueOf(name) + "_is_converged", DataType.Boolean, Collections.emptyMap(), new Refreshable[]{this, this.auxiliaryPane}));
        groupCommand.add((WorkflowNodeCommand)new AddDynamicOutputCommand("finalToConverge", String.valueOf(name) + "_converged", type, Collections.emptyMap(), new Refreshable[]{this, this.outputPane}));
        this.execute((WorkflowNodeCommand)groupCommand);
    }

    protected void executeEditCommand(EndpointDescription oldDescription, EndpointDescription newDescription) {
        String oldName = oldDescription.getName();
        String newName = newDescription.getName();
        DataType newType = newDescription.getDataType();
        Map newMetaData = newDescription.getMetaData();
        ProcessEndpointsGroupCommand groupCommand = new ProcessEndpointsGroupCommand(this.executor, new Refreshable[]{this, this.outputPane});
        groupCommand.add((WorkflowNodeCommand)new EditDynamicInputCommand(oldDescription.getDynamicEndpointIdentifier(), oldName, newName, newType, newMetaData, new Refreshable[]{this, this.outputPane}));
        if (oldDescription.getDynamicEndpointIdentifier().equals(this.dynEndpointIdToManage)) {
            boolean newHasStartValue;
            boolean oldHasStartValue = oldDescription.getMetaData().get("hasStartValue") != null && Boolean.parseBoolean((String)oldDescription.getMetaData().get("hasStartValue"));
            boolean bl = newHasStartValue = newDescription.getMetaData().get("hasStartValue") != null && Boolean.parseBoolean((String)newDescription.getMetaData().get("hasStartValue"));
            if (!oldHasStartValue && !newHasStartValue) {
                groupCommand.add((WorkflowNodeCommand)new EditDynamicInputCommand("startToConverge", String.valueOf(oldName) + "_start", String.valueOf(newName) + "_start", newType, new HashMap(), "startValues", new Refreshable[]{this, this.outputPane}));
            } else if (!oldHasStartValue && newHasStartValue) {
                groupCommand.add((WorkflowNodeCommand)new RemoveDynamicInputCommand("startToConverge", String.valueOf(oldName) + "_start", new Refreshable[]{this, this.outputPane}));
            } else if (oldHasStartValue && !newHasStartValue) {
                groupCommand.add((WorkflowNodeCommand)new AddDynamicInputCommand("startToConverge", String.valueOf(newName) + "_start", newType, new HashMap(), "startValues", new Refreshable[]{this, this.outputPane}));
            }
            groupCommand.add((WorkflowNodeCommand)new EditDynamicOutputCommand("valueToConverge", oldName, newName, newType, new HashMap(), new Refreshable[]{this, this.outputPane}));
            groupCommand.add((WorkflowNodeCommand)new EditDynamicOutputCommand("auxiliaryValue", String.valueOf(oldName) + "_is_converged", String.valueOf(newName) + "_is_converged", DataType.Boolean, new HashMap(), new Refreshable[]{this, this.auxiliaryPane}));
            groupCommand.add((WorkflowNodeCommand)new EditDynamicOutputCommand("finalToConverge", String.valueOf(oldName) + "_converged", String.valueOf(newName) + "_converged", newType, new HashMap(), new Refreshable[]{this, this.outputPane}));
        }
        this.execute((WorkflowNodeCommand)groupCommand);
    }

    protected void executeRemoveCommand(List<String> names) {
        ProcessEndpointsGroupCommand groupCommand = new ProcessEndpointsGroupCommand(this.executor, new Refreshable[]{this, this.outputPane});
        for (String name : names) {
            groupCommand.add((WorkflowNodeCommand)new RemoveDynamicInputCommand("valueToConverge", name, new Refreshable[]{this, this.outputPane}));
            groupCommand.add((WorkflowNodeCommand)new RemoveDynamicInputCommand("startToConverge", String.valueOf(name) + "_start", new Refreshable[]{this, this.outputPane}));
            groupCommand.add((WorkflowNodeCommand)new RemoveDynamicOutputCommand("valueToConverge", name, new Refreshable[]{this, this.outputPane}));
            groupCommand.add((WorkflowNodeCommand)new RemoveDynamicOutputCommand("auxiliaryValue", String.valueOf(name) + "_is_converged", new Refreshable[]{this, this.auxiliaryPane}));
            groupCommand.add((WorkflowNodeCommand)new RemoveDynamicOutputCommand("finalToConverge", String.valueOf(name) + "_converged", new Refreshable[]{this, this.outputPane}));
        }
        this.execute((WorkflowNodeCommand)groupCommand);
    }
}

