/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

public class SanitizingPatternLayout
extends PatternLayout {
    private String replaceRegex;
    private String replacement;
    private boolean trim;
    private Pattern compiledRegex;

    @Override
    public void activateOptions() {
        if (this.replaceRegex != null) {
            this.compiledRegex = Pattern.compile(this.replaceRegex);
        }
        super.activateOptions();
    }

    @Override
    protected PatternParser createPatternParser(String pattern) {
        return new PatternParser(pattern){

            @Override
            protected void finalizeConverter(char c) {
                switch (c) {
                    case 'm': {
                        PatternConverter pc = new PatternConverter(this.formattingInfo){

                            @Override
                            protected String convert(LoggingEvent event) {
                                return SanitizingPatternLayout.this.sanitize(event.getRenderedMessage());
                            }
                        };
                        this.currentLiteral.setLength(0);
                        this.addConverter(pc);
                        break;
                    }
                    default: {
                        super.finalizeConverter(c);
                    }
                }
            }
        };
    }

    private String sanitize(String message) {
        if (message == null) {
            return message;
        }
        if (this.trim) {
            message = message.trim();
        }
        if (this.compiledRegex == null) {
            return message;
        }
        Matcher matcher = this.compiledRegex.matcher(message);
        if (!matcher.matches()) {
            message = matcher.replaceAll(this.replacement);
        }
        return message;
    }

    public String getReplaceRegex() {
        return this.replaceRegex;
    }

    public void setReplaceRegex(String replaceRegex) {
        this.replaceRegex = replaceRegex;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }
}

