/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.rendering;

import com.idrsolutions.pdf.acroforms.xfa.XFAFormStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.exception.PdfException;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.actions.DefaultActionHandler;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.creation.SwingFormFactory;
import org.jpedal.objects.acroforms.formData.GUIData;
import org.jpedal.objects.acroforms.formData.SwingData;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.acroforms.utils.FormUtils;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.StringUtils;

public class DefaultAcroRenderer
implements AcroRenderer {
    public static final boolean testActions = false;
    private static final boolean showFormsDecoded = false;
    private Map currentItems = new HashMap();
    FormObject[] Fforms;
    FormObject[] Aforms;
    PdfObject AcroRes = null;
    PdfArrayIterator fieldList = null;
    PdfArrayIterator[] annotList = null;
    private static final boolean showMethods = false;
    private static final boolean identifyType = false;
    private static final boolean debug = false;
    private boolean ignoreForms = false;
    private FormFactory formFactory;
    private GUIData compData = new SwingData();
    private Map proxyObjects = new HashMap();
    private Set sigObject = null;
    private Map cachedObjs = new HashMap();
    private PdfPageData pageData;
    private int[] AfieldCount = null;
    private int ATotalCount;
    private int FfieldCount = 0;
    protected int pageCount = 0;
    private PdfObjectReader currentPdfFile;
    private FormStream fDecoder;
    private ActionHandler formsActionHandler;
    private Javascript javascript;
    private int insetH;
    private PdfObject acroObj;
    private boolean hasXFA = false;
    private PdfDecoder decode_pdf;
    private boolean updatingForms = false;
    private List additionalAfterCallC = new ArrayList();

    public void resetHandler(Object object, PdfDecoder pdfDecoder, int n) {
        this.decode_pdf = pdfDecoder;
        if (n == 5) {
            this.formsActionHandler = object != null ? (ActionHandler)object : new DefaultActionHandler();
            this.formsActionHandler.init(pdfDecoder, this.javascript, this);
            if (this.formFactory != null) {
                this.formFactory.reset(this, this.formsActionHandler);
                this.compData.resetDuplicates();
            }
        }
    }

    public void removeDisplayComponentsFromScreen() {
        if (this.compData != null) {
            this.compData.removeAllComponentsFromScreen();
        }
    }

    public void resetFormData(int n, int n2, PdfPageData pdfPageData, PdfObjectReader pdfObjectReader, PdfObject pdfObject) {
        this.insetH = n2;
        this.currentPdfFile = pdfObjectReader;
        this.pageData = pdfPageData;
        this.acroObj = pdfObject;
        this.sigObject = null;
        this.compData.setPageData(pdfPageData, n, n2);
        if (pdfObject == null) {
            this.FfieldCount = 0;
            this.fieldList = null;
        } else {
            PdfArrayIterator pdfArrayIterator = null;
            PdfObject pdfObject2 = pdfObject.getDictionary(2627089);
            if (pdfObject2 == null && (pdfArrayIterator = pdfObject.getMixedArray(2627089)) != null && pdfArrayIterator.getTokenCount() == 0) {
                pdfArrayIterator = null;
            }
            this.hasXFA = pdfObject2 != null || pdfArrayIterator != null;
            this.fDecoder = this.hasXFA ? new XFAFormStream(pdfObject, pdfObjectReader) : new FormStream();
            this.fieldList = pdfObject.getMixedArray(893143676);
            if (this.fieldList != null) {
                this.FfieldCount = this.fieldList.getTokenCount();
                this.AcroRes = pdfObject.getDictionary(5154);
                if (this.AcroRes != null) {
                    pdfObjectReader.checkResolved(this.AcroRes);
                }
            } else {
                this.FfieldCount = 0;
                this.AcroRes = null;
            }
            while (this.FfieldCount == 1) {
                String string = this.fieldList.getNextValueAsString(false);
                FormObject formObject = new FormObject(string, this.formsActionHandler);
                pdfObjectReader.readObject(formObject);
                byte[][] byArray = this.getKid(formObject);
                if (byArray == null) break;
                this.fieldList = new PdfArrayIterator(byArray);
                this.FfieldCount = this.fieldList.getTokenCount();
            }
        }
        this.resetContainers(true);
    }

    public void resetAnnotData(int n, int n2, PdfPageData pdfPageData, int n3, PdfObjectReader pdfObjectReader, byte[][] byArray) {
        this.insetH = n2;
        this.currentPdfFile = pdfObjectReader;
        this.pageData = pdfPageData;
        boolean bl = true;
        this.compData.setPageData(pdfPageData, n, n2);
        if (byArray == null) {
            this.AfieldCount = null;
            this.ATotalCount = 0;
            if (this.annotList != null) {
                this.annotList[n3] = null;
            }
            this.annotList = null;
        } else {
            int n4;
            int n5 = pdfPageData.getPageCount() + 1;
            if (n5 <= n3) {
                n5 = n3 + 1;
            }
            if (this.annotList == null) {
                this.annotList = new PdfArrayIterator[n5];
                this.AfieldCount = new int[n5];
            } else if (n3 >= this.annotList.length) {
                PdfArrayIterator[] pdfArrayIteratorArray = this.annotList;
                int[] nArray = this.AfieldCount;
                this.AfieldCount = new int[n5];
                this.annotList = new PdfArrayIterator[n5];
                for (int i = 0; i < pdfArrayIteratorArray.length; ++i) {
                    this.AfieldCount[i] = nArray[i];
                    this.annotList[i] = pdfArrayIteratorArray[i];
                }
            } else if (this.AfieldCount == null) {
                this.AfieldCount = new int[n5];
            }
            this.annotList[n3] = new PdfArrayIterator(byArray);
            this.AfieldCount[n3] = n4 = this.annotList[n3].getTokenCount();
            this.ATotalCount += n4;
            bl = false;
            if (this.fDecoder == null) {
                this.fDecoder = this.hasXFA ? new XFAFormStream(this.acroObj, pdfObjectReader) : new FormStream();
            }
        }
        this.resetContainers(bl);
    }

    protected void resetContainers(boolean bl) {
        if (bl) {
            this.currentItems.clear();
            this.compData.resetComponents(this.ATotalCount + this.FfieldCount, this.pageCount, false);
            this.proxyObjects.clear();
        } else {
            this.compData.resetComponents(this.ATotalCount + this.FfieldCount, this.pageCount, true);
            this.proxyObjects.clear();
        }
        if (this.formFactory == null) {
            this.formFactory = new SwingFormFactory(this, this.formsActionHandler);
        } else {
            this.formFactory.reset(this, this.formsActionHandler);
            this.compData.resetDuplicates();
        }
        this.formsActionHandler.setActionFactory(this.formFactory.getActionFactory());
    }

    public void createDisplayComponentsForPage(int n, PdfStreamDecoder pdfStreamDecoder) {
        int n2;
        boolean bl = false;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = System.getProperty("org.jpedal.flattenForm");
        if (string != null && string.toLowerCase().equals("true")) {
            this.compData.setRasterizeForms(true);
        }
        if ((n2 = this.compData.getStartComponentCountForPage(n)) == -1 || n2 == -999) {
            FormObject formObject;
            int n3;
            int n4;
            int n5;
            this.compData.initParametersForPage(this.pageData, n, this.decode_pdf);
            if (this.formsActionHandler != null) {
                this.formsActionHandler.init(this.decode_pdf, this.javascript, this);
                this.formsActionHandler.setPageAccess(this.pageData.getMediaBoxHeight(n), this.insetH);
            }
            if (this.fDecoder != null) {
                this.currentItems.clear();
            }
            HashMap hashMap2 = new HashMap();
            int n6 = 0;
            if (this.AfieldCount != null && this.AfieldCount.length > n) {
                n6 = this.AfieldCount[n];
            }
            this.Fforms = new FormObject[this.FfieldCount];
            FormObject[] formObjectArray = null;
            this.Aforms = new FormObject[n6];
            int n7 = 2;
            for (n5 = 0; n5 < n7; ++n5) {
                int n8 = 0;
                if (n5 == 0) {
                    n4 = 0;
                    if (this.fieldList != null) {
                        this.fieldList.resetToStart();
                        n4 = this.fieldList.getTokenCount() - 1;
                    }
                } else {
                    if (this.annotList != null && this.annotList.length > n && this.annotList[n] != null) {
                        this.annotList[n].resetToStart();
                        if (this.formFactory.getType() == 3) {
                            HashMap<String, String> hashMap3 = new HashMap<String, String>();
                            n3 = this.annotList[n].getTokenCount();
                            for (int i = 0; i < n3; ++i) {
                                String string2 = this.annotList[n].getNextValueAsString(true);
                                hashMap3.put(string2, String.valueOf(i + 1));
                            }
                            this.formFactory.setAnnotOrder(hashMap3);
                        }
                        this.annotList[n].resetToStart();
                    }
                    n4 = n6 - 1;
                }
                for (int i = n4; i > -1; --i) {
                    byte[][] byArray;
                    String string3 = null;
                    if (n5 == 0) {
                        if (this.fieldList != null) {
                            string3 = this.fieldList.getNextValueAsString(true);
                        }
                    } else if (this.annotList.length > n && this.annotList[n] != null) {
                        string3 = this.annotList[n].getNextValueAsString(true);
                    }
                    if (string3 == null || string3 != null && (hashMap2.get(string3) != null || string3.length() == 0)) continue;
                    formObject = (FormObject)this.cachedObjs.get(string3);
                    if (formObject == null) {
                        formObject = new FormObject(string3, this.formsActionHandler, this.pageData.getRotation(n - 1));
                        if (string3.charAt(string3.length() - 1) == 'R') {
                            this.currentPdfFile.readObject(formObject);
                        } else {
                            formObject.setStatus(1);
                            formObject.setUnresolvedData(StringUtils.toBytes(string3), n2);
                            this.currentPdfFile.checkResolved(formObject);
                        }
                        this.cachedObjs.put(string3, formObject);
                    }
                    n8 = (byArray = formObject.getKeyArray(456733763)) != null ? this.flattenKids(n, bl, hashMap2, formObject, n8, n5) : this.processFormObject(n, bl, hashMap2, formObject, string3, n8, n5);
                }
            }
            if (this.hasXFA && this.fDecoder.hasXFADataSet()) {
                this.currentItems.clear();
                n5 = this.Fforms.length;
                FormObject[] formObjectArray2 = new FormObject[n5];
                for (n3 = 0; n3 < n5; ++n3) {
                    formObjectArray2[n3] = this.Fforms[n5 - n3 - 1];
                }
                formObjectArray = ((XFAFormStream)this.fDecoder).createAppearanceString(formObjectArray2);
                this.compData.storeXFARefToForm(((XFAFormStream)this.fDecoder).getRefToFormArray());
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            this.compData.setUnsortedListForPage(n, arrayList);
            int n9 = 3;
            for (n3 = 0; n3 < n9; ++n3) {
                int n10;
                n4 = 0;
                if (n3 == 0) {
                    if (formObjectArray != null) {
                        n4 = formObjectArray.length;
                    }
                } else if (n3 == 1) {
                    for (n10 = 0; n10 < this.Fforms.length; ++n10) {
                        if (this.Fforms[n10] == null) continue;
                        arrayList.add(this.Fforms[n10].getObjectRefAsString());
                    }
                    this.Fforms = FormUtils.sortGroupLargestFirst(this.Fforms);
                    n4 = this.Fforms.length;
                } else {
                    for (n10 = 0; n10 < this.Aforms.length; ++n10) {
                        if (this.Aforms[n10] == null) continue;
                        arrayList.add(this.Aforms[n10].getObjectRefAsString());
                    }
                    this.Aforms = FormUtils.sortGroupLargestFirst(this.Aforms);
                    n4 = this.Aforms.length;
                }
                for (n10 = 0; n10 < n4; ++n10) {
                    formObject = n3 == 0 ? formObjectArray[n10] : (n3 == 1 ? this.Fforms[n10] : this.Aforms[n10]);
                    if (formObject == null || hashMap.get(formObject.getObjectRefAsString()) != null || n != formObject.getPageNumber()) continue;
                    if (this.formsRasterizedForDisplay() && pdfStreamDecoder != null) {
                        try {
                            pdfStreamDecoder.drawFlattenedForm(formObject);
                        }
                        catch (PdfException pdfException) {
                            pdfException.printStackTrace();
                        }
                        continue;
                    }
                    this.createField(formObject, this.compData.getNextFreeField());
                    this.compData.storeRawData(formObject);
                    hashMap.put(formObject.getObjectRefAsString(), "x");
                }
            }
            if (!this.formsRasterizedForDisplay()) {
                if (this.formFactory.getType() == 3) {
                    this.formFactory.indexAllKids();
                }
                this.compData.completeFields(n, this);
            }
        }
    }

    private int flattenKids(int n, boolean bl, Map map, FormObject formObject, int n2, int n3) {
        Object object;
        int n4;
        byte[][] byArray = formObject.getKeyArray(456733763);
        int n5 = byArray.length;
        if (n3 == 0) {
            n4 = this.Fforms.length;
            object = this.Fforms;
            this.Fforms = new FormObject[n4 + n5 - 1];
            System.arraycopy(object, 0, this.Fforms, 0, n4);
        } else {
            n4 = this.Aforms.length;
            object = this.Aforms;
            this.Aforms = new FormObject[n4 + n5 - 1];
            System.arraycopy(object, 0, this.Aforms, 0, n4);
        }
        for (n4 = 0; n4 < n5; ++n4) {
            object = new String(byArray[n4]);
            FormObject formObject2 = new FormObject((String)object, null);
            if (formObject != null) {
                formObject2.copyInheritedValuesFromParent(formObject);
            }
            this.currentPdfFile.readObject(formObject2);
            formObject2.setHandler(this.formsActionHandler);
            formObject2.setRef((String)object);
            formObject2.setKid(true);
            if (formObject2.getKeyArray(456733763) == null) {
                String string = formObject2.toString(formObject2.getFloatArray(573911876), true);
                if (string == null || this.addItem(string)) {
                    new FormStream().createAppearanceString(formObject2, this.currentPdfFile);
                }
                n2 = this.processFormObject(n, bl, map, formObject2, object, n2, n3);
                continue;
            }
            n2 = this.flattenKids(n, bl, map, formObject2, n2, n3);
        }
        return n2;
    }

    private int processFormObject(int n, boolean bl, Map map, FormObject formObject, Object object, int n2, int n3) {
        Object object2;
        Object object3;
        boolean bl2 = false;
        if (n3 == 0) {
            FormObject formObject2;
            Object object4;
            object3 = formObject.getDictionary(32);
            object2 = null;
            if (object3 != null) {
                object2 = ((PdfObject)object3).getUnresolvedData();
            }
            if ((object2 == null || object3 == null) && (object4 = formObject.getStringKey(1110793845)) != null && (object3 = ((PdfObject)(formObject2 = this.getParent((String)object4))).getDictionary(32)) != null) {
                object2 = ((PdfObject)object3).getUnresolvedData();
            }
            if (object2 == null) {
                boolean bl3;
                object4 = this.getKid(formObject);
                boolean bl4 = bl3 = object4 != null && ((Object)object4).length > 0;
                if (bl3) {
                    int n4 = ((Object)object4).length;
                    for (int i = 0; i < n4; ++i) {
                        String string = new String((byte[])object4[i]);
                        FormObject formObject3 = (FormObject)this.cachedObjs.get(string);
                        if (formObject3 == null) {
                            formObject3 = new FormObject(string, this.formsActionHandler);
                            this.currentPdfFile.readObject(formObject3);
                            this.cachedObjs.put(string, formObject3);
                        }
                        if ((object3 = formObject3.getDictionary(32)) != null) {
                            object2 = ((PdfObject)object3).getUnresolvedData();
                        }
                        if (object2 == null) continue;
                        i = n4;
                    }
                }
            }
            int n5 = -1;
            if (object2 != null) {
                n5 = this.currentPdfFile.convertObjectToPageNumber(new String((byte[])object2));
            }
            boolean bl5 = bl2 = n5 == n;
        }
        if (n3 == 1 || bl2) {
            formObject.setPageNumber(n);
            this.cachedObjs.remove(object);
            object3 = formObject.getStringKey(1110793845);
            if (object3 != null && (object2 = (Object)this.getParent((String)object3)) != null) {
                formObject.setParent((String)object3, (FormObject)object2, true);
            }
            this.fDecoder.createAppearanceString(formObject, this.currentPdfFile);
            if (formObject != null) {
                if (object3 != null) {
                    formObject.setParent((String)object3);
                }
                if (n3 == 0) {
                    this.Fforms[n2++] = formObject;
                } else {
                    this.Aforms[n2++] = formObject;
                }
                if (object != null) {
                    map.put(object, "x");
                }
            }
        }
        return n2;
    }

    private FormObject getParent(String string) {
        Map map = this.compData.getRawFormData();
        FormObject formObject = (FormObject)map.get(string);
        if (formObject == null && string != null) {
            formObject = new FormObject(string, this.formsActionHandler);
            this.currentPdfFile.readObject(formObject);
            formObject.setKeyArray(456733763, new byte[][]{{0}});
            map.put(string, formObject);
        }
        return formObject;
    }

    private byte[][] getKid(FormObject formObject) {
        String string;
        PdfObject pdfObject;
        int n = formObject.getParameterConstant(1147962727);
        if (n == 9288 || n == 1197118) {
            return null;
        }
        byte[][] byArray = formObject.getKeyArray(456733763);
        if (byArray != null && (pdfObject = (PdfObject)this.compData.getRawForm(string = formObject.getStringKey(1110793845))[0]) != null && pdfObject.getKeyArray(456733763) != null) {
            byArray = null;
        }
        return byArray;
    }

    public Object[] getFormDataAsObject(String string) {
        return this.compData.getRawForm(string);
    }

    public void displayComponentsOnscreen(int n, int n2) {
        if (this.decode_pdf.getDisplayView() != 5) {
            this.removeDisplayComponentsFromScreen();
        }
        this.compData.displayComponents(n, ++n2);
    }

    private void createField(FormObject formObject, int n) {
        Object object;
        Integer n2;
        boolean[] blArray;
        int n3 = formObject.getParameterConstant(1147962727);
        if (n3 == 2308407) {
            if (this.sigObject == null) {
                this.sigObject = new HashSet();
            }
            this.sigObject.add(formObject);
        }
        if (formObject.getDictionary(1061176672) != null) {
            formObject.setActionFlag(1);
        }
        if ((blArray = formObject.getFieldFlags()) != null) {
            boolean bl = blArray[1];
            boolean bl2 = blArray[2];
            boolean bl3 = blArray[3];
        }
        if (n3 == 1197118) {
            boolean bl = false;
            boolean bl4 = false;
            if (blArray != null) {
                bl = blArray[17];
                bl4 = blArray[16];
            }
            if (bl) {
                n2 = FormFactory.PUSHBUTTON;
                object = this.formFactory.pushBut(formObject);
            } else if (bl4) {
                n2 = FormFactory.RADIOBUTTON;
                object = this.formFactory.radioBut(formObject);
            } else {
                n2 = FormFactory.CHECKBOXBUTTON;
                object = this.formFactory.checkBoxBut(formObject);
            }
        } else if (n3 == 9288) {
            boolean bl = false;
            boolean bl5 = false;
            if (blArray != null) {
                bl = blArray[13];
                bl5 = blArray[14];
            }
            if (bl) {
                if (bl5) {
                    n2 = FormFactory.MULTILINEPASSWORD;
                    object = this.formFactory.multiLinePassword(formObject);
                } else {
                    n2 = FormFactory.MULTILINETEXT;
                    object = this.formFactory.multiLineText(formObject);
                }
            } else if (bl5) {
                n2 = FormFactory.SINGLELINEPASSWORD;
                object = this.formFactory.singleLinePassword(formObject);
            } else {
                n2 = FormFactory.SINGLELINETEXT;
                object = this.formFactory.singleLineText(formObject);
            }
        } else if (n3 == 4920) {
            boolean bl = false;
            if (blArray != null) {
                bl = blArray[18];
            }
            if (bl) {
                n2 = FormFactory.COMBOBOX;
                object = this.formFactory.comboBox(formObject);
            } else {
                n2 = FormFactory.LIST;
                object = this.formFactory.listField(formObject);
            }
        } else if (n3 == 2308407) {
            n2 = FormFactory.SIGNATURE;
            object = this.formFactory.signature(formObject);
        } else {
            n2 = FormFactory.ANNOTATION;
            object = this.formFactory.annotationButton(formObject);
        }
        formObject.setFormType(n2);
        this.compData.completeField(formObject, n, n2, object, this.currentPdfFile);
    }

    public Object[] getComponentsByName(String string) {
        for (int i = 1; i < this.pageCount + 1; ++i) {
            this.createDisplayComponentsForPage(i, null);
        }
        return this.compData.getComponentsByName(string);
    }

    public List getComponentNameList() throws PdfException {
        if (this.ATotalCount == 0 && this.FfieldCount == 0) {
            return null;
        }
        boolean bl = this.compData.formsRasterizedForDisplay();
        this.compData.setRasterizeForms(false);
        for (int i = 1; i < this.pageCount + 1; ++i) {
            this.createDisplayComponentsForPage(i, null);
        }
        this.compData.setRasterizeForms(bl);
        return this.getComponentNameList(-1);
    }

    public List getComponentNameList(int n) throws PdfException {
        if (this.FfieldCount == 0 && this.ATotalCount == 0) {
            return null;
        }
        return this.compData.getComponentNameList(n);
    }

    public void setFormFactory(FormFactory formFactory) {
        this.formFactory = formFactory;
        this.formsActionHandler.setActionFactory(this.formFactory.getActionFactory());
        this.compData = this.formFactory.getCustomCompData();
        this.compData.setJavascript(this.javascript);
    }

    public void openFile(int n) {
        this.pageCount = n;
        this.compData.reset(null);
        this.proxyObjects.clear();
        this.compData.flushFormData();
        this.cachedObjs.clear();
    }

    public GUIData getCompData() {
        return this.compData;
    }

    public Iterator getSignatureObjects() {
        if (this.sigObject == null) {
            return null;
        }
        return this.sigObject.iterator();
    }

    public ActionHandler getActionHandler() {
        return this.formsActionHandler;
    }

    public FormFactory getFormFactory() {
        return this.formFactory;
    }

    public Map getRawFormData() {
        return this.compData.getRawFormData();
    }

    public void setIgnoreForms(boolean bl) {
        this.ignoreForms = bl;
    }

    public boolean ignoreForms() {
        return this.ignoreForms;
    }

    public void dispose() {
        this.pageData = null;
        this.AfieldCount = null;
        this.fDecoder = null;
        this.formsActionHandler = null;
        this.javascript = null;
        this.Fforms = null;
        this.Aforms = null;
        this.fieldList = null;
        this.annotList = null;
        this.formFactory = null;
        this.compData = null;
        this.proxyObjects.clear();
        this.sigObject = null;
        this.cachedObjs = null;
        this.pageData = null;
        this.currentPdfFile = null;
        this.fDecoder = null;
        this.acroObj = null;
    }

    public Javascript getJavaScriptObject() {
        return this.javascript;
    }

    public PdfArrayIterator getAnnotsOnPage(int n) {
        if (n < 1 || n > this.decode_pdf.getPageCount()) {
            throw new RuntimeException("Page " + n + " out of range (1 - " + this.decode_pdf.getPageCount() + ")");
        }
        this.createDisplayComponentsForPage(n, null);
        if (this.annotList != null && this.annotList.length > n && this.annotList[n] != null) {
            this.annotList[n].resetToStart();
            return this.annotList[n];
        }
        return null;
    }

    private boolean addItem(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.currentItems.containsKey(object)) {
            this.currentItems.put(object, "x");
            return true;
        }
        return false;
    }

    public void updateChangedForms() {
        Map map = this.compData.getRawFormData();
        if (map.size() > 1) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                FormObject formObject = (FormObject)map.get(iterator.next());
                if (formObject == null) continue;
                if (formObject.hasColorChanged()) {
                    this.compData.setTextColor(formObject.getObjectRefAsString(), formObject.getTextColor());
                    this.compData.invalidate(formObject.getTextStreamValue(36));
                    formObject.resetColorChanged();
                }
                if (formObject.hasValueChanged()) {
                    object = formObject.getObjectRefAsString();
                    this.compData.setUnformattedValue((String)object, this.compData.getValue(object));
                    this.compData.setValue(formObject.getObjectRefAsString(), formObject.getValue(), false, false);
                    this.compData.invalidate(formObject.getTextStreamValue(36));
                    formObject.resetFormChanged();
                }
                if (!formObject.hasDisplayChanged()) continue;
                object = formObject.getCharacteristics();
                if (object[0] != false || object[1] != false || object[5] != false) {
                    this.compData.setCompVisible(formObject.getObjectRefAsString(), false);
                    continue;
                }
                this.compData.setCompVisible(formObject.getObjectRefAsString(), true);
            }
        }
    }

    public String[] getChildNames(String string) {
        return this.compData.getChildNames(string);
    }

    public Object getField(String string) {
        if (string == null) {
            return null;
        }
        return this.compData.getRawForm(string);
    }

    public void resetForm() {
        this.resetForm(null);
    }

    public void resetForm(String[] stringArray) {
        this.formsActionHandler.getActionFactory().reset(stringArray);
    }

    public int getPageNum() {
        SwingGUI swingGUI = (SwingGUI)this.decode_pdf.getExternalHandler(11);
        if (swingGUI != null) {
            return swingGUI.getCurrentPage();
        }
        return 1;
    }

    public void setPageNum(int n) {
        this.formsActionHandler.changeTo(null, ++n, null, null, true);
    }

    public void setZoomType(String string) {
        if (string.equals("FitPage")) {
            this.formsActionHandler.changeTo(null, -1, null, new Integer(-3), true);
        } else if (string.equals("FitWidth")) {
            this.formsActionHandler.changeTo(null, -1, null, new Integer(-1), true);
        } else if (string.equals("FitHeight")) {
            this.formsActionHandler.changeTo(null, -1, null, new Integer(-2), true);
        }
    }

    public boolean getDirty() {
        SwingGUI swingGUI = (SwingGUI)this.decode_pdf.getExternalHandler(11);
        if (swingGUI != null) {
            return swingGUI.getFormsDirtyFlag();
        }
        return false;
    }

    public void setDirty(boolean bl) {
        SwingGUI swingGUI = (SwingGUI)this.decode_pdf.getExternalHandler(11);
        if (swingGUI != null) {
            swingGUI.setFormsDirtyFlag(bl);
        }
    }

    public boolean hasFormsOnPage(int n) {
        boolean bl = this.annotList != null && this.annotList.length > n && this.annotList[n] != null;
        boolean bl2 = this.hasXFA && this.fDecoder.hasXFADataSet() || this.fieldList != null;
        return bl || bl2;
    }

    public PdfObject getFormResources() {
        return this.AcroRes;
    }

    public boolean formsRasterizedForDisplay() {
        return this.compData.formsRasterizedForDisplay();
    }
}

