/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.jpedal.io.RandomAccessBuffer;

public class RandomAccessFileChannelBuffer
implements RandomAccessBuffer {
    private long pointer;
    private int length = 0;
    private ByteBuffer mb;

    public RandomAccessFileChannelBuffer(InputStream inputStream) {
        try {
            int n;
            this.length = inputStream.available();
            this.mb = ByteBuffer.allocate(this.length);
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                if (n <= 0) continue;
                for (int i = 0; i < n; ++i) {
                    this.mb.put(byArray[i]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public long getFilePointer() throws IOException {
        return this.pointer;
    }

    public void seek(long l) throws IOException {
        if (!this.checkPos(l)) {
            throw new IOException("Position out of bounds");
        }
        this.pointer = l;
    }

    public void close() throws IOException {
        if (this.mb != null) {
            this.mb = null;
        }
        this.pointer = -1L;
    }

    public void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public long length() throws IOException {
        if (this.mb != null) {
            return this.length;
        }
        throw new IOException("Data buffer not initialized.");
    }

    public int read() throws IOException {
        if (this.checkPos(this.pointer)) {
            this.mb.position((int)this.pointer);
            ++this.pointer;
            return this.mb.get();
        }
        return -1;
    }

    private int peek() throws IOException {
        if (this.checkPos(this.pointer)) {
            this.mb.position((int)this.pointer);
            return this.mb.get();
        }
        return -1;
    }

    public String readLine() throws IOException {
        int n;
        if (this.pointer >= (long)(this.length - 1)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.read()) >= 0) {
            if (n == 10 || n == 13) {
                if (this.peek() != 10 && this.peek() != 13 || this.peek() == n) break;
                this.read();
                break;
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public int read(byte[] byArray) throws IOException {
        if (this.mb == null) {
            throw new IOException("Data buffer not initialized.");
        }
        if (this.pointer < 0L || this.pointer >= (long)this.length) {
            return -1;
        }
        int n = this.length - (int)this.pointer;
        if (n > byArray.length) {
            n = byArray.length;
        }
        for (int i = 0; i < n; ++i) {
            this.mb.position((int)this.pointer);
            ++this.pointer;
            byArray[i] = this.mb.get();
        }
        return n;
    }

    private static int b2i(byte by) {
        if (by >= 0) {
            return by;
        }
        return 256 + by;
    }

    private boolean checkPos(long l) throws IOException {
        return l >= 0L && l < this.length();
    }

    public byte[] getPdfBuffer() {
        byte[] byArray = new byte[this.length];
        this.mb.position(0);
        this.mb.get(byArray);
        return byArray;
    }
}

