/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.modules.objectbindings.internal;

import de.rcenvironment.toolkit.modules.introspection.api.StatusCollectionContributor;
import de.rcenvironment.toolkit.modules.introspection.api.StatusCollectionRegistry;
import de.rcenvironment.toolkit.modules.objectbindings.api.ObjectBindingsConsumer;
import de.rcenvironment.toolkit.modules.objectbindings.api.ObjectBindingsService;
import de.rcenvironment.toolkit.utils.common.AutoCreationMap;
import de.rcenvironment.toolkit.utils.internal.StringUtils;
import de.rcenvironment.toolkit.utils.text.TextLinesReceiver;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectBindingsServiceImpl
implements ObjectBindingsService {
    private final Map<Class<?>, ObjectBindingsConsumer<?>> consumers = new HashMap();
    private final AutoCreationMap<Class<?>, List<Object>> bindingLists = new AutoCreationMap<Class<?>, List<Object>>(){

        @Override
        protected List<Object> createNewEntry(Class<?> key) {
            return new LinkedList<Object>();
        }
    };
    private final Log log = LogFactory.getLog(this.getClass());

    public ObjectBindingsServiceImpl(StatusCollectionRegistry statusCollectionRegistry) {
        statusCollectionRegistry.addContributor(new StatusCollectionContributor(){

            @Override
            public void printUnfinishedOperationsInformation(TextLinesReceiver receiver) {
            }

            @Override
            public void printDefaultStateInformation(TextLinesReceiver receiver) {
                ObjectBindingsServiceImpl.this.printStatus(receiver);
            }

            @Override
            public String getUnfinishedOperationsDescription() {
                return null;
            }

            @Override
            public String getStandardDescription() {
                return "Object Bindings";
            }
        });
    }

    @Override
    public synchronized <T> void addBinding(Class<T> bindingClass, T instance, Object owner) {
        ObjectBindingsConsumer<T> existingConsumer = this.getExistingConsumer(bindingClass);
        this.bindingLists.get(bindingClass).add(instance);
        this.log.debug((Object)StringUtils.format("Added binding for %s: %s", bindingClass.getName(), instance.toString()));
        if (existingConsumer != null) {
            this.log.debug((Object)StringUtils.format("Reporting new binding for %s to existing consumer %s", bindingClass.getName(), existingConsumer.toString()));
            existingConsumer.addInstance(instance);
        }
    }

    @Override
    public synchronized <T> void removeBinding(Class<T> bindingClass, T instance) {
        List<Object> bindingList = this.bindingLists.get(bindingClass);
        if (!this.removeByIdentity(instance, bindingList)) {
            throw new IllegalStateException("This object instance was not registered/bound before: " + instance);
        }
        this.log.debug((Object)StringUtils.format("Removed binding for %s: %s", bindingClass.getName(), instance.toString()));
        ObjectBindingsConsumer<T> existingConsumer = this.getExistingConsumer(bindingClass);
        if (existingConsumer != null) {
            this.log.debug((Object)StringUtils.format("Reporting removal of binding for %s to existing consumer %s", bindingClass.getName(), existingConsumer.toString()));
            existingConsumer.removeInstance(instance);
        }
    }

    @Override
    public synchronized void removeAllBindingsOfOwner(Object owner) {
        this.log.debug((Object)"Note: batch removal of bindings not implemented yet");
    }

    @Override
    public synchronized <T> void setConsumer(Class<T> bindingClass, ObjectBindingsConsumer<T> newConsumer) {
        List<Object> boundInstances = this.bindingLists.get(bindingClass);
        ObjectBindingsConsumer<Object> previousConsumer = this.getExistingConsumer(bindingClass);
        if (previousConsumer != null) {
            for (Object instance : boundInstances) {
                previousConsumer.removeInstance(instance);
            }
        }
        if (newConsumer != null) {
            for (Object instance : boundInstances) {
                newConsumer.addInstance(instance);
            }
        }
        this.log.debug((Object)StringUtils.format("Setting the consumer of %s instances to %s", bindingClass.getName(), newConsumer));
        this.consumers.put(bindingClass, newConsumer);
    }

    private <T> ObjectBindingsConsumer<T> getExistingConsumer(Class<T> bindingClass) {
        return this.consumers.get(bindingClass);
    }

    private <T> boolean removeByIdentity(T instance, List<Object> bindingList) {
        Iterator<Object> iterator = bindingList.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != instance) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    private synchronized void printStatus(TextLinesReceiver receiver) {
        for (Map.Entry<Class<?>, List<Object>> e : this.bindingLists.getImmutableShallowCopy().entrySet()) {
            Class<?> clazz = e.getKey();
            ObjectBindingsConsumer<?> consumer = this.consumers.get(clazz);
            String consumedBy = consumer != null ? consumer.getClass().getName() : "<none>";
            receiver.addLine(StringUtils.format("%s  (consumed by %s)", clazz.getName(), consumedBy));
            for (Object instance : e.getValue()) {
                receiver.addLine(StringUtils.format("  - %s", instance.getClass().getName()));
            }
        }
    }
}

