/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.incubator.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public final class XMLIOSupport {
    private XMLIOSupport() {
    }

    public static Document readXML(InputStream xmlInputStream) throws DocumentException {
        SAXReader saxReader = new SAXReader();
        saxReader.setMergeAdjacentText(true);
        saxReader.setStringInternEnabled(true);
        saxReader.setStripWhitespaceText(true);
        Document document = saxReader.read(xmlInputStream);
        return document;
    }

    public static Document readXML(String filename) throws DocumentException {
        return XMLIOSupport.readXML(new File(filename));
    }

    public static Document readXML(File file) throws DocumentException {
        SAXReader saxReader = new SAXReader();
        saxReader.setMergeAdjacentText(true);
        saxReader.setStringInternEnabled(true);
        saxReader.setStripWhitespaceText(true);
        Document document = saxReader.read(file);
        return document;
    }

    public static Document readXML(String schema, String xml) throws SAXException, IOException, DocumentException {
        return XMLIOSupport.readXML(new File(schema), new File(xml));
    }

    public static Document readXML(File schemaFile, File xmlFile) throws SAXException, IOException, DocumentException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        validator.validate(new StreamSource(xmlFile));
        return XMLIOSupport.readXML(xmlFile);
    }
}

