/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common;

import de.rcenvironment.core.utils.common.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

public final class VersionUtils {
    public static final String VERSION_TYPE_RELEASE = "Release";
    public static final String VERSION_TYPE_SNAPSHOT = "Snapshot";
    public static final String VERSION_TYPE_RELEASE_CANDIDATE = "Release_Candidate";
    public static final String VERSION_TYPE_DEVELOPMENT = "Development";
    private static final String VERSION_INFO_RCE_STANDARD = "de.rcenvironment.core.gui.branding.default.versioninfo";
    private static final String PLATFORM_BUNDLES_PREFIX = "de.rcenvironment.platform.";
    private static final Class<?> OWN_CLASS = VersionUtils.class;

    private VersionUtils() {
    }

    public static Version getVersionOfCoreBundles() {
        Bundle ownBundle = FrameworkUtil.getBundle(OWN_CLASS);
        if (ownBundle == null) {
            return null;
        }
        Version coreVersion = ownBundle.getVersion();
        return coreVersion;
    }

    public static Version getVersionOfPlatformBundles() {
        Log log = LogFactory.getLog(OWN_CLASS);
        Bundle ownBundle = FrameworkUtil.getBundle(OWN_CLASS);
        if (ownBundle == null) {
            log.debug((Object)"No BundleContext available (most likely because we are running in a unit test); returning 'null' version");
            return null;
        }
        Bundle[] bundles = ownBundle.getBundleContext().getBundles();
        Version version = null;
        if (bundles == null) {
            log.error((Object)"Unexpected error: 'null' bundle list while getting platform version; returning 'null' version");
            return null;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getSymbolicName().startsWith(PLATFORM_BUNDLES_PREFIX)) {
                Version newVersion = bundle.getVersion();
                if (version != null && !version.equals((Object)newVersion)) {
                    log.error((Object)("Found more that one platform version: " + newVersion + " and " + version));
                }
                version = newVersion;
            }
            ++n2;
        }
        return version;
    }

    public static Version getVersionOfProduct() {
        Log log = LogFactory.getLog(OWN_CLASS);
        Bundle ownBundle = FrameworkUtil.getBundle(OWN_CLASS);
        if (ownBundle == null) {
            log.debug((Object)"No BundleContext available (most likely because we are running in a unit test); returning 'null' version");
            return null;
        }
        Bundle[] bundles = ownBundle.getBundleContext().getBundles();
        Version version = null;
        if (bundles == null) {
            log.error((Object)"Unexpected error: 'null' bundle list while getting product version; returning 'null' version");
            return null;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getSymbolicName().startsWith(VERSION_INFO_RCE_STANDARD)) {
                version = bundle.getVersion();
                break;
            }
            ++n2;
        }
        return version;
    }

    public static String getVersionAsString(Version version) {
        String versionNumber = String.valueOf(version.getMajor()) + "." + version.getMinor() + "." + version.getMicro();
        String versionQualifier = version.getQualifier();
        String versionType = VersionUtils.getVersionType(versionQualifier);
        if (versionType == VERSION_TYPE_RELEASE) {
            return versionNumber;
        }
        return StringUtils.format("%s_%s", versionNumber, versionType);
    }

    public static String getVersionType(String versionQualifier) {
        String versionType = VERSION_TYPE_RELEASE;
        if (versionQualifier.endsWith("_RC")) {
            versionType = VERSION_TYPE_RELEASE_CANDIDATE;
        } else if (versionQualifier.endsWith("_SNAPSHOT")) {
            versionType = VERSION_TYPE_SNAPSHOT;
        } else if (versionQualifier.endsWith("qualifier")) {
            versionType = VERSION_TYPE_DEVELOPMENT;
        }
        return versionType;
    }

    public static String getBuildIdAsString(Version version) {
        if (version.getQualifier().endsWith("qualifier")) {
            return null;
        }
        return version.getQualifier().split("^" + version.getMajor() + "\\." + version.getMinor() + "\\." + version.getMicro())[0];
    }

    public static boolean isReleaseOrReleaseCandidateBuild() {
        Version version = VersionUtils.getVersionOfCoreBundles();
        String versionQualifier = version.getQualifier();
        String versionType = VersionUtils.getVersionType(versionQualifier);
        return VERSION_TYPE_RELEASE.equals(versionType) || VERSION_TYPE_RELEASE_CANDIDATE.equals(versionType);
    }
}

